/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.reference;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.client.impl.ClientFactoryImpl;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;
import org.eclipse.jst.j2ee.internal.reference.ServiceReferenceDataModel;
import org.eclipse.jst.j2ee.internal.webservices.WebServiceClientGenerator;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataRegistry;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.internal.wsclient.Webservice_clientPackage;
import org.eclipse.jst.j2ee.webservice.wsclient.ComponentScopedRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesClient;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientFactory;
import org.eclipse.wst.common.componentcore.internal.operation.ModelModifierOperation;
import org.eclipse.wst.common.componentcore.internal.operation.ModelModifierOperationDataModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class ServiceReferenceCreationOperation
extends ModelModifierOperation {
    ServiceReferenceDataModel dataModel;
    ServiceRef ref;
    private int j2eeVersion = 14;

    public ServiceReferenceCreationOperation(ServiceReferenceDataModel dataModel) {
        super((ModelModifierOperationDataModel)dataModel);
        this.dataModel = dataModel;
    }

    protected void addHelpers() {
        WebServiceClientGenerator actualGen = this.getWebServiceClientGenerator();
        if (actualGen != null) {
            actualGen.genWebServiceClientArtifacts(this.dataModel);
        }
        if (!this.dataModel.didGenDescriptors()) {
            this.modifier.addHelper(this.createHelpers());
        }
        if (actualGen != null) {
            this.createPortCompRefHelpers();
        }
    }

    protected WebServiceClientGenerator getWebServiceClientGenerator() {
        List generators = WebServicesClientDataRegistry.getInstance().getWSClientGeneratorExtensions();
        WebServiceClientGenerator actualGen = null;
        IRuntime runtime = ServerCore.getProjectProperties((IProject)this.dataModel.getTargetProject()).getRuntimeTarget();
        if (runtime == null) {
            return null;
        }
        String serverTargetID = runtime.getRuntimeType().getId();
        int i = 0;
        while (i < generators.size()) {
            WebServiceClientGenerator gen = (WebServiceClientGenerator)generators.get(i);
            if (gen.isRuntimeSupported(serverTargetID)) {
                if (serverTargetID.equals(WebServiceClientGenerator.GENERIC_J2EE_CONTAINER) && this.dataModel.getDeploymentDescriptorType() != 4) break;
                actualGen = gen;
                break;
            }
            ++i;
        }
        return actualGen;
    }

    public ModifierHelper createHelpers() {
        ModifierHelper helper = null;
        this.ref = Webservice_clientFactory.eINSTANCE.createServiceRef();
        if (this.dataModel != null) {
            helper = new ModifierHelper();
            EObject owner = (EObject)this.dataModel.getProperty("ReferenceDataModel.OWNER");
            switch (this.dataModel.getDeploymentDescriptorType()) {
                case 1: {
                    Description descriptionObj;
                    if (((ApplicationClient)owner).getVersionID() == 14) {
                        helper.setFeature((EStructuralFeature)ClientFactoryImpl.getPackage().getApplicationClient_ServiceRefs());
                        helper.setOwner(owner);
                        descriptionObj = CommonFactory.eINSTANCE.createDescription();
                        descriptionObj.setValue(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                        this.ref.getDescriptions().add((Object)descriptionObj);
                        this.ref.setDescription(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                        break;
                    }
                    helper.setFeature((EStructuralFeature)Webservice_clientPackage.eINSTANCE.getWebServicesClient_ServiceRefs());
                    this.ref.setDescription(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                    this.j2eeVersion = 13;
                    break;
                }
                case 3: {
                    Description descriptionObj;
                    if (((EnterpriseBean)owner).getVersionID() == 21) {
                        helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_ServiceRefs());
                        helper.setOwner(owner);
                        descriptionObj = CommonFactory.eINSTANCE.createDescription();
                        descriptionObj.setValue(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                        this.ref.getDescriptions().add((Object)descriptionObj);
                        this.ref.setDescription(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                        break;
                    }
                    this.j2eeVersion = 13;
                    return this.createEJB13Helper(owner, helper);
                }
                case 4: {
                    Description descriptionObj;
                    if (((WebApp)owner).getVersionID() == 24) {
                        helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_ServiceRefs());
                        helper.setOwner(owner);
                        descriptionObj = CommonFactory.eINSTANCE.createDescription();
                        descriptionObj.setValue(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                        this.ref.getDescriptions().add((Object)descriptionObj);
                        this.ref.setDescription(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                        break;
                    }
                    helper.setFeature((EStructuralFeature)Webservice_clientPackage.eINSTANCE.getWebServicesClient_ServiceRefs());
                    this.ref.setDescription(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                    this.j2eeVersion = 13;
                }
            }
        }
        this.ref.setServiceRefName(this.dataModel.getStringProperty("ReferenceDataModel.REF_NAME").trim());
        String serviceInterfaceName = this.dataModel.getServiceInterfaceName();
        this.ref.setServiceInterface((JavaClass)JavaRefFactory.eINSTANCE.reflectType(serviceInterfaceName, (EObject)this.dataModel.getProperty("ReferenceDataModel.OWNER")));
        this.ref.setWsdlFile(this.dataModel.getStringProperty("ServiceReferenceDataModel.WSDL_FILE").trim());
        if (this.dataModel.getStringProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE") != null && !this.dataModel.getStringProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE").equals("")) {
            this.ref.setJaxrpcMappingFile(this.dataModel.getStringProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE").trim());
        }
        QName qName = ((CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi")).getCommonFactory().createQName();
        if (this.j2eeVersion == 13) {
            qName.setLocalPart(this.dataModel.getStringProperty("ServiceReferenceDataModel.QNAME_lOCAL_PART"));
            qName.setNamespaceURI(this.dataModel.getStringProperty("ServiceReferenceDataModel.QNAME_NAMESPACE_URI"));
        } else {
            qName.setValues("prefix", this.dataModel.getStringProperty("ServiceReferenceDataModel.QNAME_NAMESPACE_URI"), this.dataModel.getStringProperty("ServiceReferenceDataModel.QNAME_lOCAL_PART"));
        }
        this.ref.setServiceQname(qName);
        this.ref.setDescription(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
        helper.setValue((Object)this.ref);
        return helper;
    }

    public void createPortCompRefHelpers() {
        ModifierHelper helper = null;
        if (this.dataModel != null) {
            helper = new ModifierHelper();
            String[] serEndpoints = this.dataModel.getServiceEndpointInterfaceNames();
            if (serEndpoints == null || serEndpoints.length == 0) {
                return;
            }
            int i = 0;
            while (i < serEndpoints.length) {
                PortComponentRef portCompRef = Webservice_clientFactory.eINSTANCE.createPortComponentRef();
                helper.setOwner((EObject)this.ref);
                String serviceEndpointInterface = serEndpoints[i];
                portCompRef.setServiceEndpointInterface((JavaClass)JavaRefFactory.eINSTANCE.reflectType(serviceEndpointInterface, (EObject)this.dataModel.getProperty("ReferenceDataModel.OWNER")));
                helper.setFeature((EStructuralFeature)Webservice_clientPackage.eINSTANCE.getServiceRef_PortComponentRefs());
                helper.setValue((Object)portCompRef);
                this.modifier.addHelper(helper);
                ++i;
            }
        }
    }

    private ModifierHelper createEJB13Helper(EObject ownerEJB, ModifierHelper helper) {
        return null;
    }

    private ComponentScopedRefs getComponentScopedRef(EnterpriseBean ownerEJB, WebServicesClient webServiceClient) {
        EList existingRefs = webServiceClient.getComponentScopedRefs();
        if (existingRefs != null) {
            int i = 0;
            while (i < existingRefs.size()) {
                if (((ComponentScopedRefs)existingRefs.get(i)).getComponentName().equals(ownerEJB.getName())) {
                    return (ComponentScopedRefs)existingRefs.get(i);
                }
                ++i;
            }
        }
        return null;
    }
}

