/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class WizardShortcutAction
extends Action
implements IPluginContribution {
    private IWizardDescriptor descriptor;
    private IWorkbenchWindow window;

    public WizardShortcutAction(IWorkbenchWindow window, IWizardDescriptor aDescriptor) {
        super(aDescriptor.getLabel());
        this.descriptor = aDescriptor;
        this.setToolTipText(this.descriptor.getDescription());
        this.setImageDescriptor(this.descriptor.getImageDescriptor());
        this.setId(ActionFactory.NEW.getId());
        this.window = window;
    }

    public void run() {
        IWorkbenchWizard wizard;
        try {
            wizard = this.descriptor.createWizard();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.NewProjectWizard_errorTitle, (String)IDEWorkbenchMessages.NewProjectAction_text, (IStatus)e.getStatus());
            return;
        }
        ISelection selection = this.window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            wizard.init(this.window.getWorkbench(), (IStructuredSelection)selection);
        } else {
            wizard.init(this.window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        }
        Shell parent = this.window.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        WorkbenchHelp.setHelp((Control)dialog.getShell(), (String)"org.eclipse.ui.new_wizard_shortcut_context");
        dialog.open();
    }

    public String getLocalId() {
        return this.descriptor.getId();
    }

    public String getPluginId() {
        return this.descriptor.getId();
    }
}

