/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel.tld;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMAttributeDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMElementDeclarationImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDFunctionImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDInitParamImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDListenerImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDValidatorImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDVariableImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDFunction;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDInitParam;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDListener;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDValidator;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDVariable;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.factory.CMDocumentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDocumentFactoryTLD
implements CMDocumentFactory {
    static final boolean _debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/tldcmdocument/factory"));

    public CMDocument buildCMDocument(String baselocation, InputStream input) {
        DocumentProvider provider = new DocumentProvider();
        provider.setValidating(false);
        provider.setRootElementName("taglib");
        provider.setInputStream(input);
        if (baselocation != null) {
            provider.setBaseReference(baselocation);
        }
        return this.loadDocument(baselocation, provider.getRootElement());
    }

    private CMDocument buildCMDocumentFromDirectory(File directory) {
        if (_debug) {
            System.out.println("not implemented: tagdir loading for " + directory.getAbsolutePath());
        }
        return null;
    }

    protected CMDocument buildCMDocumentFromFile(String fileName) {
        DocumentProvider provider = new DocumentProvider();
        provider.setValidating(false);
        provider.setBaseReference(fileName);
        provider.setRootElementName("taglib");
        provider.setFileName(fileName);
        Node rootElement = provider.getRootElement();
        return this.loadDocument(fileName, rootElement);
    }

    protected CMDocument buildCMDocumentFromJar(String jarFileName) {
        return this.buildCMDocumentFromJar(jarFileName, "META-INF/taglib.tld");
    }

    protected CMDocument buildCMDocumentFromJar(String jarFileName, String contentFileName) {
        DocumentProvider provider = new DocumentProvider();
        provider.setValidating(false);
        provider.setBaseReference(jarFileName);
        provider.setRootElementName("taglib");
        provider.setJarFileName(jarFileName);
        provider.setFileName(contentFileName);
        CMDocument document = this.loadDocument("jar:file://" + jarFileName + "!" + contentFileName, provider.getRootElement());
        return document;
    }

    protected CMAttributeDeclaration createAttributeDeclaration(CMDocument document, Node attrNode) {
        CMAttributeDeclarationImpl attr = new CMAttributeDeclarationImpl(document);
        Node child = attrNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("name") && child.hasChildNodes()) {
                    attr.setNodeName(this.getContainedText(child));
                } else if (child.getNodeName().equals("description") && child.hasChildNodes()) {
                    attr.setDescription(this.getContainedText(child));
                } else if (child.getNodeName().equals("id") && child.hasChildNodes()) {
                    attr.setId(this.getContainedText(child));
                } else if (child.getNodeName().equals("required") && child.hasChildNodes()) {
                    attr.setRequiredString(this.getContainedText(child));
                } else if (child.getNodeName().equals("rtexprvalue") && child.hasChildNodes()) {
                    attr.setRtexprvalue(this.getContainedText(child));
                } else if (child.getNodeName().equals("fragment") && child.hasChildNodes()) {
                    attr.setFragment(Boolean.valueOf(this.getContainedText(child)));
                }
            }
            child = child.getNextSibling();
        }
        return attr;
    }

    public CMDocument createCMDocument(String uri) {
        CMDocument result = null;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            result = this.createCMDocumentFromFile(uri);
        }
        if (result == null && url != null) {
            InputStream istream = null;
            if (url.getProtocol().equals("file")) {
                result = this.createCMDocumentFromFile(url.getFile());
            } else {
                try {
                    istream = url.openStream();
                    result = this.buildCMDocument(url.toExternalForm(), istream);
                }
                catch (Exception exception) {}
            }
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (result == null) {
            result = new CMDocumentImpl();
        }
        return result;
    }

    private CMDocument createCMDocumentFromFile(String fileName) {
        CMDocument result = null;
        File file = new File(fileName);
        try {
            if (file.isDirectory()) {
                result = this.buildCMDocumentFromDirectory(file);
            }
        }
        catch (SecurityException securityException) {
            result = null;
        }
        if (result == null) {
            result = fileName.endsWith(".jar") ? this.buildCMDocumentFromJar(fileName) : this.buildCMDocumentFromFile(fileName);
        }
        return result;
    }

    protected CMElementDeclaration createElementDeclaration(CMDocument cmdocument, Element tagFileNode, String path) {
        CMElementDeclarationImpl ed = new CMElementDeclarationImpl(cmdocument);
        boolean hasName = false;
        Node child = tagFileNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("description") && child.hasChildNodes()) {
                    ed.setDescription(this.getContainedText(child));
                } else if (nodeName.equals("display-name") && child.hasChildNodes()) {
                    ed.setDisplayName(this.getContainedText(child));
                } else if (nodeName.equals("example") && child.hasChildNodes()) {
                    ed.setExample(this.getContainedText(child));
                } else if (nodeName.equals("icon") && child.hasChildNodes()) {
                    ed.setSmallIcon(this.getContainedText(child));
                } else if (nodeName.equals("name") && child.hasChildNodes()) {
                    ed.setNodeName(this.getContainedText(child));
                    hasName = ed.getNodeName().trim().length() > 0;
                } else if (nodeName.equals("path") && child.hasChildNodes()) {
                    ed.setPath(this.getContainedText(child));
                } else if (nodeName.equals("tag-extension")) {
                    ed.getExtensions().add(child);
                }
            }
            child = child.getNextSibling();
        }
        if (hasName) {
            return ed;
        }
        return null;
    }

    protected CMElementDeclaration createElementDeclaration(CMDocument document, Node tagNode) {
        CMElementDeclarationImpl ed = new CMElementDeclarationImpl(document);
        Node child = tagNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("name") && child.hasChildNodes()) {
                    ed.setNodeName(this.getContainedText(child));
                } else if ((nodeName.equals("tagclass") || nodeName.equals("tag-class")) && child.hasChildNodes()) {
                    ed.setTagclass(this.getContainedText(child));
                } else if ((nodeName.equals("teiclass") || nodeName.equals("tei-class")) && child.hasChildNodes()) {
                    ed.setTeiclass(this.getContainedText(child));
                } else if ((nodeName.equals("bodycontent") || nodeName.equals("body-content")) && child.hasChildNodes()) {
                    String bodycontent = this.getContainedText(child);
                    if (bodycontent.equalsIgnoreCase("JSP")) {
                        ed.setBodycontent("JSP");
                    } else if (bodycontent.equalsIgnoreCase("tagdependent")) {
                        ed.setBodycontent("tagdependent");
                    } else if (bodycontent.equalsIgnoreCase("empty")) {
                        ed.setBodycontent("empty");
                    } else if (bodycontent.equalsIgnoreCase("scriptless")) {
                        ed.setBodycontent("scriptless");
                    }
                } else if ((nodeName.equals("info") || nodeName.equals("description")) && child.hasChildNodes()) {
                    ed.setDescription(this.getContainedText(child));
                } else if (nodeName.equals("attribute")) {
                    CMAttributeDeclaration attr = this.createAttributeDeclaration(document, child);
                    ed.attributes.setNamedItem(attr.getAttrName(), (CMNode)attr);
                } else if (nodeName.equals("variable")) {
                    ed.getVariables().add(this.createVariable(child));
                } else if (nodeName.equals("large-icon") && child.hasChildNodes()) {
                    ed.setLargeIcon(this.getContainedText(child));
                } else if (nodeName.equals("small-icon") && child.hasChildNodes()) {
                    ed.setSmallIcon(this.getContainedText(child));
                } else if (nodeName.equals("tag-extension") && child.getNodeType() == 1) {
                    ed.getExtensions().add(child);
                }
            }
            child = child.getNextSibling();
        }
        return ed;
    }

    protected TLDFunction createFunction(CMDocument document, Node functionNode) {
        TLDFunctionImpl function = new TLDFunctionImpl(document);
        boolean hasName = false;
        Node child = functionNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("description") && child.hasChildNodes()) {
                    function.setDescription(this.getContainedText(child));
                } else if (nodeName.equals("display-name") && child.hasChildNodes()) {
                    function.setName(this.getContainedText(child));
                } else if (nodeName.equals("example") && child.hasChildNodes()) {
                    function.setExample(this.getContainedText(child));
                } else if (nodeName.equals("function-class") && child.hasChildNodes()) {
                    function.setClassName(this.getContainedText(child));
                } else if (nodeName.equals("function-extension") && child.hasChildNodes()) {
                    function.getExtensions().add(child);
                } else if (nodeName.equals("function-signature") && child.hasChildNodes()) {
                    function.setSignature(this.getContainedText(child));
                } else if (nodeName.equals("icon") && child.hasChildNodes()) {
                    function.setIcon(this.getContainedText(child));
                } else if (nodeName.equals("name") && child.hasChildNodes()) {
                    function.setName(this.getContainedText(child));
                    hasName = function.getName().trim().length() > 0;
                }
            }
            child = child.getNextSibling();
        }
        if (hasName) {
            return function;
        }
        return null;
    }

    protected TLDInitParam createInitParam(Node initParamNode) {
        TLDInitParamImpl initParam = new TLDInitParamImpl();
        Node child = initParamNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("param-name") && child.hasChildNodes()) {
                    initParam.setName(this.getContainedText(child));
                } else if (nodeName.equals("param-value") && child.hasChildNodes()) {
                    initParam.setValue(this.getContainedText(child));
                } else if (nodeName.equals("description") && child.hasChildNodes()) {
                    initParam.setDescription(this.getContainedText(child));
                }
            }
            child = child.getNextSibling();
        }
        return initParam;
    }

    protected TLDListener createListener(Node listenerNode) {
        TLDListenerImpl listener = new TLDListenerImpl();
        Node child = listenerNode.getFirstChild();
        while (child != null) {
            String nodeName;
            if (child.getNodeType() == 1 && (nodeName = child.getNodeName()).equals("listener-class") && child.hasChildNodes()) {
                listener.setListenerClass(this.getContainedText(child));
            }
            child = child.getNextSibling();
        }
        return listener;
    }

    protected TLDValidator createValidator(Node validatorNode) {
        TLDValidatorImpl validator = new TLDValidatorImpl();
        Node child = validatorNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("validator-class") && child.hasChildNodes()) {
                    validator.setValidatorClass(this.getContainedText(child));
                } else if (nodeName.equals("init-param") && child.hasChildNodes()) {
                    validator.getInitParams().add(this.createInitParam(child));
                }
            }
            child = child.getNextSibling();
        }
        return validator;
    }

    protected TLDVariable createVariable(Node variableNode) {
        TLDVariableImpl variable = new TLDVariableImpl();
        Node child = variableNode.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                String nodeName = child.getNodeName();
                if (nodeName.equals("variable-class") && child.hasChildNodes()) {
                    variable.setVariableClass(this.getContainedText(child));
                } else if (nodeName.equals("declare") && child.hasChildNodes()) {
                    variable.setDeclareString(this.getContainedText(child));
                } else if (nodeName.equals("name-from-attribute") && child.hasChildNodes()) {
                    variable.setNameFromAttribute(this.getContainedText(child));
                } else if (nodeName.equals("name-given") && child.hasChildNodes()) {
                    variable.setNameGiven(this.getContainedText(child));
                } else if (nodeName.equals("scope") && child.hasChildNodes()) {
                    variable.setScope(this.getContainedText(child));
                } else if (nodeName.equals("description") && child.hasChildNodes()) {
                    variable.setDescription(this.getContainedText(child));
                }
            }
            child = child.getNextSibling();
        }
        return variable;
    }

    protected String getContainedText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }

    public boolean isBuilderForGrammar(String grammarFileName) {
        String fileName = grammarFileName.toLowerCase();
        return fileName.endsWith(".tld") || fileName.endsWith(".jar");
    }

    private CMDocument loadDocument(String baseLocation, Node taglib) {
        Node root = taglib;
        CMDocumentImpl document = new CMDocumentImpl();
        document.setBaseLocation(baseLocation);
        if (root == null) {
            if (_debug) {
                System.out.println("null \"taglib\" element for TLD " + baseLocation);
            }
            return document;
        }
        Node child = root.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 1) {
                child = child.getNextSibling();
                continue;
            }
            String nodeName = child.getNodeName();
            if (nodeName.equals("tag")) {
                CMElementDeclaration ed = this.createElementDeclaration(document, child);
                if (ed != null) {
                    document.fElements.setNamedItem(ed.getNodeName(), (CMNode)ed);
                }
            } else if (nodeName.equals("tag-file") && child.getNodeType() == 1 && child.hasChildNodes()) {
                Element tagFileElement = (Element)child;
                String path = tagFileElement.getAttribute("path");
                CMElementDeclarationImpl ed = (CMElementDeclarationImpl)this.createElementDeclaration(document, tagFileElement, path);
                if (ed != null) {
                    document.fElements.setNamedItem(ed.getNodeName(), (CMNode)ed);
                }
            } else if ((nodeName.equals("jspversion") || nodeName.equals("jsp-version")) && child.hasChildNodes()) {
                document.setJspversion(this.getContainedText(child));
            } else if ((nodeName.equals("tlibversion") || nodeName.equals("tlib-version")) && child.hasChildNodes()) {
                document.setTlibversion(this.getContainedText(child));
            } else if ((nodeName.equals("shortname") || nodeName.equals("short-name")) && child.hasChildNodes()) {
                document.setShortname(this.getContainedText(child));
            } else if ((nodeName.equals("uri") || nodeName.equals("urn")) && child.hasChildNodes()) {
                document.setUri(this.getContainedText(child));
            } else if (nodeName.equals("info") && child.hasChildNodes()) {
                document.setInfo(this.getContainedText(child));
            } else if (nodeName.equals("description")) {
                document.setDescription(this.getContainedText(child));
            } else if (nodeName.equals("display-name") && child.hasChildNodes()) {
                document.setDisplayName(this.getContainedText(child));
            } else if (nodeName.equals("large-icon") && child.hasChildNodes()) {
                document.setLargeIcon(this.getContainedText(child));
            } else if (nodeName.equals("small-icon") && child.hasChildNodes()) {
                document.setSmallIcon(this.getContainedText(child));
            } else if (nodeName.equals("validator")) {
                document.setValidator(this.createValidator(child));
            } else if (nodeName.equals("listener")) {
                document.getListeners().add(this.createListener(child));
            } else if (nodeName.equals("function")) {
                TLDFunction function = this.createFunction(document, child);
                if (function != null) {
                    document.getFunctions().add(function);
                }
            } else if (nodeName.equals("taglib-extension")) {
                document.getExtensions().add(child);
            }
            child = child.getNextSibling();
        }
        return document;
    }

    /*
     * Exception decompiling
     */
    public CMDocument createCMDocument(ITaglibRecord reference) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 624->627)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

