/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class DTDUIPreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.dtd.ui");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                DTDUIPreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.wst.dtd.ui");
            }
        }
        catch (BundleException e) {
            DTDUIPreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.wst.dtd.ui exception: " + (Object)((Object)e)));
        }
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String value = Platform.getPreferencesService().getString(bundleName, prefKey, defaultValue, null);
        DTDUIPreferencesTest.assertNotSame((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (Object)defaultValue, (Object)value);
    }

    public void testPluginGetDefaultPreferences() {
        DTDUIPlugin.getDefault().getPreferenceStore();
    }

    private void pluginGetDefaultPreference(IPreferenceStore store, String prefKey, String expected) {
        String defaultValue = store.getDefaultString(prefKey);
        DTDUIPreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)defaultValue);
    }

    public void testPluginSetPreferences() {
        DTDUIPlugin.getDefault().getPreferenceStore();
    }

    private void pluginSetPreferenceBoolean(IPreferenceStore store, String prefKey) {
        boolean originalValue = store.getBoolean(prefKey);
        boolean expectedValue = !originalValue;
        store.setValue(prefKey, expectedValue);
        boolean foundValue = store.getBoolean(prefKey);
        DTDUIPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        store.setValue(prefKey, originalValue);
    }

    private void pluginSetPreferenceString(IPreferenceStore store, String prefKey) {
        String originalValue = store.getString(prefKey);
        String expectedValue = Long.toString(System.currentTimeMillis());
        store.setValue(prefKey, expectedValue);
        String foundValue = store.getString(prefKey);
        DTDUIPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (String)expectedValue, (String)foundValue);
        store.setValue(prefKey, originalValue);
    }
}

