/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.operations.tests;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.wst.common.frameworks.operations.tests.A;
import org.eclipse.wst.common.frameworks.operations.tests.B;
import org.eclipse.wst.common.frameworks.operations.tests.C;

public class NestingTest
extends TestCase {
    private A a;
    private B b;
    private C c;

    protected void setUp() throws Exception {
        super.setUp();
        this.a = new A();
        this.b = new B();
        this.c = new C();
    }

    protected void tearDown() throws Exception {
        if (this.a != null) {
            this.a.dispose();
            this.a = null;
        }
        if (this.b != null) {
            this.b.dispose();
            this.b = null;
        }
        if (this.c != null) {
            this.c.dispose();
            this.c = null;
        }
    }

    public void testIsPropertySimpleNesting0() {
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
    }

    public void testIsPropertySimpleNesting1() {
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
    }

    public void testIsPropertySimpleNesting2() {
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
    }

    public void testIsPropertyComplexNesting1() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        C c2 = new C();
        this.b.addNestedModel("c2", c2);
        this.b.removeNestedModel("c2");
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
    }

    public void testIsPropertyComplexNesting2() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        C c2 = new C();
        this.a.addNestedModel("c2", c2);
        this.a.removeNestedModel("c2");
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.addNestedModel("c2", c2);
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c");
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        this.b.removeNestedModel("c2");
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
    }

    public void testIsPropertyComplexNesting3() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.c.isProperty("A.P"));
        Assert.assertFalse((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.c.addNestedModel("a", this.a);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertTrue((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertFalse((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.a.addNestedModel("b", this.b);
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertTrue((boolean)this.a.isProperty("C.P"));
        Assert.assertTrue((boolean)this.b.isProperty("A.P"));
        Assert.assertTrue((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertTrue((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.b.removeNestedModel("c");
        Assert.assertTrue((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("A.P"));
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertTrue((boolean)this.c.isProperty("A.P"));
        Assert.assertTrue((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
        this.c.removeNestedModel("a");
        this.a.removeNestedModel("b");
        Assert.assertFalse((boolean)this.a.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("C.P"));
        Assert.assertFalse((boolean)this.b.isProperty("A.P"));
        Assert.assertFalse((boolean)this.b.isProperty("C.P"));
        Assert.assertFalse((boolean)this.c.isProperty("A.P"));
        Assert.assertFalse((boolean)this.c.isProperty("B.P"));
        Assert.assertFalse((boolean)this.a.isProperty("foo"));
        Assert.assertFalse((boolean)this.b.isProperty("foo"));
        Assert.assertFalse((boolean)this.c.isProperty("foo"));
    }

    public void testSetGetProperty1() {
        this.a.addNestedModel("b", this.b);
        this.b.addNestedModel("c", this.c);
        this.c.addNestedModel("a", this.a);
        this.a.setProperty("A.P", "a");
        this.a.setProperty("B.P", "b");
        this.a.setProperty("C.P", "c");
        NestingTest.assertEquals((Object)"a", (Object)this.a.getProperty("A.P"));
        NestingTest.assertEquals((Object)"a", (Object)this.b.getProperty("A.P"));
        NestingTest.assertEquals((Object)"a", (Object)this.c.getProperty("A.P"));
        NestingTest.assertEquals((Object)"b", (Object)this.a.getProperty("B.P"));
        NestingTest.assertEquals((Object)"b", (Object)this.b.getProperty("B.P"));
        NestingTest.assertEquals((Object)"b", (Object)this.c.getProperty("B.P"));
        NestingTest.assertEquals((Object)"c", (Object)this.a.getProperty("C.P"));
        NestingTest.assertEquals((Object)"c", (Object)this.b.getProperty("C.P"));
        NestingTest.assertEquals((Object)"c", (Object)this.c.getProperty("C.P"));
        this.b.setProperty("A.P", "aa");
        this.b.setProperty("B.P", "bb");
        this.b.setProperty("C.P", "cc");
        NestingTest.assertEquals((Object)"aa", (Object)this.a.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aa", (Object)this.b.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aa", (Object)this.c.getProperty("A.P"));
        NestingTest.assertEquals((Object)"bb", (Object)this.a.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bb", (Object)this.b.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bb", (Object)this.c.getProperty("B.P"));
        NestingTest.assertEquals((Object)"cc", (Object)this.a.getProperty("C.P"));
        NestingTest.assertEquals((Object)"cc", (Object)this.b.getProperty("C.P"));
        NestingTest.assertEquals((Object)"cc", (Object)this.c.getProperty("C.P"));
        this.c.setProperty("A.P", "aaa");
        this.c.setProperty("B.P", "bbb");
        this.c.setProperty("C.P", "ccc");
        NestingTest.assertEquals((Object)"aaa", (Object)this.a.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aaa", (Object)this.b.getProperty("A.P"));
        NestingTest.assertEquals((Object)"aaa", (Object)this.c.getProperty("A.P"));
        NestingTest.assertEquals((Object)"bbb", (Object)this.a.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bbb", (Object)this.b.getProperty("B.P"));
        NestingTest.assertEquals((Object)"bbb", (Object)this.c.getProperty("B.P"));
        NestingTest.assertEquals((Object)"ccc", (Object)this.a.getProperty("C.P"));
        NestingTest.assertEquals((Object)"ccc", (Object)this.b.getProperty("C.P"));
        NestingTest.assertEquals((Object)"ccc", (Object)this.c.getProperty("C.P"));
    }
}

