/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.logger.proxy.Logger;

public class ProjectUtility {
    public static IProject[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public static boolean projectExists(String projectName) {
        return ProjectUtility.getProject(projectName) != null;
    }

    public static IProject verifyAndReturnProject(String projectName, boolean exists) {
        IProject project = ProjectUtility.getProject(projectName);
        if (exists) {
            Assert.assertTrue((String)("Project Does Not Exist:" + projectName), (boolean)project.exists());
        } else {
            Assert.assertTrue((String)("Project Exists:" + projectName), (!project.exists() ? 1 : 0) != 0);
        }
        return project;
    }

    public static void verifyProject(String projectName, boolean exists) {
        IProject project = ProjectUtility.getProject(projectName);
        if (exists) {
            Assert.assertTrue((String)("Project Does Not Exist:" + projectName), (boolean)project.exists());
        } else {
            Assert.assertTrue((String)("Project Exists:" + projectName), (!project.exists() ? 1 : 0) != 0);
        }
    }

    public static IProject getProject(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String pathString = projectName;
        if (workspace.getRoot().getProject(pathString) != null) {
            return workspace.getRoot().getProject(pathString);
        }
        return null;
    }

    public static void verifyNoProjects() {
        IProject[] projects = ProjectUtility.getAllProjects();
        String projectNames = "";
        int i = 0;
        while (i < projects.length) {
            projectNames = String.valueOf(projectNames) + " " + projects[i].getName();
            ++i;
        }
        Assert.assertTrue((String)("All projects not deleted" + projectNames), (projects.length == 0 ? 1 : 0) != 0);
    }

    public static void deleteProjectIfExists(String projectName) {
        if (projectName == null) {
            return;
        }
        IProject project = ProjectUtility.getProject(projectName);
        if (project != null && project.isAccessible()) {
            try {
                project.close(null);
                project.delete(true, true, null);
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    public static void deleteAllProjects() throws Exception {
        IProject[] projects = ProjectUtility.getAllProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            boolean success = false;
            Exception lastException = null;
            int j = 0;
            while (j < 13 && !success) {
                try {
                    if (project.exists()) {
                        project.delete(true, true, null);
                        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                    }
                    success = true;
                }
                catch (Exception e) {
                    lastException = e;
                    if (project.exists()) {
                        try {
                            project.close(null);
                            project.open(null);
                        }
                        catch (Exception exception) {}
                    }
                    Thread.sleep((int)Math.pow(2.0, j));
                }
                ++j;
            }
            if (!success && lastException != null) {
                Logger.getLogger().log((Object)("Problem while deleting: " + lastException.getMessage()));
            }
            ++i;
        }
        ProjectUtility.verifyNoProjects();
    }

    public static List getSpecificFilesInDirectory(Plugin plugin, String path, String fileSuffix) {
        URL entry = null;
        entry = plugin.getBundle().getEntry(path);
        ArrayList<String> result = null;
        File folder = null;
        if (entry != null) {
            try {
                entry = Platform.asLocalURL((URL)entry);
                folder = new File(new URI(entry.toString()));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return Collections.EMPTY_LIST;
            }
            List<String> files = Arrays.asList(folder.list());
            if (!files.isEmpty()) {
                String folderPath = String.valueOf(folder.getAbsolutePath()) + File.separator;
                result = new ArrayList<String>();
                int i = 0;
                while (i < files.size()) {
                    String fileName = files.get(i);
                    if (fileName.endsWith(fileSuffix)) {
                        result.add(String.valueOf(folderPath) + fileName);
                    }
                    ++i;
                }
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public static List getJarsInDirectory(Plugin plugin, String path) {
        return ProjectUtility.getSpecificFilesInDirectory(plugin, path, ".jar");
    }

    public static List getRarsInDirectory(Plugin plugin, String path) {
        return ProjectUtility.getSpecificFilesInDirectory(plugin, path, ".rar");
    }

    public static List getEarsInDirectory(Plugin plugin, String path) {
        return ProjectUtility.getSpecificFilesInDirectory(plugin, path, ".ear");
    }

    public static List getWarsInDirectory(Plugin plugin, String path) {
        return ProjectUtility.getSpecificFilesInDirectory(plugin, path, ".war");
    }

    public static String getFullFileName(Plugin plugin, String pluginRelativeFileName) throws IOException {
        Path path = new Path(pluginRelativeFileName);
        if (path.getDevice() != null) {
            return pluginRelativeFileName;
        }
        URL url = plugin.getBundle().getEntry(pluginRelativeFileName);
        if (url != null) {
            url = Platform.asLocalURL((URL)url);
            Path iPath = new Path(url.getPath());
            return iPath.toOSString();
        }
        return null;
    }
}

