/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.wst.sse.core.internal.IExecutionDelegate;
import org.eclipse.wst.sse.core.internal.ILockable;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.IExecutionDelegatable;

public class JobSafeStructuredDocument
extends BasicStructuredDocument
implements IExecutionDelegatable,
ILockable {
    private IExecutionDelegate fExecutionDelegate;
    private ILock fLockable = null;

    public JobSafeStructuredDocument() {
    }

    public JobSafeStructuredDocument(RegionParser parser) {
        super(parser);
    }

    protected final void acquireLock() {
        this.getLockObject().acquire();
    }

    private IExecutionDelegate getExecutionDelegate() {
        return this.fExecutionDelegate;
    }

    public ILock getLockObject() {
        if (this.fLockable == null) {
            this.fLockable = Platform.getJobManager().newLock();
        }
        return this.fLockable;
    }

    protected final void releaseLock() {
        this.getLockObject().release();
    }

    public StructuredDocumentEvent replaceText(final Object requester, final int start, final int replacementLength, final String changes, final boolean ignoreReadOnlySettings) {
        StructuredDocumentEvent event = null;
        if (this.getExecutionDelegate() == null) {
            event = super.replaceText(requester, start, replacementLength, changes, ignoreReadOnlySettings);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        resultSlot[0] = JobSafeStructuredDocument.super.replaceText(requester, start, replacementLength, changes, ignoreReadOnlySettings);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            this.getExecutionDelegate().execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
            event = (StructuredDocumentEvent)((Object)resultSlot[0]);
        }
        return event;
    }

    public void setExecutionDelegate(IExecutionDelegate delegate) {
        this.fExecutionDelegate = delegate;
    }

    public NewDocumentEvent setText(final Object requester, final String theString) {
        NewDocumentEvent event = null;
        if (this.getExecutionDelegate() == null) {
            event = super.setText(requester, theString);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        resultSlot[0] = JobSafeStructuredDocument.super.setText(requester, theString);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            this.getExecutionDelegate().execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
            event = (NewDocumentEvent)((Object)resultSlot[0]);
        }
        return event;
    }
}

