/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TestModelClone
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public TestModelClone(String name) {
        super(name);
    }

    public static void main(String[] args) {
    }

    public static Test getTest() {
        return new TestModelClone("testCreateStructuredModelJSP");
    }

    public void testCloneStructuredModelXML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        boolean passed = true;
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCloneStructuredModelHTML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        boolean passed = true;
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCloneStructuredModelJSP() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        boolean passed = true;
        IDOMDocument doc = ((IDOMModel)clonedModel).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"cloned model did not have embedded adapter", (Object)pageDirectiveAdapter);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        TestModelClone.assertNotNull((String)"cloned model did not have embedded handler", (Object)embeddedHandler);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    public void testCloneStructuredModelJSPXML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.html.core.internal.modelhandler.EmbeddedHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz);
        String testContent = "<%@ page contentType=\"text/xml\" %>";
        model.getStructuredDocument().setText((Object)this, testContent);
        TestModelClone.assertTrue((String)"model should not need reinit", (!model.isReinitializationNeeded() ? 1 : 0) != 0);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.wst.xml.core.internal.modelhandler.EmbeddedXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(model, clazz2);
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.xml.core.internal.modelhandler.EmbeddedXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkEmbeddedType(clonedModel, clazz3);
    }

    private void checkEmbeddedType(IStructuredModel model, Class expectedType) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"model did not have embedded adapter", (Object)pageDirectiveAdapter);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        TestModelClone.assertNotNull((String)"model did not have embedded handler", (Object)embeddedHandler);
        TestModelClone.assertTrue((String)"embeddedHandler is wrong type", (boolean)embeddedHandler.getClass().equals(expectedType));
    }

    public void testCreateStructuredModelJSP() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        ArrayList factories = (ArrayList)model.getFactoryRegistry().getFactories();
        factories = (ArrayList)factories.clone();
        IStructuredModel clonedModel = model.newInstance();
        if (model.getModelHandler() == null) {
            System.out.println();
            TestModelClone.assertTrue((boolean)false);
        }
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        ArrayList newFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        newFactories = (ArrayList)newFactories.clone();
        boolean passed = this.checkFactoriesListForIdentity(factories, newFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        passed = this.checkForSameEmbeddedFactories(model, clonedModel);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        clonedModel.getStructuredDocument().replaceText((Object)this, 0, 0, "<sample> text");
        ArrayList twoFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        twoFactories = (ArrayList)twoFactories.clone();
        passed = this.checkFactoriesListForIdentity(factories, twoFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        passed = this.checkForSameEmbeddedFactories(model, clonedModel);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        clonedModel.getStructuredDocument().setText((Object)this, "<%@ page contentType=\"text/html\"");
        ArrayList threeFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        threeFactories = (ArrayList)threeFactories.clone();
        passed = this.checkFactoriesListForIdentity(factories, threeFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        passed = this.checkForSameEmbeddedFactories(model, clonedModel);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }

    private boolean checkForSameEmbeddedFactories(IStructuredModel model, IStructuredModel clonedModel) {
        boolean result = true;
        EmbeddedTypeHandler oldEmbeddedType = this.getEmbeddedType(model);
        EmbeddedTypeHandler newEmbeddedType = this.getEmbeddedType(clonedModel);
        if (!oldEmbeddedType.getClass().equals(newEmbeddedType.getClass())) {
            result = false;
            TestModelClone.assertTrue((boolean)result);
        }
        List oldFactories = oldEmbeddedType.getAdapterFactories();
        List newFactories = newEmbeddedType.getAdapterFactories();
        result = this.checkFactoriesListForEquivalence(oldFactories, newFactories);
        return result;
    }

    private EmbeddedTypeHandler getEmbeddedType(IStructuredModel model) {
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter pageDirectiveAdapter = (PageDirectiveAdapter)iNodeNotifier.getExistingAdapter((Object)clazz);
        TestModelClone.assertNotNull((String)"model did not have embedded adapter", (Object)pageDirectiveAdapter);
        EmbeddedTypeHandler embeddedHandler = pageDirectiveAdapter.getEmbeddedType();
        TestModelClone.assertNotNull((String)"model did not have embedded handler", (Object)embeddedHandler);
        return embeddedHandler;
    }

    private boolean checkFactoriesListForIdentity(List factories, List newFactories) {
        boolean result = true;
        if (factories.size() != newFactories.size()) {
            result = false;
        }
        return result;
    }

    private boolean checkFactoriesListForEquivalence(List factories, List newFactories) {
        boolean result = true;
        if (factories.size() != newFactories.size()) {
            result = false;
        } else {
            int i = 0;
            while (i < factories.size()) {
                if (!factories.get(i).getClass().equals(newFactories.get(i).getClass())) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void testCreateStructuredModelHTML() throws IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        TestModelClone.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        ArrayList factories = (ArrayList)model.getFactoryRegistry().getFactories();
        factories = (ArrayList)factories.clone();
        IStructuredModel clonedModel = model.newInstance();
        TestModelClone.assertTrue((String)"cloned model could not be created!", (clonedModel != null ? 1 : 0) != 0);
        ArrayList newFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        newFactories = (ArrayList)newFactories.clone();
        boolean passed = this.checkFactoriesListForIdentity(factories, newFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
        clonedModel.getStructuredDocument().setText((Object)this, "<sample> text");
        ArrayList twoFactories = (ArrayList)clonedModel.getFactoryRegistry().getFactories();
        twoFactories = (ArrayList)twoFactories.clone();
        passed = this.checkFactoriesListForIdentity(factories, newFactories);
        TestModelClone.assertTrue((String)"newInstance of structured model is not correct", (boolean)passed);
    }
}

