/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerUtility;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TestModelEmbeddedContentType
extends TestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TestModelEmbeddedContentType(String name) {
        super(name);
    }

    public static void main(String[] args) {
    }

    public static Test getTest() {
        return new TestModelEmbeddedContentType("testStructuredModelEmbeddedJSPChange");
    }

    protected void checkEmbeddedType(IStructuredModel clonedModel, Object expectedType) {
        IDOMDocument doc = ((IDOMModel)clonedModel).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PageDirectiveAdapter embeddedTypeAdapter = (PageDirectiveAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
        TestModelEmbeddedContentType.assertNotNull((String)"cloned model did not have embedded adapter", (Object)embeddedTypeAdapter);
        EmbeddedTypeHandler embeddedHandler = embeddedTypeAdapter.getEmbeddedType();
        TestModelEmbeddedContentType.assertNotNull((String)"cloned model did not have embedded handler", (Object)embeddedHandler);
        TestModelEmbeddedContentType.assertTrue((String)"cloned model embeddedHandler is wrong type", (boolean)embeddedHandler.equals(expectedType));
    }

    public void testStructuredModelEmbeddedXML() throws IOException {
        EmbeddedTypeHandler embeddedHandler;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        TestModelEmbeddedContentType.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestModelEmbeddedContentType.assertTrue((String)"embededHanlder should be null for XML", ((embeddedHandler = (EmbeddedTypeHandler)iNodeNotifier.getAdapterFor((Object)clazz)) == null ? 1 : 0) != 0);
    }

    public void testStructuredModelEmbeddedHTML() throws IOException {
        EmbeddedTypeHandler embeddedHandler;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForHTML.ContentTypeID_HTML);
        TestModelEmbeddedContentType.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestModelEmbeddedContentType.assertTrue((String)"embededHanlder should be null for HTML", ((embeddedHandler = (EmbeddedTypeHandler)iNodeNotifier.getAdapterFor((Object)clazz)) == null ? 1 : 0) != 0);
    }

    protected IStructuredModel doStructuredModelEmbeddedJSP() throws IOException {
        PageDirectiveAdapter embeddedHandler;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.createUnManagedStructuredModelFor(ContentTypeIdForJSP.ContentTypeID_JSP);
        TestModelEmbeddedContentType.assertTrue((String)"model could not be created!", (model != null ? 1 : 0) != 0);
        IDOMDocument doc = ((IDOMModel)model).getDocument();
        INodeNotifier iNodeNotifier = (INodeNotifier)doc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.document.PageDirectiveAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestModelEmbeddedContentType.assertTrue((String)"embededHanlder should NOT be null for JSP", ((embeddedHandler = (PageDirectiveAdapter)iNodeNotifier.getAdapterFor((Object)clazz)) != null ? 1 : 0) != 0);
        this.checkEmbeddedType(model, ModelHandlerUtility.getDefaultEmbeddedType());
        String testContent = "<%@ page contentType=\"text/html\" %>";
        model.getStructuredDocument().replaceText((Object)this, 0, 0, testContent);
        TestModelEmbeddedContentType.assertTrue((String)"reinit should NOT be needed in this case", (!model.isReinitializationNeeded() ? 1 : 0) != 0);
        this.checkEmbeddedType(model, ModelHandlerUtility.getDefaultEmbeddedType());
        return model;
    }

    public void testStructuredModelEmbeddedJSP() throws IOException {
        this.doStructuredModelEmbeddedJSP();
    }

    public void testStructuredModelEmbeddedJSPChange() throws IOException {
        IStructuredModel model = this.doStructuredModelEmbeddedJSP();
        model.getStructuredDocument().replaceText((Object)this, 27, 4, "xml");
        if (model.isReinitializationNeeded()) {
            model.reinit();
        }
        this.checkEmbeddedType(model, ModelHandlerUtility.getEmbeddedContentTypeFor((String)"text/xml"));
    }
}

