/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;

public class StringArrayTableWizardSection
extends Composite {
    private TableViewer viewer;
    private Button addButton;
    private Button removeButton;
    private String title;
    private String[] labelsForText;
    private WTPOperationDataModel model;
    private String propertyName;
    private Image labelProviderImage;

    public StringArrayTableWizardSection(Composite parent, String title, String addButtonLabel, String removeButtonLabel, String[] labelsForText, Image labelProviderImage, WTPOperationDataModel model, String propertyName) {
        super(parent, 0);
        this.title = title;
        this.labelsForText = labelsForText;
        this.labelProviderImage = labelProviderImage;
        this.model = model;
        this.propertyName = propertyName;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label titleLabel = new Label((Composite)this, 16384);
        titleLabel.setText(title);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)data);
        this.viewer = new TableViewer((Composite)this);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new StringArrayListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StringArrayListLabelProvider());
        Composite buttonCompo = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonCompo.setLayout((Layout)layout);
        buttonCompo.setLayoutData((Object)new GridData(1042));
        this.addButton = new Button(buttonCompo, 8);
        this.addButton.setText(addButtonLabel);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                StringArrayTableWizardSection.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton = new Button(buttonCompo, 8);
        this.removeButton.setText(removeButtonLabel);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                StringArrayTableWizardSection.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                StringArrayTableWizardSection.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void handleAddButtonSelected(SelectionEvent event) {
        AddStringArrayDialog dialog = new AddStringArrayDialog(this.getShell(), this.title, this.labelsForText);
        dialog.open();
        String[] stringArray = dialog.getStringArray();
        this.addStringArray(stringArray);
    }

    private void handleRemoveButtonSelected(SelectionEvent event) {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selectedObj = ((IStructuredSelection)selection).getFirstElement();
        this.removeStringArray(selectedObj);
    }

    public void addStringArray(String[] stringArray) {
        List<String[]> valueList = new ArrayList();
        if (stringArray == null) {
            return;
        }
        valueList = (List)this.viewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList();
        }
        valueList.add(stringArray);
        this.setInput(valueList);
    }

    public void removeStringArray(Object selectedStringArray) {
        List valueList = (List)this.viewer.getInput();
        valueList.remove(selectedStringArray);
        this.setInput(valueList);
    }

    public void setInput(List input) {
        this.viewer.setInput((Object)input);
        ArrayList newInput = new ArrayList();
        newInput.addAll(input);
        this.model.setProperty(this.propertyName, newInput);
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    protected class StringArrayListContentProvider
    implements IStructuredContentProvider {
        protected StringArrayListContentProvider() {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            if (element instanceof List) {
                return ((List)element).toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected class StringArrayListLabelProvider
    extends LabelProvider {
        protected StringArrayListLabelProvider() {
        }

        public Image getImage(Object element) {
            return StringArrayTableWizardSection.this.labelProviderImage;
        }

        public String getText(Object element) {
            String[] array = (String[])element;
            String s = array[0];
            return s;
        }
    }

    protected class AddStringArrayDialog
    extends Dialog {
        protected String windowTitle;
        protected String[] labelsForTextField;
        protected Text[] texts;
        protected String[] stringArray;

        public AddStringArrayDialog(Shell shell, String windowTitle, String[] labelsForTextField) {
            super(shell);
            this.windowTitle = windowTitle;
            this.labelsForTextField = labelsForTextField;
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.getShell().setText(this.windowTitle);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            data.widthHint = 300;
            composite.setLayoutData((Object)data);
            int n = this.labelsForTextField.length;
            this.texts = new Text[n];
            int i = 0;
            while (i < n) {
                Label label = new Label(composite, 16384);
                label.setText(this.labelsForTextField[i]);
                label.setLayoutData((Object)new GridData(32));
                this.texts[i] = new Text(composite, 2052);
                data = new GridData(768);
                data.widthHint = 100;
                this.texts[i].setLayoutData((Object)data);
                ++i;
            }
            this.texts[0].setFocus();
            return composite;
        }

        protected void okPressed() {
            int n = this.labelsForTextField.length;
            this.stringArray = new String[n];
            int i = 0;
            while (i < n) {
                this.stringArray[i] = this.texts[i].getText();
                ++i;
            }
            super.okPressed();
        }

        public String[] getStringArray() {
            return this.stringArray;
        }
    }
}

