/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.fvtests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentCreationOperation;
import org.eclipse.jst.j2ee.application.internal.operations.FlexibleJavaProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.JavaUtilityComponentCreationOperation;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationOperation;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.EarComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbComponentCreationOperation;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentCreationOperation;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationOperation;
import org.eclipse.jst.j2ee.tests.modulecore.AllTests;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public abstract class AbstractModuleCreationTest
extends TestCase {
    public static String DEFAULT_PROJECT_NAME = "Flexible";

    public AbstractModuleCreationTest(String name) {
        super(name);
    }

    public AbstractModuleCreationTest() {
    }

    public void createSimpleProject(String projectName) throws Exception {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new FlexibleJavaProjectCreationDataModelProvider());
        dataModel.setProperty("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        this.setServerTargetProperty(dataModel);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setServerTargetProperty(IDataModel dataModel) {
        dataModel.setProperty("IJ2EEProjectServerTargetDataModelProperties.RUNTIME_TARGET_ID", (Object)AllTests.JONAS_TOMCAT_RUNTIME.getId());
    }

    public void runAll() {
        try {
            this.createSimpleProject(DEFAULT_PROJECT_NAME);
            this.setupEARModule();
            this.setupjavaUtilComponent();
            this.setupWebModule();
            this.setupEJBModule();
            this.setupAppClientModule();
            this.setupConnectorModule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupjavaUtilComponent() throws Exception {
        this.createjavautilComponent("javaUtil", DEFAULT_PROJECT_NAME);
    }

    private void createjavautilComponent(String aModuleName, String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)aModuleName);
        try {
            this.runJavaUtilComponentCreationOperation(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runJavaUtilComponentCreationOperation(IDataModel model) throws Exception {
        JavaUtilityComponentCreationOperation webOp = new JavaUtilityComponentCreationOperation(model);
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setupEARModule() throws Exception {
        this.createEARModule(12, "FirstEARModule", DEFAULT_PROJECT_NAME);
    }

    private void createEARModule(int j2eeVersion, String aModuleName, String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)aModuleName);
        try {
            this.runEARComponenteCreationOperation(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runEARComponenteCreationOperation(IDataModel model) throws Exception {
        EARComponentCreationOperation webOp = new EARComponentCreationOperation(model);
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setupEJBModule() throws Exception {
        this.createEJBModule(11, "FirstEJBModule", DEFAULT_PROJECT_NAME);
        this.createEJBModule(20, "SecondEJBModule", DEFAULT_PROJECT_NAME);
        this.createEJBModule(21, "ThirdEJBModule", DEFAULT_PROJECT_NAME);
    }

    private void createEJBModule(int j2eeVersion, String aModuleName, String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)aModuleName);
        model.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", false);
        try {
            this.runEJBComponenteCreationOperation(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runEJBComponenteCreationOperation(IDataModel model) throws Exception {
        EjbComponentCreationOperation ejbOp = new EjbComponentCreationOperation(model);
        ejbOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setupWebModule() throws Exception {
        this.createWebModule(22, "FirstWebModule", DEFAULT_PROJECT_NAME);
        this.createWebModule(23, "SecondWebModule", DEFAULT_PROJECT_NAME);
        this.createWebModule(24, "ThirdWebModule", DEFAULT_PROJECT_NAME);
    }

    private void createWebModule(int j2eeVersion, String aModuleName, String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)aModuleName);
        try {
            this.runWebModuleCreationOperation(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runWebModuleCreationOperation(IDataModel model) throws Exception {
        WebComponentCreationOperation webOp = new WebComponentCreationOperation(model);
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setupAppClientModule() throws Exception {
        this.createAppClientModule(12, "FirstAppClient", DEFAULT_PROJECT_NAME);
    }

    private void createAppClientModule(int j2eeVersion, String aModuleName, String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)aModuleName);
        try {
            this.runAppClientModuleCreationOperation(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runAppClientModuleCreationOperation(IDataModel model) throws Exception {
        AppClientComponentCreationOperation appOp = new AppClientComponentCreationOperation(model);
        appOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }

    public void setupConnectorModule() throws Exception {
        this.createConnectorModule(15, "FirstConnector", DEFAULT_PROJECT_NAME);
    }

    private void createConnectorModule(int j2eeVersion, String aModuleName, String projectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        model.setProperty("IComponentCreationDataModelProperties.COMPONENT_NAME", (Object)aModuleName);
        try {
            this.runConnectorModuleCreationOperation(model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runConnectorModuleCreationOperation(IDataModel model) throws Exception {
        ConnectorComponentCreationOperation webOp = new ConnectorComponentCreationOperation(model);
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
    }
}

