/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentCreationOperation;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentCreationOperation;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.ApplicationClientNatureRuntime;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.internal.earcreation.EarComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbComponentCreationOperation;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentCreationOperation;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.LogUtility;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.TaskViewUtility;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.RandomObjectGenerator;

public abstract class AbstractJ2EEComponentCreationTest
extends TestCase {
    protected static final String ILLEGAL_PROJECT_NAME_MESSAGE = "Illegal project name: ";
    protected static final String UNEXPECTED_ERROR_MESSAGE = "Unexpected exception";
    protected static final String TEST_FAILED_MESSAGE = "Test fails Exception should of been trown";
    protected static final String MANIFEST_CLASS_NAME = "Junit_Test_Dummy_Class";
    protected static final String MANIFEST_WRITE_ERROR = "Could not write to manifest test failed";
    protected static final String MANIFEST_LOCK_ERROR = "Manifest IO error - File could be locked";
    protected static final String MANIFEST_CORE_ERROR = "Java core error";
    protected String projectName = null;
    public static final int APPLICATION_CLIENT_MODULE = 0;
    public static final int WEB_MODULE = 1;
    public static final int EJB_MODULE = 2;
    public static final int EAR_MODULE = 3;
    public IProject ejbproject;
    public IProject earproject;

    public AbstractJ2EEComponentCreationTest(String name) {
        super(name);
    }

    public void createValidComponentNameCreationWithAlphabetChars(int MODULE_TYPE, int j2eeVersion, boolean isMixedChars) throws Exception {
        LogUtility.getInstance().resetLogging();
        IDataModel model = null;
        switch (MODULE_TYPE) {
            case 1: {
                if (!isMixedChars) {
                    model = this.setupWebComponent(RandomObjectGenerator.createCorrectRandomProjectNames(), j2eeVersion);
                    break;
                }
                model = this.setupWebComponent(RandomObjectGenerator.createCorrectRandomProjectNamesAllChars(), j2eeVersion);
                break;
            }
            case 2: {
                if (!isMixedChars) {
                    model = this.setupEJBComponent(RandomObjectGenerator.createCorrectRandomProjectNames(), j2eeVersion);
                    break;
                }
                model = this.setupEJBComponent(RandomObjectGenerator.createCorrectRandomProjectNamesAllChars(), j2eeVersion);
                break;
            }
            case 0: {
                if (!isMixedChars) {
                    model = this.setupApplicationClientComponent(RandomObjectGenerator.createCorrectRandomProjectNames(), j2eeVersion);
                    break;
                }
                model = this.setupApplicationClientComponent(RandomObjectGenerator.createCorrectRandomProjectNamesAllChars(), j2eeVersion);
                break;
            }
            case 3: {
                model = !isMixedChars ? this.setupEARComponent(RandomObjectGenerator.createCorrectRandomProjectNames(), j2eeVersion) : this.setupEARComponent(RandomObjectGenerator.createCorrectRandomProjectNamesAllChars(), j2eeVersion);
            }
        }
        LogUtility.getInstance().verifyNoWarnings();
        this.checkValidDataModel(model);
    }

    protected void checkValidDataModel(IDataModel model) {
    }

    protected static void checkVaildProjectName(String projectName) {
        ProjectUtility.verifyProject((String)projectName, (boolean)true);
    }

    public IDataModel setupEJBComponent(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        IProject javaProject = ProjectUtility.getProject((String)this.projectName);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)javaProject.getName());
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        AbstractJ2EEComponentCreationTest.createEJBComponent(model, null);
        return model;
    }

    public IDataModel setupEARComponent(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        ProjectUtility.getProject((String)aProjectName);
        IDataModel earDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
        earDataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)aProjectName);
        earDataModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        OperationTestCase.runAndVerify((IDataModel)earDataModel);
        return earDataModel;
    }

    public IDataModel setupWebComponent(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        IProject javaProject = ProjectUtility.getProject((String)this.projectName);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)javaProject.getName());
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        AbstractJ2EEComponentCreationTest.createWebComponent(model, null);
        return model;
    }

    public IDataModel setupApplicationClientComponent(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        IProject javaProject = ProjectUtility.getProject((String)this.projectName);
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
        model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)javaProject.getName());
        model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        AbstractJ2EEComponentCreationTest.createAppClientComponent(model, null);
        return model;
    }

    public void testJavaCreation() throws Exception {
        AbstractJ2EEComponentCreationTest.createEJBComponent("testEAR", "testEJB", 12, 11);
    }

    public static IProject createComponent(int projectType, String earProject, boolean createEAR, String projectName) throws Exception {
        if (createEAR) {
            ProjectUtility.deleteProjectIfExists((String)earProject);
        }
        ProjectUtility.deleteProjectIfExists((String)projectName);
        if (earProject != null && createEAR) {
            IDataModel earCompCreationDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
            earCompCreationDataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)earProject);
            earCompCreationDataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            ProjectUtility.verifyProject((String)earProject, (boolean)true);
        }
        IDataModel projectCreationDataModel = null;
        switch (projectType) {
            case 2: {
                projectCreationDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
                break;
            }
            case 1: {
                projectCreationDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
                break;
            }
            case 0: {
                projectCreationDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentCreationDataModelProvider());
            }
        }
        if (earProject != null) {
            projectCreationDataModel.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", true);
            projectCreationDataModel.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject);
        }
        projectCreationDataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        projectCreationDataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)projectName, (boolean)true);
        return ProjectUtility.getProject((String)projectName);
    }

    public static IProject createEARComponent(String earProject) throws Exception {
        IDataModel projectCreationModel = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
        projectCreationModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)earProject);
        return AbstractJ2EEComponentCreationTest.createEARComponent(projectCreationModel);
    }

    public static IProject createEARComponent(IDataModel model) throws Exception {
        EARComponentCreationOperation op = new EARComponentCreationOperation(model);
        op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"), (boolean)true);
        return ProjectUtilities.getProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
    }

    public static IProject createEJBComponent(IDataModel model, IProject earProject) throws Exception {
        if (earProject != null) {
            model.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", true);
            model.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject.getName());
        }
        EjbComponentCreationOperation ejbOp = new EjbComponentCreationOperation(model);
        ejbOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"), (boolean)true);
        return ProjectUtilities.getProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
    }

    public static void createEARComponent(IDataModel model, boolean notImport) throws Exception {
        model.setBooleanProperty("IComponentCreationDataModelProperties.CREATE_DEFAULT_FILES", notImport);
        EARComponentCreationOperation op = new EARComponentCreationOperation(model);
        op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"), (boolean)true);
    }

    public static void createWebComponent(IDataModel model, IProject earProject) throws Exception {
        if (earProject != null) {
            model.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", true);
            model.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject.getName());
        }
        WebComponentCreationOperation webOp = new WebComponentCreationOperation(model);
        webOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"), (boolean)true);
        TaskViewUtility.verifyNoErrors();
    }

    public static void createAppClientComponent(IDataModel model, IProject earProject) throws Exception {
        if (earProject != null) {
            model.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", true);
            model.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject.getName());
        }
        AppClientComponentCreationOperation appOp = new AppClientComponentCreationOperation(model);
        appOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"), (boolean)true);
    }

    public static void createRarComponent(IDataModel model, IProject earProject) throws Exception {
        if (earProject != null) {
            model.setBooleanProperty("IJ2EEComponentCreationDataModelProperties.ADD_TO_EAR", true);
            model.setProperty("IJ2EEComponentCreationDataModelProperties.EAR_COMPONENT_NAME", (Object)earProject.getName());
        }
        ConnectorComponentCreationOperation rarOp = new ConnectorComponentCreationOperation(model);
        rarOp.execute((IProgressMonitor)new NullProgressMonitor(), null);
        ProjectUtility.verifyProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"), (boolean)true);
    }

    public static IProject createEJBComponent(String earName, String ejbName, int j2eeEARVersion, int j2eeEJBVersion) throws Exception {
        ProjectUtility.deleteAllProjects();
        IDataModel model = null;
        IDataModel ejbDataModel = null;
        if (earName != null) {
            ProjectUtility.getProject((String)earName);
            model = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
            model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)earName);
            model.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeEARVersion);
            new EARComponentCreationOperation(model);
            ProjectUtility.getProject((String)ejbName);
            ejbDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EjbComponentCreationDataModelProvider());
            ejbDataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)ejbName);
            ejbDataModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeEJBVersion);
            AbstractJ2EEComponentCreationTest.createEJBComponent(ejbDataModel, ProjectUtilities.getProject((String)model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME")));
        }
        return ProjectUtilities.getProject((String)ejbDataModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addJavaMainClassToApplicationModel(IProject appProject) {
        ArchiveManifestImpl manifest;
        block9: {
            ApplicationClientNatureRuntime runtime = ApplicationClientNatureRuntime.getRuntime((IProject)appProject);
            IFile file = runtime.getEMFRoot().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            manifest = null;
            InputStream inputStream = null;
            try {
                try {
                    inputStream = file.getContents();
                    manifest = new ArchiveManifestImpl(inputStream);
                }
                catch (IOException iOException) {
                    new Exception(MANIFEST_LOCK_ERROR);
                }
                catch (CoreException coreException) {
                    new Exception(MANIFEST_CORE_ERROR);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (inputStream == null) break block9;
            }
            try {}
            catch (IOException iOException) {}
            inputStream.close();
        }
        manifest.setMainClass(MANIFEST_CLASS_NAME);
    }

    public void testAddingEJBtoEarModule() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.setupEARDataObject(RandomObjectGenerator.createCorrectRandomProjectNames(), 13);
    }

    public String setupEARDataObject(String aProjectName, int j2eeVersion) throws Exception {
        this.projectName = aProjectName;
        ProjectUtility.getProject((String)aProjectName);
        IDataModel earDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EarComponentCreationDataModelProvider());
        earDataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)aProjectName);
        IProject ejbProject = ProjectUtility.getProject((String)this.projectName);
        ArrayList<IProject> list = new ArrayList<IProject>();
        list.add(ejbProject);
        earDataModel.setProperty("AddArchiveProjectsToEARDataModel.MODULE_LIST", list);
        earDataModel.setIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION", j2eeVersion);
        earDataModel.getProperty("AddArchiveProjectsToEARDataModel.MODULE_MODELS");
        return earDataModel.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME");
    }

    public AbstractJ2EEComponentCreationTest() {
    }
}

