/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.operations;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.J2EEWebNatureRuntime;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModel;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wst.common.tests.SimpleTestSuite;

public class AddServletOperationTest
extends OperationTestCase {
    public static String WEB_PROJECT_NAME = "WebProject";
    public static String SERVLET_NAME = "Servlet1";
    private IDataModel webComponentDataModel;
    private NewServletClassDataModel servletDataModel;
    static /* synthetic */ Class class$0;

    public AddServletOperationTest(String name) {
        super(name);
    }

    public AddServletOperationTest() {
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.j2ee.headless.tests.web.operations.AddServletOperationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SimpleTestSuite((Class)clazz);
    }

    public void testAddServlet() throws Exception {
        this.createWebProject(WEB_PROJECT_NAME);
        WebApp webApp = this.getWebApp();
        this.addServlet(WEB_PROJECT_NAME, SERVLET_NAME);
        if (webApp != null) {
            webApp.getServletNamed(SERVLET_NAME);
        }
    }

    public void createWebProject(String projectName) throws Exception {
        this.webComponentDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentCreationDataModelProvider());
        this.webComponentDataModel.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)projectName);
        AddServletOperationTest.runAndVerify((IDataModel)this.webComponentDataModel);
    }

    public void addServlet(String projectName, String servletName) throws Exception {
        this.servletDataModel = new NewServletClassDataModel();
        this.servletDataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)projectName);
        this.servletDataModel.setProperty("NewServletClassDataModel.DISPLAY_NAME", (Object)servletName);
        NewServletClassDataModel nestedModel = new NewServletClassDataModel();
        this.servletDataModel.addNestedModel("NewServletClassDataModel", (WTPOperationDataModel)nestedModel);
        nestedModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)projectName);
        nestedModel.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)servletName);
        nestedModel.setProperty("NewJavaClassDataModel.SUPERCLASS", (Object)"NewJavaClassDataModel.SUPERCLASS");
        nestedModel.setProperty("NewJavaClassDataModel.INTERFACES", (Object)this.servletDataModel.getServletInterfaces());
        AddServletOperationTest.runAndVerify((WTPOperationDataModel)this.servletDataModel);
    }

    protected WebApp getWebApp() {
        IProject webProject = null;
        webProject = this.servletDataModel != null ? this.servletDataModel.getTargetProject() : ProjectUtility.getProject((String)WEB_PROJECT_NAME);
        J2EEWebNatureRuntime nature = (J2EEWebNatureRuntime)J2EENature.getRegisteredRuntime((IProject)webProject);
        if (nature != null) {
            return nature.getWebApp();
        }
        return null;
    }
}

