/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.tests.collector.SuiteHelper;
import org.eclipse.wst.common.tests.collector.TestCollectorInnerPanes;
import org.eclipse.wst.common.tests.collector.TestCollectorPlugin;

public class TestCollectorGUI
extends Composite
implements ModifyListener {
    private TestCollectorInnerPanes innerPanes = null;
    private Combo combo = null;
    private Hashtable testSuites = new Hashtable();
    private Hashtable classLoaders = new Hashtable();

    public TestCollectorGUI(Composite parent, int style) {
        super(parent, style);
        this.loadConfiguration();
        this.createPartControl();
    }

    private void loadConfiguration() {
        TestCollectorPlugin plugin = TestCollectorPlugin.instance;
        IExtension[] suitesExtensions = plugin.suitesExtensionPoint.getExtensions();
        int i = 0;
        while (i < suitesExtensions.length) {
            IExtension extension = suitesExtensions[i];
            IConfigurationElement[] tests = extension.getConfigurationElements();
            int j = 0;
            while (j < tests.length) {
                try {
                    IConfigurationElement element = tests[j];
                    String suiteName = element.getAttribute("name");
                    String suiteClass = element.getAttribute("class");
                    this.testSuites.put(suiteName, suiteClass);
                    this.classLoaders.put(suiteName, extension.getDeclaringPluginDescriptor().getPluginClassLoader());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }

    public void createPartControl() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.combo = new Combo((Composite)this, 8);
        Enumeration keys = this.testSuites.keys();
        ArrayList arrayList = new ArrayList();
        while (keys.hasMoreElements()) {
            arrayList.add(keys.nextElement());
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        int i = 0;
        while (i < arrayList.size()) {
            this.combo.add((String)arrayList.get(i));
            ++i;
        }
        this.combo.setLayoutData((Object)gridData);
        this.combo.addModifyListener((ModifyListener)this);
        if (this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.combo) {
            this.updateCombo(e);
        }
    }

    private void updateCombo(ModifyEvent e) {
        if (this.innerPanes != null) {
            this.innerPanes.dispose();
        }
        try {
            String className = (String)this.testSuites.get(this.combo.getText());
            ClassLoader classLoader = (ClassLoader)this.classLoaders.get(this.combo.getText());
            TestSuite suite = (TestSuite)classLoader.loadClass(className).newInstance();
            this.innerPanes = new TestCollectorInnerPanes(this, 0, new SuiteHelper(suite));
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            this.innerPanes.setLayoutData(gridData);
            this.layout();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

