/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph;

import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.graph.ViewMode;
import org.eclipse.wst.wsdl.ui.internal.graph.model.WSDLGraphModelAdapterFactory;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;

public class GraphViewToolBar
extends ViewForm {
    ToolBar graphToolBar;
    Composite frameBar;
    WSDLEditor editor;
    ToolItem showBindingsButton;
    ToolItem backButton;

    public GraphViewToolBar(WSDLEditor wsdlEditor, Composite c, int style) {
        super(c, style);
        this.editor = wsdlEditor;
        this.frameBar = new Composite((Composite)this, 0);
        GridLayout frameLayout = new GridLayout();
        frameLayout.numColumns = 3;
        frameLayout.horizontalSpacing = 0;
        frameLayout.marginWidth = 0;
        frameLayout.marginHeight = 0;
        this.frameBar.setLayout((Layout)frameLayout);
        this.graphToolBar = new ToolBar(this.frameBar, 0x800000);
        this.graphToolBar.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128) {
                    e.doit = false;
                }
            }
        });
        this.backButton = new ToolItem(this.graphToolBar, 8);
        this.backButton.setImage(WSDLEditorPlugin.getInstance().getImage("icons/back.gif"));
        this.backButton.setToolTipText(WSDLEditorPlugin.getWSDLString("_UI_BACK"));
        this.backButton.setEnabled(false);
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = GraphViewToolBar.this.editor.getGraphViewer().getComponentViewer().getInput();
                if (object instanceof XSDSchema) {
                    GraphViewToolBar.this.editor.getGraphViewer().setInput(GraphViewToolBar.this.editor.getDefinition());
                } else if (object instanceof XSDConcreteComponent) {
                    XSDSchema xsdSchema = ((XSDConcreteComponent)object).getSchema();
                    boolean flag = true;
                    while (flag) {
                        EList list = xsdSchema.getReferencingDirectives();
                        if (list.size() > 0) {
                            XSDSchemaDirective xsdSchemaDirective = (XSDSchemaDirective)list.get(0);
                            if (xsdSchemaDirective.getSchema() != null) {
                                xsdSchema = xsdSchemaDirective.getSchema();
                                continue;
                            }
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                    GraphViewToolBar.this.editor.getGraphViewer().setInput(xsdSchema);
                } else {
                    GraphViewToolBar.this.editor.getGraphViewer().setInput(GraphViewToolBar.this.editor.getDefinition());
                }
            }
        });
        this.showBindingsButton = new ToolItem(this.graphToolBar, 16);
        this.showBindingsButton.setImage(WSDLEditorPlugin.getInstance().getImage("icons/hidebinding.gif"));
        this.showBindingsButton.setToolTipText(WSDLEditorPlugin.getWSDLString("_UI_HIDE_BINDINGS"));
        this.showBindingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private boolean currentlySelected = false;

            public void widgetSelected(SelectionEvent e) {
                WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory();
                ViewMode vm = WSDLGraphModelAdapterFactory.getViewMode(GraphViewToolBar.this.editor.getDefinition());
                vm.setBindingVisible(!vm.isBindingVisible());
                ToolItem item = (ToolItem)e.widget;
                if (this.currentlySelected) {
                    item.setSelection(false);
                    this.currentlySelected = false;
                } else {
                    this.currentlySelected = true;
                }
            }
        });
        this.setTopLeft((Control)this.frameBar);
    }

    public void setBackButtonEnabled(boolean state) {
        this.backButton.setEnabled(state);
    }
}

