/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editparts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.UnknownObjectEditPart;

public class ExtensibleEditPartFactory
implements EditPartFactory {
    protected WSDLEditorExtension[] extensions;
    protected EditPartFactory[] editPartFactories;
    protected static ExtensibleEditPartFactory instance;

    public static ExtensibleEditPartFactory getInstance() {
        if (instance == null) {
            instance = new ExtensibleEditPartFactory();
        }
        return instance;
    }

    public ExtensibleEditPartFactory() {
        WSDLEditorExtensionRegistry registry = WSDLEditorPlugin.getInstance().getWSDLEditorExtensionRegistry();
        this.extensions = registry.getRegisteredExtensions(5);
        this.editPartFactories = new EditPartFactory[this.extensions.length];
        int i = 0;
        while (i < this.extensions.length) {
            this.editPartFactories[i] = (EditPartFactory)this.extensions[i].createExtensionObject(5, null);
            ++i;
        }
    }

    protected EditPartFactory getApplicableEditPartFactory(Object object) {
        EditPartFactory result = null;
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].isApplicable(object) && (result = this.editPartFactories[i]) != null) break;
            ++i;
        }
        if (result == null) {
            // empty if block
        }
        return result;
    }

    public EditPart createEditPart(EditPart parent, Object model) {
        UnknownObjectEditPart result = null;
        EditPartFactory factory = this.getApplicableEditPartFactory(model);
        if (factory != null) {
            result = factory.createEditPart(parent, model);
        } else {
            result = new UnknownObjectEditPart();
            result.setModel(model);
            result.setParent(parent);
        }
        return result;
    }
}

