/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Message;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.graph.ViewMode;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.xsd.XSDSchema;

public class WSDLGraphModelAdapterFactory
extends WSDLModelAdapterFactory {
    protected static WSDLGraphModelAdapterFactory wsdlGraphModelAdapterFactoryInstance;

    public static WSDLGraphModelAdapterFactory getWSDLGraphModelAdapterFactory() {
        if (wsdlGraphModelAdapterFactoryInstance == null) {
            wsdlGraphModelAdapterFactoryInstance = new WSDLGraphModelAdapterFactory();
        }
        return wsdlGraphModelAdapterFactoryInstance;
    }

    protected AdapterFactory createAdapterFactory() {
        return new GraphAdapterFactory();
    }

    public static void addModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory().getAdapter(modelObject);
        if (adapter != null) {
            adapter.addListener(listener);
        }
    }

    public static void removeModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory().getAdapter(modelObject);
        if (adapter != null) {
            adapter.removeListener(listener);
        }
    }

    public static ViewMode getViewMode(Definition definition) {
        GraphDefinitionAdapter adapter = (GraphDefinitionAdapter)WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory().getAdapter(definition);
        return adapter.getViewMode();
    }

    protected class GraphAdapterFactory
    extends WSDLModelAdapterFactory.WSDLAdapterFactoryImpl {
        protected GraphAdapterFactory() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        public Adapter createDefinitionAdapter() {
            return new GraphDefinitionAdapter();
        }

        public Adapter createBindingAdapter() {
            return new GraphBindingAdapter();
        }

        public Adapter createPartAdapter() {
            return new GraphPartAdapter();
        }

        public Adapter createPortTypeAdapter() {
            return new GraphPortTypeAdapter();
        }

        public Adapter createTypesAdapter() {
            return new GraphTypesAdapter();
        }
    }

    protected class GraphDefinitionAdapter
    extends WSDLModelAdapterFactory.DefinitionAdapter
    implements ViewMode.Listener {
        protected ViewMode viewMode = new ViewMode();

        protected GraphDefinitionAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        public void setTarget(Notifier newTarget) {
            super.setTarget(newTarget);
            this.viewMode.addListener(this);
        }

        protected List getChildren() {
            ArrayList list = new ArrayList();
            list.add(this.permanentWSDLGroupObjectList.get(0));
            list.add(this.permanentWSDLGroupObjectList.get(1));
            list.add(this.permanentWSDLGroupObjectList.get(5));
            if (this.viewMode.isBindingVisible()) {
                list.add(this.permanentWSDLGroupObjectList.get(4));
            }
            list.add(this.permanentWSDLGroupObjectList.get(3));
            list.add(this.permanentWSDLGroupObjectList.get(2));
            if (this.extensibilityElementsGroup.getChildren().size() > 0) {
                list.add(this.extensibilityElementsGroup);
            }
            return list;
        }

        public void viewModeChanged(ViewMode mode) {
            this.firePropertyChangedHelper();
        }

        public ViewMode getViewMode() {
            return this.viewMode;
        }

        protected ModelAdapterFactory getModelAdapterFactory() {
            return WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory();
        }
    }

    protected class GraphBindingAdapter
    extends WSDLModelAdapterFactory.BindingAdapter {
        protected GraphBindingAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }
    }

    protected class GraphPartAdapter
    extends WSDLModelAdapterFactory.PartAdapter {
        protected GraphPartAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }
    }

    protected class GraphPortTypeAdapter
    extends WSDLModelAdapterFactory.PortTypeAdapter {
        protected GraphPortTypeAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if (propertyName.equals("bindings")) {
                ComponentReferenceUtil util = new ComponentReferenceUtil(this.portType.getEnclosingDefinition());
                result = util.getBindings(this.portType);
            } else {
                result = super.getProperty(modelObject, propertyName);
            }
            return result;
        }
    }

    protected class GraphPortAdapter
    extends WSDLModelAdapterFactory.PortAdapter
    implements ModelAdapterListener {
        protected GraphPortAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        protected List getChildren() {
            ArrayList<Binding> list = new ArrayList<Binding>();
            Binding binding = (Binding)this.port.getBinding();
            if (binding != null) {
                list.add(binding);
            }
            return list;
        }

        public void propertyChanged(Object object, String property) {
            this.firePropertyChanged(this.port, null);
        }
    }

    protected class GraphInputAdapter
    extends WSDLModelAdapterFactory.InputAdapter {
        protected GraphInputAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        protected List getChildren() {
            ArrayList<Message> list = new ArrayList<Message>();
            if (this.input.getMessage() != null) {
                list.add(this.input.getMessage());
            }
            return list;
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if (propertyName.equals("bindings")) {
                ComponentReferenceUtil util = new ComponentReferenceUtil(this.input.getEnclosingDefinition());
                result = util.getBindingInputs(this.input);
            } else {
                result = super.getProperty(modelObject, propertyName);
            }
            return result;
        }
    }

    protected class GraphOutputAdapter
    extends WSDLModelAdapterFactory.OutputAdapter {
        protected GraphOutputAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        protected List getChildren() {
            ArrayList<Message> list = new ArrayList<Message>();
            if (this.output.getMessage() != null) {
                list.add(this.output.getMessage());
            }
            return list;
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if (propertyName.equals("bindings")) {
                ComponentReferenceUtil util = new ComponentReferenceUtil(this.output.getEnclosingDefinition());
                result = util.getBindingOutputs(this.output);
            } else {
                result = super.getProperty(modelObject, propertyName);
            }
            return result;
        }
    }

    protected class GraphFaultAdapter
    extends WSDLModelAdapterFactory.FaultAdapter {
        protected GraphFaultAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        protected List getChildren() {
            ArrayList<Message> list = new ArrayList<Message>();
            if (this.fault.getMessage() != null) {
                list.add(this.fault.getMessage());
            }
            return list;
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if (propertyName.equals("bindings")) {
                ComponentReferenceUtil util = new ComponentReferenceUtil(this.fault.getEnclosingDefinition());
                result = util.getBindingFaults(this.fault);
            } else {
                result = super.getProperty(modelObject, propertyName);
            }
            return result;
        }
    }

    public class GraphTypesAdapter
    extends WSDLModelAdapterFactory.TypesAdapter {
        public GraphTypesAdapter() {
            super(WSDLGraphModelAdapterFactory.this);
        }

        protected List getChildren() {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator i = this.types.getEExtensibilityElements().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof XSDSchemaExtensibilityElement) {
                    XSDSchemaExtensibilityElement s = (XSDSchemaExtensibilityElement)o;
                    XSDSchema schema = s.getSchema();
                    if (schema == null) continue;
                    list.add(schema);
                    continue;
                }
                list.add(o);
            }
            return list;
        }
    }
}

