/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.wizards;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.ui.internal.viewers.NavigableTableViewer;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.dialogs.EditNamespaceInfoDialog;
import org.eclipse.wst.xml.ui.internal.dialogs.UpdateListener;
import org.eclipse.wst.xml.ui.internal.util.XMLCommonResources;

public class NamespaceTable
extends Composite {
    protected static final String NAMESPACE_URI = XMLCommonResources.getInstance().getString("_UI_LABEL_NAMESPACE_NAME");
    protected static final String PREFIX = XMLCommonResources.getInstance().getString("_UI_LABEL_PREFIX");
    protected static final String INCLUDE = WSDLEditorPlugin.getWSDLString("_UI_TITLE_SELECT");
    protected List namespaceInfoList = new Vector();
    protected List checkedList = new Vector();
    protected NamespaceNavigableTableViewer tableViewer;
    protected Button addButton;
    protected NamespaceInfoTableLabelProvider provider;
    protected UpdateListener updateListener;
    protected IPath resourceLocation;
    protected int visibleRows = -1;
    protected boolean dummyRowsRemoved = false;
    Table table;

    public NamespaceTable(Composite parent) {
        this(parent, -1, -1, -1);
    }

    public NamespaceTable(Composite parent, int visibleRows) {
        this(parent, -1, -1, visibleRows);
    }

    public NamespaceTable(Composite parent, int widthHint, int heightHint) {
        this(parent, widthHint, heightHint, -1);
    }

    public NamespaceTable(Composite parent, int widthHint, int heightHint, int visibleRows) {
        super(parent, 0);
        this.setLayout((Layout)this.createGridLayout());
        GridData fillGD = new GridData();
        fillGD.horizontalAlignment = 4;
        fillGD.grabExcessHorizontalSpace = true;
        fillGD.verticalAlignment = 4;
        fillGD.grabExcessVerticalSpace = true;
        this.setLayoutData(fillGD);
        Group namespaceInfoGroup = new Group((Composite)this, 0);
        namespaceInfoGroup.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_NAMESPACE_URIS_TO_BE_INCLUDED"));
        namespaceInfoGroup.setLayout((Layout)new GridLayout());
        GridData gd = fillGD;
        if (widthHint != -1) {
            gd.widthHint = widthHint;
        }
        if (heightHint != -1) {
            gd.heightHint = heightHint;
        }
        namespaceInfoGroup.setLayoutData((Object)gd);
        String[] titleArray = new String[]{INCLUDE, PREFIX, NAMESPACE_URI};
        this.table = new Table((Composite)namespaceInfoGroup, 65536);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)fillGD);
        this.table.setLinesVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object obj;
                TableItem item = NamespaceTable.this.table.getItem(new Point(e.x, e.y));
                if (item != null && (obj = item.getData()) != null) {
                    TableElement holder = (TableElement)obj;
                    TableColumn col = NamespaceTable.this.table.getColumn(0);
                    if (e.x < col.getWidth()) {
                        String currentState = holder.getChecked();
                        if (currentState.equals("true")) {
                            holder.setChecked("false");
                            NamespaceTable.this.checkedList.set(holder.getIndex(), "false");
                        } else if (currentState.equals("false")) {
                            holder.setChecked("true");
                            NamespaceTable.this.checkedList.set(holder.getIndex(), "true");
                        }
                        NamespaceTable.this.tableViewer.refresh();
                        if (NamespaceTable.this.updateListener != null) {
                            NamespaceTable.this.updateListener.updateOccured((Object)this, (Object)NamespaceTable.this.namespaceInfoList);
                        }
                    }
                }
            }
        });
        this.tableViewer = new NamespaceNavigableTableViewer(this.table);
        this.provider = new NamespaceInfoTableLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.tableViewer.setColumnProperties(titleArray);
        this.tableViewer.setCellModifier(new NamespaceInfoCellModifier());
        int[] widthArray = new int[]{10, 20, 50};
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < titleArray.length) {
            TableColumn column = new TableColumn(this.table, i);
            column.setText(titleArray[i]);
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(widthArray[i], true));
            ++i;
        }
        this.visibleRows = visibleRows;
        i = 0;
        while (i < visibleRows) {
            TableItem item = new TableItem(this.table, 0);
            item.setText("#######");
            ++i;
        }
        this.table.setLayout((Layout)layout);
        CellEditor[] cellEditors = new CellEditor[titleArray.length];
        cellEditors[0] = new NamespaceInfoCheckboxCellEditor((Composite)this.table);
        cellEditors[1] = new TextCellEditor((Composite)this.table);
        this.tableViewer.setCellEditors(cellEditors);
        this.initialize();
    }

    public void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public void setNamespaceInfoList(List namespaceInfoList) {
        this.namespaceInfoList = namespaceInfoList;
        this.update();
    }

    public List getNamespaceInfoList() {
        return this.namespaceInfoList;
    }

    public List getNamespaceCheckedList() {
        return this.checkedList;
    }

    public String getWSDLPrefix() {
        return ((NamespaceInfo)this.namespaceInfoList.get((int)0)).prefix;
    }

    public void setResourceLocation(IPath resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public GridLayout createGridLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    protected void initialize() {
        NamespaceInfo info1 = new NamespaceInfo();
        info1.prefix = "wsdl";
        info1.uri = "http://schemas.xmlsoap.org/wsdl/";
        this.namespaceInfoList.add(info1);
        this.checkedList.add("true");
        NamespaceInfo info2 = new NamespaceInfo();
        info2.prefix = "soap";
        info2.uri = "http://schemas.xmlsoap.org/wsdl/soap/";
        this.namespaceInfoList.add(info2);
        this.checkedList.add("false");
        NamespaceInfo info3 = new NamespaceInfo();
        info3.prefix = "http";
        info3.uri = "http://schemas.xmlsoap.org/wsdl/http/";
        this.namespaceInfoList.add(info3);
        this.checkedList.add("false");
        NamespaceInfo info4 = new NamespaceInfo();
        info4.prefix = "mime";
        info4.uri = "http://schemas.xmlsoap.org/wsdl/mime/";
        this.namespaceInfoList.add(info4);
        this.checkedList.add("false");
        NamespaceInfo info5 = new NamespaceInfo();
        info5.prefix = "soapenc";
        info5.uri = "http://schemas.xmlsoap.org/soap/encoding/";
        this.namespaceInfoList.add(info5);
        this.checkedList.add("false");
        NamespaceInfo info6 = new NamespaceInfo();
        info6.prefix = "soapenv";
        info6.uri = "http://schemas.xmlsoap.org/soap/envelope/";
        this.namespaceInfoList.add(info6);
        this.checkedList.add("false");
        NamespaceInfo info7 = new NamespaceInfo();
        info7.prefix = "xsi";
        info7.uri = "http://www.w3.org/2001/XMLSchema-instance";
        this.namespaceInfoList.add(info7);
        this.checkedList.add("false");
        NamespaceInfo info8 = new NamespaceInfo();
        info8.prefix = "xsd";
        info8.uri = "http://www.w3.org/2001/XMLSchema";
        this.namespaceInfoList.add(info8);
        this.checkedList.add("true");
        this.update();
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData hFillGD = new GridData();
        hFillGD.horizontalAlignment = 4;
        hFillGD.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)hFillGD);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Button hiddenButton = new Button(composite, 0);
        hiddenButton.setLayoutData((Object)gd);
        hiddenButton.setVisible(false);
        hiddenButton.setEnabled(false);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NamespaceTable.this.addButton) {
                    NamespaceTable.this.performNew();
                }
            }
        };
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)hFillGD);
        GridLayout buttonGridLayout = new GridLayout();
        buttonGridLayout.numColumns = 1;
        buttonGridLayout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)buttonGridLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.addButton = new Button(buttonComposite, 0);
        this.addButton.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_ADD"));
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)selectionListener);
    }

    public void performNew() {
        NamespaceInfo info = new NamespaceInfo();
        EditNamespaceInfoDialog dialog = this.invokeDialog(XMLCommonResources.getInstance().getString("_UI_LABEL_NEW_NAMESPACE_INFORMATION"), info);
        if (dialog.getReturnCode() == 0) {
            this.namespaceInfoList.add(info);
            this.checkedList.add("true");
            this.performDelayedUpdate();
        }
    }

    protected EditNamespaceInfoDialog invokeDialog(String title, NamespaceInfo info) {
        Shell shell = XMLCommonResources.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        EditNamespaceInfoDialog dialog = new EditNamespaceInfoDialog(shell, info);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setBlockOnOpen(true);
        dialog.setResourceLocation(this.resourceLocation);
        dialog.open();
        return dialog;
    }

    protected void performDelayedUpdate() {
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                NamespaceTable.this.update();
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
        if (this.updateListener != null) {
            this.updateListener.updateOccured((Object)this, (Object)this.namespaceInfoList);
        }
    }

    protected NamespaceInfo getTargetNamespaceInfo() {
        return this.namespaceInfoList != null && this.namespaceInfoList.size() > 0 ? (NamespaceInfo)this.namespaceInfoList.get(0) : null;
    }

    public void update() {
        this.updateHelper(this.namespaceInfoList);
    }

    public void updateHelper(List namespaceInfoList) {
        if (this.visibleRows != -1) {
        }
        ISelection selection = this.tableViewer.getSelection();
        this.tableViewer.setInput(namespaceInfoList);
        if (selection.isEmpty()) {
            if (namespaceInfoList.size() > 0) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(namespaceInfoList.get(0)));
            }
        } else {
            this.tableViewer.setSelection(selection);
        }
    }

    protected class NamespaceInfoCheckboxCellEditor
    extends CheckboxCellEditor
    implements MouseListener {
        public NamespaceInfoCheckboxCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
        }

        public void activate() {
            super.activate();
            this.deactivate();
            Display.getCurrent().getFocusControl().redraw();
        }

        public void mouseDown(MouseEvent e) {
            NamespaceTable.this.tableViewer.getTable().getItem(new Point(e.x, e.y));
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    protected class NamespaceInfoCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            if (property.equals(INCLUDE)) {
                return true;
            }
            return property.equals(PREFIX);
        }

        public Object getValue(Object element, String property) {
            int column = 0;
            if (property.equals(INCLUDE)) {
                column = 0;
            } else if (property.equals(PREFIX)) {
                column = 1;
            } else if (property.equals(NAMESPACE_URI)) {
                column = 2;
            }
            if (element instanceof TableElement) {
                return NamespaceTable.this.provider.getColumnText(element, column);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object obj;
            TableItem item = (TableItem)element;
            if (item != null && (obj = item.getData()) != null) {
                TableElement holder = (TableElement)obj;
                NamespaceInfo info = holder.getNamespaceInfo();
                if (property.equals(INCLUDE)) {
                    if (value instanceof Boolean) {
                        if (((Boolean)value).booleanValue()) {
                            holder.setChecked("true");
                            NamespaceTable.this.checkedList.set(holder.getIndex(), "true");
                        } else {
                            holder.setChecked("false");
                            NamespaceTable.this.checkedList.set(holder.getIndex(), "false");
                        }
                    }
                } else if (property.equals(PREFIX)) {
                    info.prefix = ((String)value).trim();
                }
                Runnable delayedUpdate = new Runnable(this){
                    final /* synthetic */ NamespaceInfoCellModifier this$1;
                    {
                        this.this$1 = namespaceInfoCellModifier;
                    }

                    public void run() {
                        NamespaceInfoCellModifier.access$0((NamespaceInfoCellModifier)this.this$1).tableViewer.refresh();
                    }
                };
                Display.getCurrent().asyncExec(delayedUpdate);
                if (NamespaceTable.this.updateListener != null) {
                    NamespaceTable.this.updateListener.updateOccured((Object)this, (Object)NamespaceTable.this.namespaceInfoList);
                }
            }
        }

        static /* synthetic */ NamespaceTable access$0(NamespaceInfoCellModifier namespaceInfoCellModifier) {
            return namespaceInfoCellModifier.NamespaceTable.this;
        }
    }

    protected class TableElement {
        NamespaceInfo info;
        int index;
        String checked = "true";

        TableElement(NamespaceInfo info, int index) {
            this.info = info;
            this.index = index;
        }

        public NamespaceInfo getNamespaceInfo() {
            return this.info;
        }

        public int getIndex() {
            return this.index;
        }

        public String getChecked() {
            return this.checked;
        }

        public void setChecked(String checked) {
            this.checked = checked;
        }
    }

    protected class NamespaceInfoTableLabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        protected NamespaceInfoTableLabelProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Vector<TableElement> v = new Vector<TableElement>();
            int i = 0;
            while (i < NamespaceTable.this.namespaceInfoList.size()) {
                NamespaceInfo info = (NamespaceInfo)NamespaceTable.this.namespaceInfoList.get(i);
                TableElement holder = new TableElement(info, i);
                holder.setChecked((String)NamespaceTable.this.checkedList.get(i));
                v.add(holder);
                ++i;
            }
            return v.toArray();
        }

        public String getColumnText(Object object, int column) {
            TableElement holder = (TableElement)object;
            NamespaceInfo info = holder.getNamespaceInfo();
            String result = null;
            switch (column) {
                case 1: {
                    result = info.prefix;
                    break;
                }
                case 2: {
                    result = info.uri;
                }
            }
            String string = result = result != null ? result.trim() : "";
            if (result.equals("")) {
                switch (column) {
                    case 2: {
                        result = XMLCommonResources.getInstance().getString("_UI_NO_NAMESPACE_NAME");
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex == 0 && object instanceof TableElement) {
                TableElement holder = (TableElement)object;
                String result = holder.getChecked();
                if (result.equals("true")) {
                    return WSDLEditorPlugin.getInstance().getImage("icons/output_yes.gif");
                }
                return WSDLEditorPlugin.getInstance().getImage("icons/output_no.gif");
            }
            return null;
        }

        public boolean isLabelProperty(Object object, Object property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    class NamespaceNavigableTableViewer
    extends NavigableTableViewer {
        public NamespaceNavigableTableViewer(Table parent) {
            super(parent);
        }
    }
}

