/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.data.internal.core.editor.ITableData;
import org.eclipse.wst.rdb.data.internal.ui.editor.CellSelection;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataCellModifier;

public class TableDataTableCursor
extends TableCursor
implements ISelectionProvider {
    protected TableViewer tableViewer;
    protected ListenerList selectionChangedListeners = new ListenerList();

    public TableDataTableCursor(TableViewer tableViewer) {
        super(tableViewer.getTable(), 0);
        this.tableViewer = tableViewer;
        this.setBackground(Display.getDefault().getSystemColor(26));
        this.setForeground(Display.getDefault().getSystemColor(27));
        this.registerCellEditorsListener();
        this.registerSelectionListener();
        this.registerKeyListener();
        this.registerMouseListener();
        this.registerTraverseListener();
    }

    protected void registerTraverseListener() {
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                TableDataTableCursor.this.handleTraverse(e);
            }
        });
    }

    protected void registerMouseListener() {
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    TableDataTableCursor.this.edit();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    protected void registerKeyListener() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character != '\u0000' && e.character != '\r' && e.character != '\n' && e.character != '\b' && e.character != '\u007f' && e.character != '\t' && e.character != '\u001b' && (e.stateMask == 0 || e.stateMask == 131072)) {
                    TableDataTableCursor.this.edit();
                    CellEditor editor = TableDataTableCursor.this.tableViewer.getCellEditors()[TableDataTableCursor.this.getColumn()];
                    if (editor instanceof TextCellEditor) {
                        editor.setValue((Object)String.valueOf(e.character));
                        ((Text)editor.getControl()).setSelection(1);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void registerSelectionListener() {
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDataTableCursor.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableDataTableCursor.this.edit();
            }
        });
    }

    protected void registerCellEditorsListener() {
        ICellEditorListener editorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                TableDataTableCursor.this.setVisible(true);
                TableDataTableCursor.this.redraw();
            }

            public void cancelEditor() {
                TableDataTableCursor.this.setVisible(true);
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        CellEditor[] editors = this.tableViewer.getCellEditors();
        int i = 0;
        while (i < editors.length) {
            if (editors[i] != null) {
                editors[i].addListener(editorListener);
            }
            ++i;
        }
    }

    public void edit() {
        if (((ITableData)this.tableViewer.getInput()).isReadonly()) {
            return;
        }
        Object o = this.getRow().getData();
        ((TableDataCellModifier)this.tableViewer.getCellModifier()).setCanModify(true);
        this.tableViewer.editElement(o, this.getColumn());
        ((TableDataCellModifier)this.tableViewer.getCellModifier()).setCanModify(false);
        this.setVisible(false);
    }

    protected void handleTraverse(TraverseEvent event) {
        int row = this.getRow() == null ? 0 : this.tableViewer.getTable().indexOf(this.getRow());
        int col = this.getColumn();
        switch (event.detail) {
            case 8: {
                if (col != 0) {
                    --col;
                } else if (row != 0) {
                    col = this.tableViewer.getTable().getColumnCount() - 1;
                    --row;
                } else {
                    return;
                }
                this.setSelection(row, col);
                event.doit = false;
                return;
            }
            case 16: {
                if (col != this.tableViewer.getTable().getColumnCount() - 1) {
                    ++col;
                } else if (row != this.tableViewer.getTable().getItemCount() - 1) {
                    col = 0;
                    ++row;
                } else {
                    return;
                }
                this.setSelection(row, col);
                event.doit = false;
                return;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.getRow() == null) {
            return null;
        }
        return new CellSelection(this.getRow().getData(), this.getColumn());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged() {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)TableDataTableCursor.this, TableDataTableCursor.this.getSelection()));
                }
            });
            ++i;
        }
    }
}

