/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.source;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.tests.util.FileUtil;

public class CSSTextParserTest
extends TestCase {
    private boolean fDump = false;
    private static final String FILES_DIR = "src/org/eclipse/wst/css/core/tests/testfiles";
    private static final String RESULTS_DIR = "src/org/eclipse/wst/css/core/tests/testfiles/results";

    public void testText1() throws IOException {
        this.textParserTest("sample01.css");
    }

    public void testText2() throws IOException {
        this.textParserTest("sample02.css");
    }

    public void testText3() throws IOException {
        this.textParserTest("sample03.css");
    }

    public void testText4() throws IOException {
        this.textParserTest("sample04.css");
    }

    public void testText5() throws IOException {
        this.textParserTest("sample05.css");
    }

    public void testText6() throws IOException {
        this.textParserTest("sample06.css");
    }

    public void testText7() throws IOException {
        this.textParserTest("sample07.css");
    }

    private void textParserTest(String filename) throws IOException {
        String source = this.createString(filename);
        CSSTextParser parser = new CSSTextParser(0, source);
        String result = this.dumpRegions(parser.getTokenList());
        this.compareResult(result, "CSSTextParserTest-" + filename);
    }

    private String createString(String filename) throws FileNotFoundException, IOException {
        return FileUtil.createString(FILES_DIR, filename);
    }

    private String dumpRegions(List tokens) {
        StringBuffer buf = new StringBuffer();
        Iterator i = tokens.iterator();
        while (i.hasNext()) {
            buf.append(this.dumpOneRegion((CSSTextToken)i.next()));
        }
        buf.append("\r\n-------\r\n");
        return buf.toString();
    }

    private String dumpOneRegion(CSSTextToken token) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(token.image);
        buf.append("] ");
        buf.append(token.kind);
        buf.append(" - ");
        buf.append(token.start);
        buf.append(", ");
        buf.append(token.length);
        buf.append("\r\n");
        return buf.toString();
    }

    private void compareResult(String actual, String filename) throws IOException {
        if (this.fDump) {
            FileUtil.dumpString(actual, RESULTS_DIR, filename);
        } else {
            String result = FileUtil.createString(RESULTS_DIR, filename);
            CSSTextParserTest.assertEquals((String)result, (String)actual);
        }
    }
}

