/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.tests.source;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.parser.CSSSourceParser;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.tests.util.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class CSSUrlTest
extends TestCase {
    public void testDeclaration1() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        ((CSSSourceParser)document.getParser()).setParserMode(2);
        document.set("background-image: url(white space.gif);");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
    }

    public void testDeclaration2() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        ((CSSSourceParser)document.getParser()).setParserMode(2);
        document.set("background-image: url(  white space.gif  );");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
    }

    public void testDeclaration3() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        ((CSSSourceParser)document.getParser()).setParserMode(2);
        document.set("background-image: url('white space.gif');");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
    }

    public void testDeclaration4() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        ((CSSSourceParser)document.getParser()).setParserMode(2);
        document.set("background-image: url(\"white space.gif\");");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
    }

    public void testDeclaration5() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        ((CSSSourceParser)document.getParser()).setParserMode(2);
        document.set("background-image: url(white space.gif); list-style-image: url(style image.gif);");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)2, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[1].getType());
        CSSUrlTest.assertEquals((String)"style image.gif", (String)urls[1].getUrl());
    }

    public void testStyleRule1() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        document.set("LI { background-image: url(white space.gif);\r\nlist-style-image: url(style image.gif); }");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)2, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[1].getType());
        CSSUrlTest.assertEquals((String)"style image.gif", (String)urls[1].getUrl());
    }

    public void testSomeRules1() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        document.set("@import url(white space.css);LI { background-image: url(white space.gif);list-style-image: url(style image.gif); }");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)3, (int)urls.length);
        CSSUrlTest.assertEquals((String)"URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.css", (String)urls[0].getUrl());
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[1].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[1].getUrl());
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[2].getType());
        CSSUrlTest.assertEquals((String)"style image.gif", (String)urls[2].getUrl());
    }

    public void testFixError1() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        ((CSSSourceParser)document.getParser()).setParserMode(2);
        document.set("background-image: url(white space.gif; list-style-image: urlstyle image.gif);");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif; list-style-image: urlstyle image.gif", (String)urls[0].getUrl());
        document.replaceText(null, 37, 0, ")");
        urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
        document.replaceText(null, 61, 0, "(");
        urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)2, (int)urls.length);
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[0].getUrl());
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[1].getType());
        CSSUrlTest.assertEquals((String)"style image.gif", (String)urls[1].getUrl());
    }

    public void testFixError2() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        document.set("@import url(white space.css;LI { background-image: urlwhite space.gif); }");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.css;LI { background-image: urlwhite space.gif", (String)urls[0].getUrl());
        document.replaceText(null, 27, 0, ")");
        urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.css", (String)urls[0].getUrl());
        document.replaceText(null, 55, 0, "(");
        urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)2, (int)urls.length);
        CSSUrlTest.assertEquals((String)"URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.css", (String)urls[0].getUrl());
        CSSUrlTest.assertEquals((String)"DECLARATION_VALUE_URI", (String)urls[1].getType());
        CSSUrlTest.assertEquals((String)"white space.gif", (String)urls[1].getUrl());
    }

    public void testFixError3() {
        ICSSModel model = FileUtil.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        document.set("@import url(white space.css\");");
        UrlInfo[] urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)0, (int)urls.length);
        document.replaceText(null, 27, 1, "");
        urls = this.pickupUrl(document);
        CSSUrlTest.assertEquals((int)1, (int)urls.length);
        CSSUrlTest.assertEquals((String)"URI", (String)urls[0].getType());
        CSSUrlTest.assertEquals((String)"white space.css", (String)urls[0].getUrl());
    }

    private UrlInfo[] pickupUrl(IStructuredDocument document) {
        ArrayList<UrlInfo> urls = new ArrayList<UrlInfo>();
        IStructuredDocumentRegion documentRegion = document.getFirstStructuredDocumentRegion();
        while (documentRegion != null) {
            ITextRegionList regionList = documentRegion.getRegions();
            Iterator i = regionList.iterator();
            while (i.hasNext()) {
                ITextRegion textRegion = (ITextRegion)i.next();
                String type = textRegion.getType();
                if (!type.equals("URI") && !type.equals("DECLARATION_VALUE_URI")) continue;
                urls.add(new UrlInfo(type, documentRegion.getFullText(textRegion)));
            }
            documentRegion = documentRegion.getNext();
        }
        return urls.toArray(new UrlInfo[urls.size()]);
    }

    private class UrlInfo {
        private String fType;
        private String fUrl;

        UrlInfo(String type, String url) {
            this.fType = type;
            this.fUrl = CSSUtil.extractUriContents((String)url);
        }

        String getType() {
            return this.fType;
        }

        String getUrl() {
            return this.fUrl;
        }
    }
}

