/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.breakpointproviders;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.ui.internal.provisional.IDOMSourceEditingTextTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractBreakpointProvider
implements IBreakpointProvider {
    protected static final int END_OF_LINE = -1;
    protected static final int JAVA = 1;
    protected static final int JAVASCRIPT = 2;
    private static final String[] JAVASCRIPT_LANGUAGE_KEYS = new String[]{"javascript", "javascript1.0", "javascript1.1_3", "javascript1.2", "javascript1.3", "javascript1.4", "javascript1.5", "javascript1.6", "jscript", "sashscript"};
    private static final String JSP_DIRECTIVE_PAGE = "jsp:directive.page";
    protected static final int NO_VALID_CONTENT = -2;
    protected static final int UNSUPPORTED = 0;
    private ISourceEditingTextTools fSourceEditingTextTools;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected static boolean contains(String[] haystack, String needle) {
        int i = 0;
        while (i < haystack.length) {
            if (haystack[i].equals(needle)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static int getPageLanguage(Document doc) {
        if (doc == null) {
            return 0;
        }
        NodeList pageDirectives = doc.getElementsByTagName(JSP_DIRECTIVE_PAGE);
        int i = 0;
        while (i < pageDirectives.getLength()) {
            Node child = pageDirectives.item(i);
            Node languageAttr = child.getAttributes().getNamedItem("language");
            if (languageAttr != null) {
                String pageLanguage = languageAttr.getNodeValue();
                if (pageLanguage == null || pageLanguage.length() == 0) {
                    return 0;
                }
                if (AbstractBreakpointProvider.contains(JAVASCRIPT_LANGUAGE_KEYS, pageLanguage = pageLanguage.toLowerCase())) {
                    return 2;
                }
                if (pageLanguage.equals("java")) {
                    return 1;
                }
                return 0;
            }
            ++i;
        }
        return 1;
    }

    private static int getValidRegionPosition(IStructuredModel model, ITextRegionCollection regionContainer, int startOffset, int endOffset) {
        ITextRegionList regions = regionContainer.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion region = regions.get(i);
            if (region instanceof ITextRegionCollection) {
                int validPosition = AbstractBreakpointProvider.getValidRegionPosition(model, (ITextRegionCollection)region, startOffset, endOffset);
                if (validPosition == -1 || validPosition >= 0) {
                    return validPosition;
                }
            } else if (regionContainer.getEndOffset(region) > startOffset) {
                Node domNode;
                Element root;
                int regionStartOffset = regionContainer.getStartOffset(region);
                if (regionStartOffset > endOffset) {
                    return -1;
                }
                if (region.getType().equals("JSP_CONTENT")) {
                    if (regionStartOffset > startOffset) {
                        return regionStartOffset;
                    }
                    return startOffset;
                }
                if (region.getType().equals("XML_TAG_NAME") && (AbstractBreakpointProvider.isCustomTagRegion(model.getIndexedRegion(regionStartOffset)) || regionContainer.getText(region).equals("jsp:useBean") || regionContainer.getText(region).equals("jsp:getProperty") || regionContainer.getText(region).equals("jsp:setProperty"))) {
                    if (regionStartOffset > startOffset) {
                        return regionStartOffset;
                    }
                    return startOffset;
                }
                boolean isCodeNode = false;
                IndexedRegion node = model.getIndexedRegion(regionStartOffset);
                if (node != null && node instanceof Node && (root = (domNode = (Node)node).getOwnerDocument().getDocumentElement()) != null && root.getNodeName().equals("jsp:root") && domNode.getNodeType() == 3 && domNode.getParentNode() != null) {
                    String parentName = domNode.getParentNode().getNodeName();
                    boolean bl = isCodeNode = parentName.equals("jsp:scriptlet") || parentName.equals("jsp:expression") || parentName.equals("jsp:declaration");
                }
                if (isCodeNode) {
                    if (regionStartOffset > startOffset) {
                        return regionStartOffset;
                    }
                    return startOffset;
                }
            }
            ++i;
        }
        return -2;
    }

    private static boolean isCustomTagRegion(IndexedRegion node) {
        Element xmlElement;
        ModelQuery mq;
        CMElementDeclaration decl;
        if (node instanceof Element && (decl = (mq = ModelQueryUtil.getModelQuery((Document)(xmlElement = (Element)node).getOwnerDocument())).getCMElementDeclaration(xmlElement)) instanceof CMNodeWrapper) {
            CMNode cmNode = ((CMNodeWrapper)decl).getOriginNode();
            return cmNode instanceof TLDElementDeclaration;
        }
        return false;
    }

    protected IResource getEditorInputResource(IEditorInput input) {
        IResource resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    public ISourceEditingTextTools getSourceEditingTextTools() {
        return this.fSourceEditingTextTools;
    }

    protected int getValidPosition(IDocument idoc, int lineNumber) {
        int endOffset;
        int startOffset;
        if (!(this.getSourceEditingTextTools() instanceof IDOMSourceEditingTextTools)) {
            return -2;
        }
        if (idoc == null) {
            return -2;
        }
        try {
            startOffset = idoc.getLineOffset(lineNumber - 1);
            endOffset = idoc.getLineOffset(lineNumber) - 1;
            if (idoc == null) {
                return -2;
            }
            String lineText = idoc.get(startOffset, endOffset - startOffset).trim();
            if (lineText.equals("") || lineText.equals("{") || lineText.equals("}") || lineText.equals("<%")) {
                return -2;
            }
        }
        catch (BadLocationException badLocationException) {
            return -2;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)idoc).getRegionAtCharacterOffset(startOffset);
        while (flatNode != null) {
            int validPosition = AbstractBreakpointProvider.getValidRegionPosition((IStructuredModel)((IDOMDocument)((IDOMSourceEditingTextTools)this.getSourceEditingTextTools()).getDOMDocument()).getModel(), (ITextRegionCollection)flatNode, startOffset, endOffset);
            if (validPosition == -1) {
                return -2;
            }
            if (validPosition >= 0) {
                return validPosition;
            }
            flatNode = flatNode.getNext();
        }
        return -2;
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools sourceEditingTextTools) {
        this.fSourceEditingTextTools = sourceEditingTextTools;
    }
}

