/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.contentassist.IBeanInfoProvider;
import org.eclipse.jst.jsp.ui.internal.contentassist.IJavaPropertyDescriptor;

public class BeanInfoProvider
implements IBeanInfoProvider {
    private HashMap fEncodedTypeMap = null;
    private HashSet fRepeatMethods = new HashSet();

    public IJavaPropertyDescriptor[] getRuntimeProperties(IResource baseResource, String typeName) {
        IJavaProject javaProject = JavaCore.create((IProject)baseResource.getProject());
        QualifiedName typeQualifiedName = this.getTypeQualifiedName(typeName);
        ArrayList getMethodResults = new ArrayList();
        ArrayList isMethodResults = new ArrayList();
        ArrayList setMethodResults = new ArrayList();
        ArrayList descriptorResults = new ArrayList();
        try {
            IType type = javaProject.findType(String.valueOf(typeQualifiedName.getQualifier()) + "." + typeQualifiedName.getLocalName());
            if (type != null) {
                ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
                IType[] supers = hierarchy.getAllSuperclasses(type);
                IMethod[] methods = type.getMethods();
                int i = 0;
                while (i < methods.length) {
                    this.acceptMethod(getMethodResults, isMethodResults, setMethodResults, methods[i]);
                    ++i;
                }
                i = 0;
                while (i < supers.length) {
                    methods = supers[i].getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        this.acceptMethod(getMethodResults, isMethodResults, setMethodResults, methods[j]);
                        ++j;
                    }
                    ++i;
                }
                this.adaptMethodsToPropertyDescriptors(getMethodResults, isMethodResults, setMethodResults, descriptorResults);
            }
        }
        catch (JavaModelException jmex) {
            Logger.logException("Problem navigating JavaProject in BeanInfoProvider", jmex);
        }
        IJavaPropertyDescriptor[] finalResults = new IJavaPropertyDescriptor[descriptorResults.size()];
        System.arraycopy(descriptorResults.toArray(), 0, finalResults, 0, descriptorResults.size());
        return finalResults;
    }

    private void adaptMethodsToPropertyDescriptors(List getMethods, List isMethods, List setMethods, List descriptors) throws JavaModelException {
        ArrayList readable = new ArrayList();
        HashMap types = new HashMap();
        this.filterGetMethods(getMethods, readable, types);
        this.filterIsMethods(isMethods, readable, types);
        Iterator it = setMethods.iterator();
        IMethod temp = null;
        String name = "";
        String type = "";
        String[] encodedParams = null;
        String returnType = "";
        String param0 = "";
        while (it.hasNext()) {
            temp = (IMethod)it.next();
            name = this.createPropertyNameFromMethod(temp);
            if (name == null || !(returnType = this.getDecodedTypeName(temp.getReturnType())).equals("void")) continue;
            encodedParams = temp.getParameterTypes();
            if (encodedParams != null && encodedParams.length > 0) {
                if (encodedParams.length > 1) {
                    param0 = this.getDecodedTypeName(encodedParams[0]);
                    if (!param0.equals("int")) continue;
                    type = this.getDecodedTypeName(encodedParams[1]);
                } else if (this.isArray(encodedParams[0])) {
                    type = this.getDecodedTypeName(encodedParams[0]);
                }
            }
            if (readable.contains(name)) {
                if (this.fRepeatMethods.contains(name)) continue;
                descriptors.add(new JavaPropertyDescriptor(name, (String)types.get(name), true, true));
                readable.remove(name);
                this.fRepeatMethods.add(name);
                continue;
            }
            String[] params = temp.getParameterTypes();
            if (params.length <= 0 || this.fRepeatMethods.contains(name)) continue;
            type = this.getDecodedTypeName(params[0]);
            descriptors.add(new JavaPropertyDescriptor(name, type, false, true));
            this.fRepeatMethods.add(name);
        }
        it = readable.iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            if (this.fRepeatMethods.contains(name)) continue;
            descriptors.add(new JavaPropertyDescriptor(name, (String)types.get(name), true, false));
            this.fRepeatMethods.add(name);
        }
    }

    private void filterGetMethods(List getMethods, List readable, HashMap types) throws JavaModelException {
        Iterator it = getMethods.iterator();
        while (it.hasNext()) {
            String encodedReturnType;
            String returnType;
            IMethod temp = (IMethod)it.next();
            String name = this.createPropertyNameFromMethod(temp);
            if (name == null || (returnType = this.getDecodedTypeName(encodedReturnType = temp.getReturnType())).equals("void")) continue;
            String[] encodedParams = temp.getParameterTypes();
            if (encodedParams != null && encodedParams.length == 1) {
                String paramType = this.getDecodedTypeName(encodedParams[0]);
                if (!paramType.equals("int")) continue;
                returnType = String.valueOf(returnType) + "[]";
            }
            readable.add(name);
            types.put(name, returnType);
        }
    }

    private void filterIsMethods(List isMethodResults, List readable, HashMap types) throws JavaModelException {
        Iterator it = isMethodResults.iterator();
        while (it.hasNext()) {
            String paramType;
            String[] encodedParams;
            String encodedReturnType;
            String returnType;
            IMethod temp = (IMethod)it.next();
            String name = this.createPropertyNameFromMethod(temp);
            if (name == null || !(returnType = this.getDecodedTypeName(encodedReturnType = temp.getReturnType())).equals("boolean") || (encodedParams = temp.getParameterTypes()) != null && encodedParams.length == 1 && !(paramType = this.getDecodedTypeName(encodedParams[0])).equals("int")) continue;
            readable.add(name);
            types.put(name, returnType);
        }
    }

    private String createPropertyNameFromMethod(IMethod temp) {
        String name = temp.getElementName();
        name = name.startsWith("is") ? Introspector.decapitalize(name.substring(2)) : Introspector.decapitalize(name.substring(3));
        return name;
    }

    private void acceptMethod(List getMethodResults, List isMethodResults, List setMethodResults, IMethod method) throws JavaModelException {
        if (!this.fRepeatMethods.contains(method.getElementName())) {
            this.fRepeatMethods.add(method.getElementName());
            int flags = method.getFlags();
            String methodName = method.getElementName();
            if (Flags.isPublic((int)flags)) {
                if (methodName.length() > 3 && methodName.startsWith("get")) {
                    getMethodResults.add(method);
                } else if (methodName.length() > 2 && methodName.startsWith("is")) {
                    isMethodResults.add(method);
                } else if (methodName.length() > 3 && methodName.startsWith("set")) {
                    setMethodResults.add(method);
                }
            }
        }
    }

    private QualifiedName getTypeQualifiedName(String typeName) {
        StringTokenizer st = new StringTokenizer(typeName, ".", false);
        int length = st.countTokens();
        int count = 0;
        StringBuffer root = new StringBuffer();
        while (count++ < length - 1) {
            root.append(st.nextToken());
            if (count >= length - 1) continue;
            root.append('.');
        }
        return new QualifiedName(root.toString(), st.nextToken());
    }

    private boolean isArray(String encodedTypeName) {
        return encodedTypeName != null && encodedTypeName.length() > 0 && encodedTypeName.charAt(0) == '[';
    }

    private String getDecodedTypeName(String encoded) {
        HashMap map = this.getEncodedTypeMap();
        StringBuffer decoded = new StringBuffer();
        int BRACKET = 91;
        String BRACKETS = "[]";
        char identifier = ' ';
        int last = 0;
        while (encoded.indexOf(BRACKET, last) != -1) {
            ++last;
        }
        identifier = encoded.charAt(last);
        Object primitiveType = map.get(String.valueOf(identifier));
        if (identifier == 'L' || identifier == 'Q') {
            String classname = encoded.substring(last + 1, encoded.length() - 1);
            decoded.append(classname);
        } else if (primitiveType != null) {
            decoded.append((String)primitiveType);
        } else {
            decoded.append(encoded);
        }
        if (last > 0) {
            int i = 0;
            while (i < last) {
                decoded.append(BRACKETS);
                ++i;
            }
        }
        return decoded.toString();
    }

    private HashMap getEncodedTypeMap() {
        if (this.fEncodedTypeMap == null) {
            this.fEncodedTypeMap = new HashMap();
            this.fEncodedTypeMap.put("B", "byte");
            this.fEncodedTypeMap.put("C", "char");
            this.fEncodedTypeMap.put("D", "double");
            this.fEncodedTypeMap.put("F", "float");
            this.fEncodedTypeMap.put("I", "int");
            this.fEncodedTypeMap.put("J", "long");
            this.fEncodedTypeMap.put("S", "short");
            this.fEncodedTypeMap.put("Z", "boolean");
            this.fEncodedTypeMap.put("V", "void");
        }
        return this.fEncodedTypeMap;
    }

    public class JavaPropertyDescriptor
    implements IJavaPropertyDescriptor {
        String fType = null;
        String fName = null;
        boolean fReadable = true;
        boolean fWritable = true;

        public JavaPropertyDescriptor(String name, String type, boolean readable, boolean writable) {
            this.fName = name;
            this.fType = type;
            this.fReadable = readable;
            this.fWritable = writable;
        }

        public String getDeclaredType() {
            return this.fType;
        }

        public String getDisplayName() {
            return this.fName;
        }

        public String getName() {
            return this.fName;
        }

        public boolean getReadable() {
            return this.fReadable;
        }

        public boolean getWriteable() {
            return this.fWritable;
        }
    }
}

