/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.tests.encoding.css;

import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.contenttype.CSSHeadTokenizer;
import org.eclipse.wst.css.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.css.tests.encoding.CSSEncodingTestsPlugin;

public class CSSHeadTokenizerTester
extends TestCase {
    private boolean DEBUG = false;
    private String fcharset;
    private final String fileDir = "css/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = "testfiles/css/";

    private void doTestFile(String filename, String expectedName) throws IOException {
        this.doTestFile(filename, expectedName, null);
    }

    private void doTestFile(String filename, String expectedName, String finalTokenType) throws IOException {
        CSSHeadTokenizer tokenizer = null;
        Reader fileReader = null;
        try {
            if (this.DEBUG) {
                System.out.println();
                System.out.println("       " + filename);
                System.out.println();
            }
            fileReader = CSSEncodingTestsPlugin.getTestReader(filename);
            tokenizer = new CSSHeadTokenizer(fileReader);
        }
        catch (IOException e) {
            System.out.println("Error opening file \"" + filename + "\"");
            throw e;
        }
        Object resultToken = null;
        HeadParserToken token = this.parseHeader(tokenizer);
        String resultValue = this.fcharset;
        fileReader.close();
        if (finalTokenType != null) {
            CSSHeadTokenizerTester.assertTrue((String)("did not end as expected. found:  " + token.getType()), (boolean)finalTokenType.equals(token.getType()));
        } else if (expectedName == null) {
            CSSHeadTokenizerTester.assertTrue((String)("expected no encoding, but found: " + resultValue), (resultToken == null ? 1 : 0) != 0);
        } else {
            CSSHeadTokenizerTester.assertTrue((String)("expected " + expectedName + " but found " + resultValue), (boolean)expectedName.equals(resultValue));
        }
    }

    private boolean isLegalString(String tokenType) {
        if (tokenType == null) {
            return false;
        }
        return tokenType.equals("strval") || tokenType.equals("UnDelimitedStringValue") || tokenType.equals("InvalidTerminatedStringValue") || tokenType.equals("InvalidTermintatedUnDelimitedStringValue");
    }

    private HeadParserToken parseHeader(CSSHeadTokenizer tokenizer) throws IOException {
        HeadParserToken token = null;
        HeadParserToken finalToken = null;
        do {
            HeadParserToken valueToken;
            String valueTokenType;
            String tokenType;
            if ((tokenType = (token = tokenizer.getNextToken()).getType()) != "CHARSET_RULE" || !tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
            this.fcharset = valueToken.getText();
        } while (tokenizer.hasMoreTokens());
        finalToken = token;
        return finalToken;
    }

    public void testBestCase() throws IOException {
        String filename = "testfiles/css/nonStandard.css";
        this.doTestFile(filename, "ISO-8859-6");
    }

    public void testEmptyFile() throws IOException {
        String filename = "testfiles/css/emptyFile.css";
        this.doTestFile(filename, null);
    }

    public void testEUCJP() throws IOException {
        String filename = "testfiles/css/encoding_test_eucjp.css";
        this.doTestFile(filename, "EUC-JP");
    }

    public void testJIS() throws IOException {
        String filename = "testfiles/css/encoding_test_jis.css";
        this.doTestFile(filename, "ISO-2022-JP");
    }

    public void testNoEncoding() throws IOException {
        String filename = "testfiles/css/noEncoding.css";
        this.doTestFile(filename, null);
    }

    public void testnonStandardIllFormed() throws IOException {
        String filename = "testfiles/css/nonStandardIllFormed.css";
        this.doTestFile(filename, "ISO-8859-6");
    }

    public void testnonStandardIllFormed2() throws IOException {
        String filename = "testfiles/css/nonStandardIllFormed2.css";
        this.doTestFile(filename, "ISO-8859-6");
    }

    public void testShiftJIS() throws IOException {
        String filename = "testfiles/css/encoding_test_sjis.css";
        this.doTestFile(filename, "SHIFT_JIS");
    }
}

