/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.xml.tests.encoding.FileUtil;
import org.eclipse.wst.xml.tests.encoding.GenerateFiles;

public class GenerateXMLFiles
extends GenerateFiles {
    private String LF = "\n";
    private String CR = "\r";
    private String CRLF = String.valueOf(this.CR) + this.LF;
    private String textUS_ASCII_LF = "abcdefghijklmnopqrstuvwxyz\n1234567890\nABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String textUS_ASCII_CRLF = "abcdefghijklmnopqrstuvwxyz\r\n1234567890\r\nABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private boolean DEBUG = true;
    private boolean DEBUGCRLF = false;
    private boolean DEBUGINFO = true;

    public static void main(String[] args) {
        GenerateXMLFiles thisApp = new GenerateXMLFiles();
        try {
            thisApp.generateAllFilesForCurrentVM();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateAllFilesForCurrentVM() throws IOException {
        SortedMap<String, Charset> allCharsetMap = Charset.availableCharsets();
        Set allKeys = allCharsetMap.keySet();
        Object[] allcharsets = allKeys.toArray();
        String[] allcharsetNames = new String[allcharsets.length];
        int i = 0;
        while (i < allcharsets.length) {
            allcharsetNames[i] = allcharsets[i].toString();
            ++i;
        }
        this.createFiles(allcharsetNames, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFiles(String[] charsetnames, boolean useCRLF) throws FileNotFoundException, IOException {
        String charsetName = null;
        Writer out = null;
        String mainDirectory = GenerateXMLFiles.getMainDirectoryBasedOnVMNameAndFileExtension();
        ArrayList<String> charsetFilesWritten = new ArrayList<String>();
        int i = 0;
        while (i < charsetnames.length) {
            block16: {
                Object var19_23;
                try {
                    block15: {
                        String msg;
                        try {
                            charsetName = charsetnames[i];
                            Charset charset = Charset.forName(charsetName);
                            CharsetEncoder charsetEncoder = charset.newEncoder();
                            charsetEncoder.onMalformedInput(CodingErrorAction.REPORT);
                            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                            String header = String.valueOf(this.getHeaderStart()) + charsetName + this.getHeaderEnd();
                            String fulltext = null;
                            fulltext = useCRLF ? String.valueOf(header) + this.textUS_ASCII_CRLF : String.valueOf(header) + this.textUS_ASCII_LF;
                            if (this.isEbcidic(charsetName, charsetEncoder)) break block15;
                            if (charsetEncoder.canEncode(fulltext)) {
                                String outputfilename = "test-" + charsetName + ".xml";
                                File outFile = FileUtil.makeFileFor(mainDirectory, outputfilename, null);
                                FileOutputStream outputStream = new FileOutputStream(outFile);
                                ByteArrayOutputStream bytesout = new ByteArrayOutputStream();
                                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)outputStream, charsetEncoder);
                                OutputStreamWriter byteWriter = new OutputStreamWriter((OutputStream)bytesout, charsetEncoder);
                                this.supplyBOMs(charsetName, outputStream, bytesout);
                                out = new BufferedWriter(fileWriter);
                                out.write(fulltext);
                                byteWriter.write(fulltext);
                                out.close();
                                ((Writer)byteWriter).flush();
                                String writtenRecord = charsetName;
                                charsetFilesWritten.add(writtenRecord);
                                if (this.DEBUG) {
                                    this.printDebugInfo(useCRLF, header, outputfilename, bytesout);
                                }
                                break block15;
                            }
                            if (this.DEBUGINFO) {
                                System.out.println(" *** could not convert sample ascii text for " + charsetName);
                            }
                        }
                        catch (IOException e) {
                            if (this.DEBUGINFO) {
                                System.out.println(" ***** could not generate for " + charsetName);
                                msg = e.getMessage();
                                if (msg == null) {
                                    msg = "";
                                }
                                System.out.println("          due to " + e.getClass().getName() + "  " + msg);
                            }
                        }
                        catch (Exception e) {
                            if (!this.DEBUGINFO) break block15;
                            System.out.println(" ***** could not generate for " + charsetName);
                            msg = e.getMessage();
                            if (msg == null) {
                                msg = "";
                            }
                            System.out.println("          due to " + e.getClass().getName() + "  " + msg);
                        }
                    }
                    var19_23 = null;
                    if (out == null) break block16;
                }
                catch (Throwable throwable) {
                    var19_23 = null;
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                out.close();
            }
            ++i;
        }
        File outFile = FileUtil.makeFileFor(mainDirectory, "testMethods.text", null);
        FileWriter outproperties = new FileWriter(outFile);
        outproperties.write(String.valueOf(charsetFilesWritten.size()) + this.CRLF);
        Iterator items = charsetFilesWritten.iterator();
        int n = 0;
        while (items.hasNext()) {
            String itemCreated = (String)items.next();
            String testMethod = this.createMethod(n++, itemCreated);
            outproperties.write(String.valueOf(testMethod) + this.CRLF);
        }
        outproperties.close();
    }

    private void supplyBOMs(String charsetName, OutputStream outputStream, ByteArrayOutputStream bytesout) throws IOException {
        byte[] nullBytes = new byte[2];
        if (charsetName.equals("UTF-16")) {
            outputStream.write(IContentDescription.BOM_UTF_16LE);
            bytesout.write(IContentDescription.BOM_UTF_16LE);
        }
        if (charsetName.equals("UTF-16LE")) {
            outputStream.write(IContentDescription.BOM_UTF_16LE);
            bytesout.write(IContentDescription.BOM_UTF_16LE);
        }
        if (charsetName.equals("X-UnicodeLittle")) {
            outputStream.write(IContentDescription.BOM_UTF_16LE);
            bytesout.write(IContentDescription.BOM_UTF_16LE);
        }
        if (charsetName.equals("UTF-16BE")) {
            outputStream.write(IContentDescription.BOM_UTF_16BE);
            bytesout.write(IContentDescription.BOM_UTF_16BE);
        }
        if (charsetName.equals("X-UnicodeBig")) {
            outputStream.write(IContentDescription.BOM_UTF_16BE);
            bytesout.write(IContentDescription.BOM_UTF_16BE);
        }
        if (charsetName.equals("UTF-32")) {
            outputStream.write(nullBytes);
            outputStream.write(IContentDescription.BOM_UTF_16LE);
            bytesout.write(nullBytes);
            bytesout.write(IContentDescription.BOM_UTF_16LE);
        }
        if (charsetName.equals("UTF-32LE")) {
            outputStream.write(nullBytes);
            outputStream.write(IContentDescription.BOM_UTF_16LE);
            bytesout.write(nullBytes);
            bytesout.write(IContentDescription.BOM_UTF_16LE);
        }
        if (charsetName.equals("UTF-32BE")) {
            outputStream.write(nullBytes);
            outputStream.write(IContentDescription.BOM_UTF_16BE);
            bytesout.write(nullBytes);
            bytesout.write(IContentDescription.BOM_UTF_16BE);
        }
    }

    private String createMethod(int i, String itemCreated) {
        String template = "\tpublic void testFile" + i + "() throws CoreException, IOException  {\r\n" + "\t\tString charsetName = \"" + itemCreated + "\";\r\n" + "\t\tdoGenTest(charsetName);\r\n" + "\t}";
        return template;
    }

    private void printDebugInfo(boolean useCRLF, String header, String outputfilename, ByteArrayOutputStream bytesout) {
        byte[] bytes = bytesout.toByteArray();
        int nBytes = bytes.length;
        int nChars = 0;
        nChars = useCRLF ? header.length() + this.textUS_ASCII_CRLF.length() : header.length() + this.textUS_ASCII_LF.length();
        System.out.println("Wrote " + nChars + " characters and " + nBytes + " bytes to " + outputfilename);
    }

    boolean canEncodeSimpleString(String charsetName, CharsetEncoder charsetEncocder, String simpleString) {
        boolean result = false;
        String newAsciiString = null;
        byte[] translatedBytes = null;
        try {
            translatedBytes = simpleString.getBytes(charsetName);
            newAsciiString = new String(translatedBytes, "ascii");
            new String(translatedBytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        result = simpleString.equals(newAsciiString);
        if (!result && charsetEncocder.maxBytesPerChar() != 1.0f) {
            result = true;
            if (charsetEncocder.maxBytesPerChar() == 4.0f) {
                result = false;
                if (charsetEncocder.averageBytesPerChar() == 2.0f) {
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean isEbcidic(String charsetName, CharsetEncoder charsetEncocder) {
        boolean result = false;
        String simpleString = "<?";
        String newAsciiString = null;
        byte[] translatedBytes = null;
        try {
            translatedBytes = simpleString.getBytes(charsetName);
            newAsciiString = new String(translatedBytes, "ascii");
            new String(translatedBytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        result = "Lo".equals(newAsciiString);
        if (result) {
            System.out.println(String.valueOf(charsetName) + " assumed to be Edcidic");
        }
        return result;
    }

    boolean canEncodeCRLF(String charsetName, CharsetEncoder charsetEncoder) {
        String testString;
        String stringName;
        boolean result = true;
        charsetEncoder.charset().name();
        if (!charsetEncoder.canEncode(this.LF)) {
            if (this.DEBUGCRLF) {
                stringName = "LF";
                testString = this.LF;
                this.exploreConversion(charsetName, stringName, testString);
                System.out.println("can not encode LF for " + charsetEncoder.charset().name());
            }
            result = false;
        }
        if (!charsetEncoder.canEncode(this.CR)) {
            if (this.DEBUGCRLF) {
                stringName = "CR";
                testString = this.CR;
                this.exploreConversion(charsetName, stringName, testString);
                System.out.println("can not encode CR for " + charsetEncoder.charset().name());
            }
            result = false;
        }
        if (!charsetEncoder.canEncode(this.CRLF)) {
            if (this.DEBUGCRLF) {
                stringName = "CRLF";
                testString = this.CRLF;
                this.exploreConversion(charsetName, stringName, testString);
                System.out.println("can not encode CRLF for " + charsetEncoder.charset().name());
            }
            result = false;
        }
        return result;
    }

    private void exploreConversion(String charsetName, String stringName, String testString) throws Error {
        try {
            String newLF = new String(testString.getBytes(charsetName));
            System.out.print("old " + stringName + " (dec): ");
            this.dumpString(System.out, testString);
            System.out.println();
            System.out.print("new " + stringName + " (dec): ");
            this.dumpString(System.out, newLF);
            System.out.println();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private void dumpString(PrintStream out, String lf2) {
        int i = 0;
        while (i < lf2.length()) {
            out.print(String.valueOf((int)lf2.charAt(i)) + " ");
            ++i;
        }
    }

    public static final String getMainDirectoryBasedOnVMNameAndFileExtension() {
        String mainDirectory = String.valueOf(GenerateXMLFiles.getMainDirectoryBasedOnVMName()) + "/xml";
        return mainDirectory;
    }

    private String getHeaderStart() {
        return "<?xml version=\"1.0\" encoding=\"";
    }

    private String getHeaderEnd() {
        return "\"?>";
    }
}

