/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.providers.DelegateShowProjectContentProvider;
import org.eclipse.jst.common.navigator.internal.workingset.views.IMultiElementTreeContentProvider;
import org.eclipse.jst.common.navigator.internal.workingset.views.TreePath;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;

public class DelegateWorkingSetContentProvider
extends DelegateShowProjectContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;

    public DelegateWorkingSetContentProvider(WorkingSetModel model) {
        this.fWorkingSetModel = model;
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                DelegateWorkingSetContentProvider.this.workingSetModelChanged(event);
            }
        };
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object element) {
        Object[] children = NO_CHILDREN;
        if (element instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == element ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        children = element instanceof IWorkingSet ? this.fWorkingSetModel.getChildren((IWorkingSet)element) : (element instanceof IWorkspaceRoot ? this.fWorkingSetModel.getActiveWorkingSets() : super.getChildren(element));
        return children;
    }

    public TreePath[] getTreePaths(Object element) {
        if (element instanceof IWorkingSet) {
            TreePath path = new TreePath(new Object[]{element});
            return new TreePath[]{path};
        }
        List modelParents = this.getRootPath(element);
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < modelParents.size()) {
            result.addAll(this.getTreePaths(modelParents, i));
            ++i;
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List getRootPath(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(element);
        Object parent = super.getParent(element);
        Object input = this.getViewerInput();
        while (parent != null && !parent.equals(input) && !(parent instanceof IWorkspaceRoot)) {
            result.add(parent);
            parent = super.getParent(parent);
        }
        Collections.reverse(result);
        return result;
    }

    private List getTreePaths(List modelParents, int index) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object input = this.getViewerInput();
        Object element = modelParents.get(index);
        Object[] parents = this.fWorkingSetModel.getAllParents(element);
        int i = 0;
        while (i < parents.length) {
            ArrayList<Object> chain = new ArrayList<Object>();
            if (!parents[i].equals(input)) {
                chain.add(parents[i]);
            }
            int m = index;
            while (m < modelParents.size()) {
                chain.add(modelParents.get(m));
                ++m;
            }
            result.add(new TreePath(chain.toArray()));
            ++i;
        }
        return result;
    }

    public Object getParent(Object child) {
        if (child instanceof IWorkingSet) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        Object[] parents = this.fWorkingSetModel.getAllParents(child);
        if (parents.length == 0) {
            return super.getParent(child);
        }
        Object first = parents[0];
        if (first instanceof IWorkingSet && "org.eclipse.jst.common.navigator.ui.HistoryWorkingSet".equals(((IWorkingSet)first).getId())) {
            if (parents.length > 1) {
                return parents[1];
            }
            return super.getParent(child);
        }
        return first;
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
        Object parent;
        if (JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(affectedElement)) {
            toRefresh.remove(affectedElement);
            toRefresh.add(this.fWorkingSetModel);
        } else if (relation == 2 && (parent = this.internalGetParent(affectedElement)) != null) {
            toRefresh.addAll(Arrays.asList(this.fWorkingSetModel.getAllParents(parent)));
        }
    }

    private void workingSetModelChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(property)) {
            toRefresh.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(property)) {
            toRefresh.add(newValue);
        } else if ("workingSetNameChange".equals(property)) {
            toRefresh.add(newValue);
        }
        this.postRefresh(toRefresh, true);
    }

    void postRefresh(final List toRefresh, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Control ctrl = DelegateWorkingSetContentProvider.this.fViewer.getControl();
                if (ctrl == null) return;
                if (ctrl.isDisposed()) return;
                try {
                    DelegateWorkingSetContentProvider.this.fViewer.getControl().setRedraw(false);
                    Iterator iter = toRefresh.iterator();
                    while (iter.hasNext()) {
                        Object next = iter.next();
                        if (next instanceof WorkingSetModel) {
                            DelegateWorkingSetContentProvider.this.fViewer.refresh((Object)ResourcesPlugin.getWorkspace().getRoot(), updateLabels);
                            continue;
                        }
                        DelegateWorkingSetContentProvider.this.fViewer.refresh(next, updateLabels);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    DelegateWorkingSetContentProvider.this.fViewer.getControl().setRedraw(true);
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                DelegateWorkingSetContentProvider.this.fViewer.getControl().setRedraw(true);
            }
        });
    }
}

