/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.tests.unittest.WSJUnitConstants;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseProgressMonitor;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ResourceUtilsTests
extends TestCase
implements WSJUnitConstants {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.ws.tests.unittest.ResourceUtilsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testComponentType() {
        IProject project = ProjectUtilities.getProject((String)"FlexProject");
        String componentType = ResourceUtils.getComponentType((IProject)project, (String)"webComponent");
        ResourceUtilsTests.assertEquals((String)"jst.web", (String)componentType);
    }

    public void testComponentOf() {
        IProject project = ProjectUtilities.getProject((String)"FlexProject");
        IPath destPath = ResourceUtils.getJavaSourceLocation((IProject)project, (String)"webComponent");
        IFolder folder = (IFolder)ResourceUtils.findResource((IPath)destPath);
        try {
            PersistentResourceContext resourceContext = PersistentResourceContext.getInstance();
            EclipseStatusHandler handler = new EclipseStatusHandler();
            EclipseProgressMonitor monitor = new EclipseProgressMonitor();
            EclipseEnvironment env = new EclipseEnvironment(null, (ResourceContext)resourceContext, (ProgressMonitor)monitor, (StatusHandler)handler);
            JUnitUtils.copyTestData("BUJava/src", folder, (Environment)env);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        IPath javaFilePath = folder.getFile((IPath)new Path("foo/Echo.java")).getFullPath();
        IVirtualComponent vc = ResourceUtils.getComponentOf((IPath)javaFilePath);
        ResourceUtilsTests.assertTrue((boolean)vc.exists());
    }

    public void testJavaSourceLocation() {
        IPath path2;
        IResource resource2;
        IProject project = ProjectUtilities.getProject((String)"FlexProject");
        String javaSourceLoc = ResourceUtils.getJavaSourceLocation((IProject)project, (String)"webComp2").toString();
        System.out.println("Java source location = " + javaSourceLoc);
        ResourceUtilsTests.assertTrue((boolean)javaSourceLoc.endsWith("JavaSource"));
        IVirtualComponent vc1 = ComponentCore.createComponent((IProject)project, (String)"webComp2");
        IVirtualComponent vc2 = ComponentCore.createComponent((IProject)project, (String)"webComponent");
        IVirtualComponent[] vcs = new IVirtualComponent[]{vc1, vc2};
        IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IVirtualComponent[])vcs);
        IPath path1 = paths[0];
        IResource resource = ResourceUtils.findResource((IPath)path1);
        if (resource.exists()) {
            ResourceUtilsTests.assertEquals((int)2, (int)resource.getType());
        }
        if ((resource2 = ResourceUtils.findResource((IPath)(path2 = paths[1]))).exists()) {
            ResourceUtilsTests.assertEquals((int)2, (int)resource2.getType());
        }
    }

    public void testWebComponentServerRoot() {
        IProject project = ProjectUtilities.getProject((String)"FlexProject");
        IFolder folder = ResourceUtils.getWebComponentServerRoot((IProject)project, (String)"webComponent");
        ResourceUtilsTests.assertTrue((boolean)folder.exists());
    }
}

