/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.web.operations.WebNatureRuntimeUtilities;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.context.ScenarioContext;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.jst.ws.tests.plugin.TestsPlugin;
import org.eclipse.jst.ws.tests.util.AccumulateStatusHandler;
import org.eclipse.jst.ws.tests.util.DynamicPopupJUnitWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.common.WaitForAutoBuildCommand;
import org.eclipse.wst.command.internal.env.context.PersistentActionDialogsContext;
import org.eclipse.wst.command.internal.env.preferences.ActionDialogPreferenceType;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.common.frameworks.internal.FlexibleJavaProjectPreferenceUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.internal.ui.plugin.WSUIPlugin;
import org.eclipse.wst.ws.internal.ui.wsi.preferences.PersistentWSIAPContext;
import org.eclipse.wst.ws.internal.ui.wsi.preferences.PersistentWSISSBPContext;

public class JUnitUtils {
    public static IRuntime createServerRuntime(String runtimeTypeId, String serverInstallPath) throws Exception {
        IRuntimeType rt = ServerCore.findRuntimeType((String)runtimeTypeId);
        IRuntimeWorkingCopy wc = rt.createRuntime("aRuntime", null);
        wc.setLocation((IPath)new Path(serverInstallPath));
        return wc.save(true, null);
    }

    public static IServer createServer(String name, String serverTypeId, IRuntime runtime, Environment env) throws Exception {
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerType().getId().equals(serverType.getId())) {
                return servers[i];
            }
            ++i;
        }
        IServerWorkingCopy serverWc = serverType.createServer(serverTypeId, null, EnvironmentUtils.getIProgressMonitor((Environment)env));
        serverWc.setName(name);
        serverWc.setRuntime(runtime);
        IServer server = serverWc.saveAll(true, EnvironmentUtils.getIProgressMonitor((Environment)env));
        return server;
    }

    public static IServer createServer(String javaRuntimePath, String jreID, String name, String serverTypeId, IRuntime runtime, Environment env) throws Exception {
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getServerType().getId().equals(serverType.getId())) {
                return servers[i];
            }
            ++i;
        }
        IServerWorkingCopy serverWc = serverType.createServer(serverTypeId, null, EnvironmentUtils.getIProgressMonitor((Environment)env));
        serverWc.setName(name);
        serverWc.setRuntime(runtime);
        IServer server = serverWc.saveAll(true, EnvironmentUtils.getIProgressMonitor((Environment)env));
        return server;
    }

    public static void startServer(IServer server, Environment env) throws Exception {
        final IServer currentServer = server;
        final Environment currentEnv = env;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    currentServer.start("run", EnvironmentUtils.getIProgressMonitor((Environment)currentEnv));
                }
                catch (CoreException e) {
                    InterruptedException wrapper = new InterruptedException(e.getMessage());
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
        };
        PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
    }

    public static boolean removeEARFromServer(IServer server, IProject earProject, Environment env) throws Exception {
        int numberOfModules = server.getModules().length;
        if (server != null) {
            final IModule[] modules = ServerUtil.getModules((IProject)earProject);
            IModule earProjectModule = modules[0];
            new ServerUtils().modifyModules(env, server, earProjectModule, false, EnvironmentUtils.getIProgressMonitor((Environment)env));
            final IServer currentServer = server;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int i = 0;
                    while (i < 1000) {
                        int moduleState = currentServer.getModuleState(modules);
                        if (moduleState != 2 && moduleState != 3) break;
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                        ++i;
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            return server.getModules().length == numberOfModules - 1;
        }
        return false;
    }

    public static boolean removeModuleFromServer(IServer server, IProject webProject, Environment env) throws Exception {
        int numberOfModules = server.getModules().length;
        if (server != null) {
            final IModule[] modules = ServerUtil.getModules((IProject)webProject);
            IModule webProjectModule = modules[0];
            new ServerUtils().modifyModules(env, server, webProjectModule, false, EnvironmentUtils.getIProgressMonitor((Environment)env));
            final IServer currentServer = server;
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int i = 0;
                    while (i < 1000) {
                        int moduleState = currentServer.getModuleState(modules);
                        if (moduleState != 2 && moduleState != 3) break;
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                        ++i;
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            return server.getModules().length == numberOfModules - 1;
        }
        return false;
    }

    public static void syncBuildProject(IProject project, Environment env) throws Exception {
        project.build(6, EnvironmentUtils.getIProgressMonitor((Environment)env));
        WaitForAutoBuildCommand cmd = new WaitForAutoBuildCommand();
        cmd.execute(env);
    }

    private static void copyTestFiles(String pathString, int rootSegmentLength, IFolder destFolder, Environment env) throws Exception {
        Enumeration e = TestsPlugin.getDefault().getBundle().getEntryPaths(pathString);
        while (e.hasMoreElements()) {
            String filePath = (String)e.nextElement();
            if (filePath.endsWith("/")) {
                JUnitUtils.copyTestFiles(filePath, rootSegmentLength, destFolder, env);
                continue;
            }
            Path fileIPath = new Path(filePath);
            FileResourceUtils.copyFile((ResourceContext)EnvironmentUtils.getResourceContext((Environment)env), (Plugin)TestsPlugin.getDefault(), (IPath)fileIPath.removeLastSegments(fileIPath.segmentCount() - rootSegmentLength), (IPath)new Path(filePath).removeFirstSegments(rootSegmentLength), (IPath)destFolder.getFullPath(), (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
        }
    }

    public static void copyTestData(String dataSubdirectory, IFolder destFolder, Environment env) throws Exception {
        String pathString = "/data/" + dataSubdirectory;
        JUnitUtils.copyTestFiles(pathString, new Path(pathString).segmentCount(), destFolder, env);
    }

    public static void hideActionDialogs() {
        PersistentActionDialogsContext actionDialogsCtx = PersistentActionDialogsContext.getInstance();
        ActionDialogPreferenceType[] actionDialogPrefs = actionDialogsCtx.getDialogs();
        int i = 0;
        while (i < actionDialogPrefs.length) {
            actionDialogsCtx.setActionDialogEnabled(actionDialogPrefs[i].getId(), true);
            ++i;
        }
    }

    public static boolean enableProxyGeneration(boolean enable) {
        ScenarioContext ctx = WebServicePlugin.getInstance().getScenarioContext();
        boolean previousSetting = ctx.getGenerateProxy();
        ctx.setGenerateProxy(enable);
        return previousSetting;
    }

    public static void enableFlexProjectPreference() {
        FlexibleJavaProjectPreferenceUtil.setMultipleModulesPerProjectProp((boolean)true);
    }

    public static boolean enableOverwrite(boolean enable) {
        ResourceContext ctx = WebServicePlugin.getInstance().getResourceContext();
        boolean previousSetting = ctx.isOverwriteFilesEnabled();
        ctx.setOverwriteFilesEnabled(enable);
        return previousSetting;
    }

    public static void disableWSIDialog(IProject project) {
        PersistentWSIAPContext ctx = WSUIPlugin.getInstance().getWSIAPContext();
        ctx.updateProjectWSICompliances(project, "2");
        PersistentWSISSBPContext ctx2 = WSUIPlugin.getInstance().getWSISSBPContext();
        ctx2.updateProjectWSICompliances(project, "2");
    }

    public static void setJ2EEWSRuntimeServer(String j2eeLevel, String wsRuntimeId, String serverTypeId) {
        PersistentServerRuntimeContext serverRuntimeCtx = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        serverRuntimeCtx.setJ2EEVersion(j2eeLevel);
        serverRuntimeCtx.setRuntimeId(wsRuntimeId);
        serverRuntimeCtx.setServerFactoryId(serverTypeId);
    }

    private static Status launchWizard(String pluginNS, String wizardId, String objectClassId, IStructuredSelection initialSelection) throws Exception {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.popupMenus").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespace().equals(pluginNS)) {
                // empty if block
            }
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getAttribute("id").equals(wizardId) && configElements[j].getAttribute("objectClass").equals(objectClassId)) {
                    IConfigurationElement actionElement = configElements[j].getChildren()[0];
                    AccumulateStatusHandler statusHandler = new AccumulateStatusHandler();
                    DynamicPopupJUnitWizard wizard = new DynamicPopupJUnitWizard(statusHandler);
                    wizard.setInitializationData(actionElement, null, null);
                    wizard.selectionChanged(null, (ISelection)initialSelection);
                    wizard.run(null);
                    return statusHandler.getStatus();
                }
                ++j;
            }
            ++i;
        }
        return new SimpleStatus("", "No wizard found for: ", 4);
    }

    public static Status launchCreationWizard(String wizardId, String objectClassId, IStructuredSelection initialSelection) throws Exception {
        return JUnitUtils.launchWizard("org.eclipse.jst.ws.creation.ui", wizardId, objectClassId, initialSelection);
    }

    public static Status launchConsumptionWizard(String wizardId, String objectClassId, IStructuredSelection initialSelection) throws Exception {
        return JUnitUtils.launchWizard("org.eclipse.jst.ws.internal.consumption.ui", wizardId, objectClassId, initialSelection);
    }

    public static Status createWebModule(String webProjectName, String moduleName, String serverFactoryId, String j2eeVersion, Environment env) {
        SimpleStatus status = new SimpleStatus("");
        try {
            CreateModuleCommand createWeb = new CreateModuleCommand();
            createWeb.setProjectName(webProjectName);
            createWeb.setModuleName(moduleName);
            createWeb.setModuleType(1);
            createWeb.setJ2eeLevel(j2eeVersion);
            createWeb.setServerFactoryId(serverFactoryId);
            return createWeb.execute(env);
        }
        catch (Exception e) {
            status = new SimpleStatus("", e.getMessage(), 4, (Throwable)e);
            return status;
        }
    }

    public static IFolder getSourceFolderForWebProject(String projectName) {
        IProject project = ProjectUtilities.getProject((String)projectName);
        IFolder srcFolder = project.getFolder(WebNatureRuntimeUtilities.getDefaultJavaSourceName());
        return srcFolder;
    }

    public static IFolder getWebContentFolder(String projectName) {
        IProject project = ProjectUtilities.getProject((String)projectName);
        IFolder webContentFolder = project.getFolder(WebNatureRuntimeUtilities.getDefaultJ2EEWebContentPath());
        return webContentFolder;
    }

    public static IFolder getWebInfFolderForWebProject(String projectName) {
        IProject project = ProjectUtilities.getProject((String)projectName);
        return project.getFolder(WebNatureRuntimeUtilities.getDefaultWEBINFPath());
    }

    public static IFolder getClassesFolderForWebProject(String projectName) {
        IProject project = ProjectUtilities.getProject((String)projectName);
        return project.getFolder(WebNatureRuntimeUtilities.getDefaultWebOutputFolderPath());
    }
}

