/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.wst.xsd.ui.internal.widgets.SetBaseTypeDialog;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetBaseTypeAction
extends Action {
    XSDSchema xsdSchema;
    Element element;
    String type = "";
    String derivedByString = "";
    XSDDOMHelper domHelper = new XSDDOMHelper();
    XSDTypeDefinition newTypeDefinition = null;

    public SetBaseTypeAction() {
    }

    public SetBaseTypeAction(String arg0) {
        super(arg0);
    }

    public SetBaseTypeAction(String arg0, ImageDescriptor arg1) {
        super(arg0, arg1);
    }

    public SetBaseTypeAction(String arg0, int arg1) {
        super(arg0, arg1);
    }

    public void setXSDSchema(XSDSchema schema) {
        this.xsdSchema = schema;
    }

    public void setComplexTypeElement(Element element) {
        this.element = element;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDerivedBy(String derivedByString) {
        this.derivedByString = derivedByString;
    }

    public void run() {
        int result;
        Display display = Display.getCurrent();
        display = display == null ? Display.getDefault() : display;
        Shell parentShell = display.getActiveShell();
        SetBaseTypeDialog dialog = new SetBaseTypeDialog(parentShell, this.xsdSchema, this.element);
        dialog.setBlockOnOpen(true);
        Element contentModelElement = this.domHelper.getContentModelFromParent(this.element);
        if (contentModelElement != null && (XSDDOMHelper.inputEquals(contentModelElement, "complexContent", false) || XSDDOMHelper.inputEquals(contentModelElement, "simpleContent", false))) {
            Element derivedByElement = this.domHelper.getDerivedByElementFromComplexType(this.element);
            if (derivedByElement != null) {
                String currentBaseType = derivedByElement.getAttribute("base");
                dialog.setCurrentBaseType(currentBaseType);
                dialog.setCurrentDerivedBy(derivedByElement.getLocalName());
            } else {
                dialog.setCurrentBaseType("");
                dialog.setCurrentDerivedBy("");
            }
        }
        if ((result = dialog.open()) == 0) {
            this.type = dialog.getBaseType();
            this.derivedByString = dialog.getDerivedBy();
            this.performAction();
        }
    }

    public XSDTypeDefinition getXSDTypeDefinition() {
        return this.newTypeDefinition;
    }

    public void performAction() {
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        XSDConcreteComponent xsdComp = this.xsdSchema.getCorrespondingComponent((Node)this.element);
        Element contentModelElement = this.domHelper.getContentModelFromParent(this.element);
        boolean contentModelExists = true;
        if (contentModelElement == null) {
            contentModelExists = false;
        }
        this.newTypeDefinition = null;
        Iterator i = this.xsdSchema.getTypeDefinitions().iterator();
        while (i.hasNext()) {
            XSDTypeDefinition typeDef = (XSDTypeDefinition)i.next();
            if (!typeDef.getQName().equals(this.type)) continue;
            this.newTypeDefinition = typeDef;
            break;
        }
        boolean needsComplexContent = false;
        boolean needsSimpleContent = false;
        if (helper.getBuiltInTypeNamesList().contains(this.type) || helper.getUserSimpleTypeNamesList().contains(this.type)) {
            needsSimpleContent = true;
        } else if (this.newTypeDefinition instanceof XSDComplexTypeDefinition) {
            needsComplexContent = true;
        }
        this.beginRecording(XSDEditorPlugin.getXSDString("_UI_LABEL_SET_BASE_TYPE"), this.element);
        String prefix = this.element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        DOMAttribute attr = new DOMAttribute("base", this.type);
        this.domHelper.hasElementChildren(this.element);
        if (!contentModelExists) {
            if (helper.getBuiltInTypeNamesList().contains(this.type) || helper.getUserSimpleTypeNamesList().contains(this.type)) {
                this.updateModelAndDerivedByKind(String.valueOf(prefix) + "simpleContent", String.valueOf(prefix) + "extension", attr);
            } else if (helper.getUserComplexTypeNamesList().contains(this.type)) {
                if (this.derivedByString.equals("")) {
                    this.derivedByString = "extension";
                }
                Element derivedByElement = this.updateModelAndDerivedByKind(String.valueOf(prefix) + "complexContent", String.valueOf(prefix) + this.derivedByString, attr);
                Element newModelGroupElement = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "sequence");
                derivedByElement.appendChild(newModelGroupElement);
                this.formatChild(derivedByElement);
            }
        } else if (this.type.equals("")) {
            Element derivedByElement = this.domHelper.getDerivedByElementFromComplexType(this.element);
            Element sourceContentModelElement = this.domHelper.getContentModelFromParent(derivedByElement);
            if (XSDDOMHelper.inputEquals(sourceContentModelElement, "sequence", false) || XSDDOMHelper.inputEquals(sourceContentModelElement, "choice", false) || XSDDOMHelper.inputEquals(sourceContentModelElement, "all", false)) {
                Element newNode = this.domHelper.cloneElement(this.element, sourceContentModelElement);
                this.element.replaceChild(newNode, contentModelElement);
                this.formatChild(this.element);
            } else {
                XSDDOMHelper.removeNodeAndWhitespace(contentModelElement);
                Element newSequenceElement = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + "sequence");
                this.element.appendChild(newSequenceElement);
                this.formatChild(newSequenceElement);
            }
        } else {
            Element derivedByElement;
            Element sequenceChoiceOrAllElement = null;
            if (XSDDOMHelper.inputEquals(contentModelElement, "sequence", false) || XSDDOMHelper.inputEquals(contentModelElement, "choice", false) || XSDDOMHelper.inputEquals(contentModelElement, "all", false)) {
                sequenceChoiceOrAllElement = this.domHelper.cloneElement(this.element, contentModelElement);
            }
            if (needsComplexContent && !XSDDOMHelper.inputEquals(contentModelElement, "complexContent", false)) {
                this.domHelper.changeContentModel(this.element, "complexContent", sequenceChoiceOrAllElement);
                contentModelElement = this.domHelper.getContentModelFromParent(this.element);
            }
            if (needsSimpleContent && !XSDDOMHelper.inputEquals(contentModelElement, "simpleContent", false)) {
                sequenceChoiceOrAllElement = null;
                this.domHelper.changeContentModel(this.element, "simpleContent", sequenceChoiceOrAllElement);
                contentModelElement = this.domHelper.getContentModelFromParent(this.element);
            }
            if ((derivedByElement = this.domHelper.getDerivedByElementFromComplexType(this.element)) == null) {
                if (this.derivedByString == null || this.derivedByString != null && this.derivedByString.equals("")) {
                    this.derivedByString = "extension";
                }
                derivedByElement = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", this.derivedByString);
                contentModelElement.appendChild(derivedByElement);
                this.formatChild(contentModelElement);
                if (sequenceChoiceOrAllElement != null) {
                    derivedByElement.appendChild(sequenceChoiceOrAllElement);
                    this.formatChild(derivedByElement);
                }
            } else {
                if (helper.getBuiltInTypeNamesList().contains(this.type) || helper.getUserSimpleTypeNamesList().contains(this.type)) {
                    this.derivedByString = "extension";
                    Element aContentModelElement = this.domHelper.getContentModelFromParent(derivedByElement);
                    if (aContentModelElement != null) {
                        XSDDOMHelper.removeNodeAndWhitespace(aContentModelElement);
                    }
                }
                this.domHelper.changeDerivedByType(contentModelElement, this.derivedByString, this.type);
            }
            derivedByElement.setAttribute(attr.getName(), attr.getValue());
        }
        xsdComp.setElement(this.element);
        this.endRecording(this.element);
    }

    private Element updateModelAndDerivedByKind(String modelType, String derivedByKind, DOMAttribute attr) {
        Element newContentModelElement = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", modelType);
        this.element.appendChild(newContentModelElement);
        Element newDerivedByElement = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", derivedByKind);
        newContentModelElement.appendChild(newDerivedByElement);
        newDerivedByElement.setAttribute(attr.getName(), attr.getValue());
        NodeList children = this.element.getChildNodes();
        int length = children.getLength();
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        int i = 0;
        while (i < length) {
            Node node = children.item(i);
            if (XSDDOMHelper.inputEquals(node, "attribute", false) || XSDDOMHelper.inputEquals(node, "attribute", true) || XSDDOMHelper.inputEquals(node, "attributeGroup", true) || XSDDOMHelper.inputEquals(node, "anyAttribute", false)) {
                newDerivedByElement.appendChild(node.cloneNode(true));
                nodesToRemove.add(node);
            }
            ++i;
        }
        Iterator i2 = nodesToRemove.iterator();
        while (i2.hasNext()) {
            XSDDOMHelper.removeNodeAndWhitespace((Node)i2.next());
        }
        this.formatChild(newContentModelElement);
        return newDerivedByElement;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void formatChild(Element child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)child);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.changedModel();
    }

    public DocumentImpl getDocument(Element element) {
        return (DocumentImpl)element.getOwnerDocument();
    }

    public void beginRecording(String description, Element element) {
        this.getDocument(element).getModel().beginRecording((Object)this, description);
    }

    public void endRecording(Element element) {
        DocumentImpl doc = this.getDocument(element);
        doc.getModel().endRecording((Object)this);
    }
}

