/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.gef.util.editparts.AbstractComponentViewerRootEditPart;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.FillLayout;
import org.eclipse.wst.xsd.ui.internal.graph.GraphicsConstants;
import org.eclipse.wst.xsd.ui.internal.graph.XSDComponentViewer;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphUtil;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.CategoryEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.IFeedbackHandler;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComponentNameDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SimpleDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.model.ModelAdapter;
import org.eclipse.wst.xsd.ui.internal.graph.model.XSDModelAdapterFactory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;

public class TopLevelComponentEditPart
extends BaseEditPart
implements IFeedbackHandler {
    protected Label label;
    protected ContainerFigure labelHolder = new ContainerFigure();
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;
    protected SimpleDirectEditPolicy simpleDirectEditPolicy = new SimpleDirectEditPolicy();
    protected boolean isReadOnly;
    protected boolean isSelected;
    protected Font font;
    private boolean doScroll = false;
    static boolean reselect = false;

    protected IFigure createFigure() {
        ContainerFigure typeGroup = new ContainerFigure();
        typeGroup.getContainerLayout().setHorizontal(true);
        this.labelHolder = new ContainerFigure();
        FillLayout fillLayout = new FillLayout();
        this.labelHolder.setLayoutManager((LayoutManager)fillLayout);
        this.labelHolder.setFill(true);
        typeGroup.add((IFigure)this.labelHolder);
        this.label = new Label();
        this.label.setBorder((Border)new MarginBorder(0, 2, 2, 1));
        this.label.setForegroundColor(ColorConstants.black);
        this.labelHolder.add((IFigure)this.label);
        try {
            Object model = this.getModel();
            boolean isLinux = File.separator.equals("/");
            if ((model instanceof XSDComplexTypeDefinition || model instanceof XSDElementDeclaration || model instanceof XSDModelGroupDefinition) && !isLinux) {
                FontData oldData = GraphicsConstants.medium.getFontData()[0];
                FontData fontData = new FontData(oldData.getName(), oldData.getHeight(), 0);
                Object data = fontData.getClass().getField("data").get(fontData);
                data.getClass().getField("lfUnderline").setByte(data, (byte)1);
                this.font = new Font((Device)Display.getCurrent(), fontData);
                this.label.setFont(this.font);
            }
        }
        catch (Exception exception) {}
        return typeGroup;
    }

    public void deactivate() {
        super.deactivate();
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
    }

    public void refreshVisuals() {
        ModelAdapter adapter = XSDModelAdapterFactory.getAdapter(this.getModel());
        if (adapter != null) {
            this.isReadOnly = !XSDGraphUtil.isEditable(this.getModel());
            this.label.setForegroundColor(this.computeLabelColor());
            this.label.setText((String)adapter.getProperty(this.getModel(), "LABEL_PROPERTY"));
            Image image = (Image)adapter.getProperty(this.getModel(), "IMAGE_PROPERTY");
            if (image != null) {
                this.label.setIcon(image);
            }
        } else {
            this.label.setText(String.valueOf(XSDEditorPlugin.getXSDString("_UI_GRAPH_UNKNOWN_OBJECT")) + this.getModel().getClass().getName());
        }
        if (reselect) {
            this.getViewer().select((EditPart)this);
            this.setReselect(false);
        }
    }

    public XSDNamedComponent getXSDNamedComponent() {
        return (XSDNamedComponent)this.getModel();
    }

    public List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    protected void createEditPolicies() {
        SelectionHandlesEditPolicyImpl policy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
        SelectionEditPolicy feedBackSelectionEditPolicy = new SelectionEditPolicy(){

            protected void hideSelection() {
                EditPart editPart = this.getHost();
                if (editPart instanceof IFeedbackHandler) {
                    ((IFeedbackHandler)editPart).removeFeedback();
                }
            }

            protected void showSelection() {
                EditPart editPart = this.getHost();
                if (editPart instanceof IFeedbackHandler) {
                    ((IFeedbackHandler)editPart).addFeedback();
                }
            }
        };
        this.installEditPolicy("Selection Feedback", (EditPolicy)feedBackSelectionEditPolicy);
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.simpleDirectEditPolicy);
    }

    public Color computeLabelColor() {
        Color color = ColorConstants.black;
        if (this.isSelected) {
            color = ColorConstants.white;
        } else if (this.isReadOnly) {
            color = ColorConstants.gray;
        }
        return color;
    }

    public void addFeedback() {
        this.isSelected = true;
        this.labelHolder.setBackgroundColor(ColorConstants.black);
        this.label.setForegroundColor(this.computeLabelColor());
        this.labelHolder.setFill(true);
        if (this.doScroll) {
            CategoryEditPart categoryEP = (CategoryEditPart)this.getParent();
            categoryEP.scrollTo(this);
            this.setScroll(false);
        }
    }

    public void setScroll(boolean doScroll) {
        this.doScroll = doScroll;
    }

    public void removeFeedback() {
        this.isSelected = false;
        this.labelHolder.setBackgroundColor(null);
        this.label.setForegroundColor(this.computeLabelColor());
        this.labelHolder.setFill(false);
    }

    public void performRequest(Request request) {
        LocationRequest locationRequest;
        Point p;
        Object model;
        if ((request.getType() == "direct edit" || request.getType() == "open") && ((model = this.getModel()) instanceof XSDComplexTypeDefinition || model instanceof XSDElementDeclaration || model instanceof XSDModelGroupDefinition) && request instanceof LocationRequest && this.hitTest((IFigure)this.labelHolder, p = (locationRequest = (LocationRequest)request).getLocation())) {
            this.performDrillDownAction();
        }
    }

    public boolean hitTest(IFigure target, Point location) {
        Rectangle b = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)b);
        return b.contains(location);
    }

    protected void performDrillDownAction() {
        Runnable runnable = new Runnable(){

            public void run() {
                EditPart editPart = ((AbstractEditPartViewer)TopLevelComponentEditPart.this.getViewer()).getRootEditPart().getContents();
                if (editPart instanceof AbstractComponentViewerRootEditPart) {
                    AbstractComponentViewerRootEditPart rootEditPart = (AbstractComponentViewerRootEditPart)editPart;
                    rootEditPart.setInput((XSDConcreteComponent)TopLevelComponentEditPart.this.getModel());
                } else if (editPart instanceof BaseEditPart) {
                    ((XSDComponentViewer)TopLevelComponentEditPart.this.getViewer()).setInput((XSDConcreteComponent)TopLevelComponentEditPart.this.getModel());
                }
            }
        };
        Display.getCurrent().asyncExec(runnable);
    }

    public void doEditName() {
        this.removeFeedback();
        Object object = this.getModel();
        if (object instanceof XSDNamedComponent) {
            ComponentNameDirectEditManager manager = new ComponentNameDirectEditManager((GraphicalEditPart)this, this.label, (XSDNamedComponent)object);
            this.simpleDirectEditPolicy.setDelegate(manager);
            manager.show();
        }
    }

    public void setReselect(boolean state) {
        reselect = state;
    }
}

