/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.ComboBoxCellEditorManager;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class TypeReferenceDirectEditManager
extends ComboBoxCellEditorManager {
    protected BaseEditPart editPart;
    protected XSDElementDeclaration ed;

    public TypeReferenceDirectEditManager(BaseEditPart source, XSDElementDeclaration ed, Label label) {
        super((GraphicalEditPart)source, label);
        this.editPart = source;
        this.ed = ed;
    }

    protected List computeComboContent() {
        XSDSchema schema = this.ed.getSchema();
        ArrayList typeNameList = new ArrayList();
        if (schema != null) {
            TypesHelper typesHelper = new TypesHelper(schema);
            typeNameList.addAll(typesHelper.getUserSimpleTypeNamesList());
            typeNameList.addAll(typesHelper.getUserComplexTypeNamesList());
            typeNameList.addAll(typesHelper.getBuiltInTypeNamesList());
        }
        return typeNameList;
    }

    public void performModify(String value) {
        DelayedRenameRunnable runnable = new DelayedRenameRunnable(this.editPart, this.ed, value);
        Display.getCurrent().asyncExec((Runnable)runnable);
    }

    protected List computeSortedList(List list) {
        return TypesHelper.sortList(list);
    }

    protected static class DelayedRenameRunnable
    implements Runnable {
        protected BaseEditPart editPart;
        protected EditPart editPartParent;
        protected XSDElementDeclaration ed;
        protected String name;

        public DelayedRenameRunnable(BaseEditPart editPart, XSDElementDeclaration ed, String name) {
            this.editPart = editPart;
            this.editPartParent = editPart.getParent();
            this.ed = ed;
            this.name = name;
        }

        public void run() {
            if (this.name.equals("<anonymous>")) {
                try {
                    this.ed.getResolvedElementDeclaration().getElement().removeAttribute("type");
                }
                catch (Exception exception) {}
            } else {
                if (this.ed.getResolvedElementDeclaration().getAnonymousTypeDefinition() != null && !this.name.equals("<anonymous>")) {
                    this.ed.getResolvedElementDeclaration().getElement().setAttribute("type", this.name);
                    XSDDOMHelper.updateElementToNotAnonymous(this.ed.getResolvedElementDeclaration().getElement());
                    return;
                }
                this.ed.getResolvedElementDeclaration().getElement().setAttribute("type", this.name);
            }
        }
    }
}

