/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.XSDEditNamespacesAction;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.TargetNamespaceChangeHandler;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceSection
extends AbstractSection {
    IWorkbenchPart part;
    Text prefixText;
    Text targetNamespaceText;
    Button editButton;
    StyledText errorText;
    Color red;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_PREFIX"));
        int leftCoordinate = this.getStandardLabelWidth(composite, new String[]{XSDEditorPlugin.getXSDString("_UI_LABEL_TARGET_NAME_SPACE"), XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_PREFIX")});
        this.prefixText = this.getWidgetFactory().createText(composite, "", 0);
        FormData prefixTextData = new FormData();
        prefixTextData.left = new FormAttachment(0, leftCoordinate);
        prefixTextData.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        this.prefixText.setLayoutData((Object)prefixTextData);
        this.prefixText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.prefixText, -5);
        data.top = new FormAttachment((Control)this.prefixText, 0, 0x1000000);
        prefixLabel.setLayoutData((Object)data);
        CLabel targetNamespaceLabel = this.getWidgetFactory().createCLabel(composite, XSDEditorPlugin.getXSDString("_UI_LABEL_TARGET_NAME_SPACE"));
        this.targetNamespaceText = this.getWidgetFactory().createText(composite, "", 0);
        FormData tnsLabelData = new FormData();
        tnsLabelData.left = new FormAttachment(0, 0);
        tnsLabelData.right = new FormAttachment((Control)this.targetNamespaceText, -5);
        tnsLabelData.top = new FormAttachment((Control)this.targetNamespaceText, 0, 0x1000000);
        targetNamespaceLabel.setLayoutData((Object)tnsLabelData);
        FormData tnsTextData = new FormData();
        tnsTextData.left = new FormAttachment(0, leftCoordinate);
        tnsTextData.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        tnsTextData.top = new FormAttachment((Control)this.prefixText, 4);
        this.targetNamespaceText.setLayoutData((Object)tnsTextData);
        this.targetNamespaceText.addListener(24, (Listener)this);
        this.editButton = this.getWidgetFactory().createButton(composite, String.valueOf(XSDEditorPlugin.getXSDString("_UI_SECTION_ADVANCED_ATTRIBUTES")) + "...", 8);
        FormData buttonFormData = new FormData();
        buttonFormData.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        buttonFormData.top = new FormAttachment((Control)this.targetNamespaceText, 4);
        this.editButton.setLayoutData((Object)buttonFormData);
        this.editButton.addSelectionListener((SelectionListener)this);
        this.errorText = new StyledText(composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new FormData();
        data.left = new FormAttachment((Control)this.targetNamespaceText, 0, 16384);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.editButton, 0);
        this.errorText.setLayoutData((Object)data);
    }

    public void refresh() {
        if (this.doRefresh) {
            if (this.prefixText.isDisposed() || this.targetNamespaceText.isDisposed()) {
                return;
            }
            if (this.prefixText.isFocusControl() || this.targetNamespaceText.isFocusControl()) {
                return;
            }
            this.setListenerEnabled(false);
            Element element = this.xsdSchema.getElement();
            if (element != null) {
                TypesHelper helper = new TypesHelper(this.xsdSchema);
                String aPrefix = helper.getPrefix(element.getAttribute("targetNamespace"), false);
                if (aPrefix != null && aPrefix.length() > 0) {
                    this.prefixText.setText(aPrefix);
                } else {
                    this.prefixText.setText("");
                }
                String tns = element.getAttribute("targetNamespace");
                if (tns != null && tns.length() > 0) {
                    this.targetNamespaceText.setText(tns);
                } else {
                    this.targetNamespaceText.setText("");
                }
                this.errorText.setText("");
            }
            this.setListenerEnabled(true);
        }
    }

    public void doHandleEvent(Event event) {
        this.errorText.setText("");
        String prefixValue = this.prefixText.getText();
        String tnsValue = this.targetNamespaceText.getText();
        if (tnsValue.trim().length() == 0 && prefixValue.trim().length() > 0) {
            this.errorText.setText(XSDEditorPlugin.getXSDString("_ERROR_TARGET_NAMESPACE_AND_PREFIX"));
            int length = this.errorText.getText().length();
            this.red = new Color(null, 255, 0, 0);
            StyleRange style = new StyleRange(0, length, this.red, this.targetNamespaceText.getBackground());
            this.errorText.setStyleRange(style);
            return;
        }
        if (event.widget == this.prefixText) {
            this.updateNamespaceInfo(prefixValue, tnsValue);
        } else if (event.widget == this.targetNamespaceText) {
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            helper.getPrefix(this.xsdSchema.getElement().getAttribute("targetNamespace"), false);
            this.updateNamespaceInfo(prefixValue, tnsValue);
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.editButton) {
            XSDEditNamespacesAction nsAction = new XSDEditNamespacesAction(XSDEditorPlugin.getXSDString("_UI_ACTION_EDIT_NAMESPACES"), this.xsdSchema.getElement(), null, this.xsdSchema);
            nsAction.run();
            this.refresh();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void updateNamespaceInfo(String newPrefix, String newTargetNamespace) {
        Element element = this.xsdSchema.getElement();
        DocumentImpl doc = (DocumentImpl)element.getOwnerDocument();
        String modelTargetNamespace = this.xsdSchema.getTargetNamespace();
        String oldNamespace = this.xsdSchema.getTargetNamespace();
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        String oldPrefix = helper.getPrefix(element.getAttribute("targetNamespace"), false);
        if (modelTargetNamespace == null) {
            modelTargetNamespace = "";
        }
        String targetNamespace = newTargetNamespace.trim();
        String prefix = newPrefix.trim();
        if (!this.validatePrefix(prefix) || !this.validateTargetNamespace(targetNamespace)) {
            return;
        }
        if (prefix.length() > 0 && targetNamespace.length() == 0) {
            return;
        }
        doc.getModel().beginRecording((Object)this, XSDEditorPlugin.getXSDString("_UI_TARGETNAMESPACE_CHANGE"));
        String xsdForXSDPrefix = this.xsdSchema.getSchemaForSchemaQNamePrefix();
        Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
        if (prefix.length() == 0 && (xsdForXSDPrefix == null || xsdForXSDPrefix != null && xsdForXSDPrefix.trim().length() == 0)) {
            xsdForXSDPrefix = XSDEditorPlugin.getPlugin().getXMLSchemaPrefix();
            xsdForXSDPrefix = this.getUniqueSchemaForSchemaPrefix(xsdForXSDPrefix, map);
            element.setAttribute("xmlns:" + xsdForXSDPrefix, "http://www.w3.org/2001/XMLSchema");
            this.updateAllNodes(element, xsdForXSDPrefix);
            if (element.getAttribute("xmlns") != null && element.getAttribute("xmlns").equals("http://www.w3.org/2001/XMLSchema")) {
                element.removeAttribute("xmlns");
            }
        }
        if (targetNamespace.length() > 0 || targetNamespace.length() == 0 && prefix.length() == 0) {
            if (oldPrefix != null && oldPrefix.length() > 0) {
                element.removeAttribute("xmlns:" + oldPrefix);
            } else if (element.getAttribute("xmlns") != null && !element.getAttribute("xmlns").equals("http://www.w3.org/2001/XMLSchema")) {
                element.removeAttribute("xmlns");
            }
        }
        if (targetNamespace.length() > 0) {
            if (!modelTargetNamespace.equals(targetNamespace)) {
                element.setAttribute("targetNamespace", targetNamespace);
            }
            if (prefix.length() > 0) {
                element.setAttribute("xmlns:" + prefix, targetNamespace);
            } else {
                element.setAttribute("xmlns", targetNamespace);
            }
        } else if (prefix.length() == 0) {
            element.removeAttribute("targetNamespace");
        }
        TargetNamespaceChangeHandler targetNamespaceChangeHandler = new TargetNamespaceChangeHandler(this.xsdSchema, oldNamespace, targetNamespace);
        targetNamespaceChangeHandler.resolve();
        XSDSchemaHelper.updateElement((XSDConcreteComponent)this.xsdSchema);
        doc.getModel().endRecording((Object)this);
    }

    private String getUniqueSchemaForSchemaPrefix(String xsdForXSDPrefix, Map map) {
        if (xsdForXSDPrefix == null || xsdForXSDPrefix != null && xsdForXSDPrefix.trim().length() == 0) {
            xsdForXSDPrefix = "xsd";
        }
        int prefixExtension = 1;
        while (map.containsKey(xsdForXSDPrefix) && prefixExtension < 100) {
            xsdForXSDPrefix = String.valueOf(xsdForXSDPrefix) + String.valueOf(prefixExtension);
            ++prefixExtension;
        }
        return xsdForXSDPrefix;
    }

    private void updateAllNodes(Element element, String prefix) {
        element.setPrefix(prefix);
        NodeList list = element.getChildNodes();
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child != null && child instanceof Element) {
                    child.setPrefix(prefix);
                    if (child.hasChildNodes()) {
                        this.updateAllNodes((Element)child, prefix);
                    }
                }
                ++i;
            }
        }
    }

    private boolean validateTargetNamespace(String ns) {
        if (ns.equals("")) {
            return true;
        }
        String errorMessage = null;
        try {
            new URI(ns);
        }
        catch (URISyntaxException uRISyntaxException) {
            errorMessage = XSDEditorPlugin.getXSDString("_WARN_INVALID_TARGET_NAMESPACE");
        }
        return errorMessage == null || errorMessage.length() == 0;
    }

    public void dispose() {
        super.dispose();
        if (this.red != null) {
            this.red.dispose();
            this.red = null;
        }
    }
}

