/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.provider;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAbstractAdapter;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.w3c.dom.Element;

public class XSDModelGroupAdapter
extends XSDAbstractAdapter {
    public XSDModelGroupAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Image getImage(Object element) {
        XSDModelGroup xsdModelGroup = (XSDModelGroup)element;
        if (XSDCompositor.CHOICE_LITERAL == xsdModelGroup.getCompositor()) {
            return XSDEditorPlugin.getXSDImage("icons/XSDChoice.gif");
        }
        if (XSDCompositor.ALL_LITERAL == xsdModelGroup.getCompositor()) {
            return XSDEditorPlugin.getXSDImage("icons/XSDAll.gif");
        }
        return XSDEditorPlugin.getXSDImage("icons/XSDSequence.gif");
    }

    public String getText(Object object) {
        Element element;
        XSDModelGroup xsdModelGroup = (XSDModelGroup)object;
        StringBuffer result = new StringBuffer();
        String name = xsdModelGroup.getCompositor().getName();
        if (name != null) {
            result.append(name);
        }
        if ((element = xsdModelGroup.getElement()) != null) {
            boolean hasMinOccurs = element.hasAttribute("minOccurs");
            boolean hasMaxOccurs = element.hasAttribute("maxOccurs");
            if (hasMinOccurs || hasMaxOccurs) {
                int max;
                int min;
                XSDConcreteComponent comp = xsdModelGroup.getContainer();
                boolean isParticle = comp instanceof XSDParticle;
                if (isParticle) {
                    result.append(" [");
                }
                if (hasMinOccurs) {
                    if (isParticle) {
                        min = ((XSDParticle)comp).getMinOccurs();
                        if (min == -1) {
                            result.append("*");
                        } else {
                            result.append(String.valueOf(min));
                        }
                    }
                } else if (isParticle) {
                    min = ((XSDParticle)comp).getMinOccurs();
                    result.append(String.valueOf(min));
                }
                if (hasMaxOccurs) {
                    if (isParticle) {
                        max = ((XSDParticle)comp).getMaxOccurs();
                        result.append("..");
                        if (max == -1) {
                            result.append("*");
                        } else {
                            result.append(String.valueOf(max));
                        }
                    }
                } else if (isParticle) {
                    result.append("..");
                    max = ((XSDParticle)comp).getMaxOccurs();
                    result.append(String.valueOf(max));
                }
                if (isParticle) {
                    result.append("]");
                }
            }
        }
        return result.toString();
    }

    public Object[] getChildren(Object parentElement) {
        XSDModelGroup xsdModelGroup = (XSDModelGroup)parentElement;
        ArrayList list = new ArrayList();
        list.addAll(XSDChildUtility.getModelChildren(xsdModelGroup));
        return list.toArray();
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public Object getParent(Object object) {
        XSDModelGroup element = (XSDModelGroup)object;
        return element.getContainer();
    }
}

