/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.BaseGlobalCleanup;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroupDefinition;

public class GlobalGroupCleanup
extends BaseGlobalCleanup {
    protected String replacementName = null;

    public GlobalGroupCleanup(XSDConcreteComponent deletedItem) {
        super(deletedItem);
    }

    protected String getReplacementElementName() {
        if (this.replacementName == null) {
            TypesHelper helper = new TypesHelper(this.schema);
            List elements = helper.getModelGroups();
            String deletedName = this.getDeletedQName();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name.equals(deletedName)) continue;
                this.replacementName = name;
                break;
            }
        }
        return this.replacementName;
    }

    public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroup) {
        super.visitModelGroupDefinition(modelGroup);
        if (modelGroup.isModelGroupDefinitionReference() && this.deletedItem.equals(modelGroup.getResolvedModelGroupDefinition())) {
            if (this.getReplacementElementName() != null) {
                String msg = "_INFO_RESET_GROUP_REFERENCE <" + this.getReplacementElementName() + ">";
                this.addMessage(msg, (XSDConcreteComponent)modelGroup);
                modelGroup.getElement().setAttribute("ref", this.getReplacementElementName());
            } else {
                String name = this.getNamedComponentName((XSDConcreteComponent)modelGroup);
                String msg = "_INFO_REMOVE_GROUP_REFERENCE <" + name + ">";
                this.addMessage(msg, modelGroup.getContainer());
                this.childrenToRemove.add(modelGroup.getElement());
            }
        }
    }
}

