/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.ComponentRenameChange;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.INameUpdating;
import org.eclipse.xsd.XSDNamedComponent;

public class RenameComponentProcessor
extends RenameProcessor
implements INameUpdating {
    private XSDNamedComponent fNamedComponent;
    private String fNewElementName;
    public static final String IDENTIFIER = "org.eclipse.wst.ui.xsd.renameComponentProcessor";

    public RenameComponentProcessor(XSDNamedComponent element, String newName) {
        this.fNamedComponent = element;
        this.fNewElementName = newName;
    }

    public XSDNamedComponent getNamedComponent() {
        return this.fNamedComponent;
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public String getCurrentElementName() {
        return this.fNamedComponent.getName();
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[0];
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ComponentRenameChange componentRenameChange;
        pm.beginTask("", 1);
        try {
            componentRenameChange = new ComponentRenameChange(this.fNamedComponent, this.fNamedComponent.getName(), this.getNewElementName());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return componentRenameChange;
    }

    public Object[] getElements() {
        return new Object[]{this.fNamedComponent};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringMessages.getFormattedString("RenameComponentRefactoring.name", new String[]{String.valueOf(this.fNamedComponent.getTargetNamespace()) + ":" + this.fNamedComponent.getName(), this.getNewElementName()});
    }

    public boolean isApplicable() throws CoreException {
        return this.fNamedComponent != null;
    }

    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        return new RefactoringStatus();
    }

    public Object getNewElement() throws CoreException {
        return null;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), true);
        String[] natures = this.getAffectedProjectNatures();
        ArrayList result = new ArrayList();
        this.loadElementParticipants(status, result, arguments, natures, sharedParticipants);
        this.loadDerivedParticipants(status, result, natures, sharedParticipants);
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    protected void loadElementParticipants(RefactoringStatus status, List result, RenameArguments arguments, String[] natures, SharableParticipants shared) throws CoreException {
        Object[] elements = this.getElements();
        int i = 0;
        while (i < elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
    }

    public void setNewElementName(String newName) {
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }
}

