/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;

public class ServerRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private MessageUtils msgUtils_;
    private String INFOPOP_SRPF_SERVER_PREF = String.valueOf(this.pluginId_) + ".SRPF0001";
    private Combo server_;
    private String INFOPOP_SRPF_RUNTIME_PREF = String.valueOf(this.pluginId_) + ".SRPF0002";
    private Combo runtime_;
    private String INFOPOP_SRPF_J2EE_PREF = String.valueOf(this.pluginId_) + ".SRPF0003";
    private Combo j2eeVersion_;
    SelectionListChoices serverToRuntimeToJ2EE_;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.msgUtils_ = new MessageUtils(String.valueOf(this.pluginId_) + ".plugin", (Object)this);
        UIUtils uiUtils = new UIUtils(this.msgUtils_, this.pluginId_);
        Composite page = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        page.setLayout((Layout)gl);
        GridData gd = new GridData(272);
        page.setLayoutData((Object)gd);
        this.server_ = uiUtils.createCombo(page, "LABEL_SERVERS_LIST", "TOOLTIP_SRPF_COMBO_SERVER", this.INFOPOP_SRPF_SERVER_PREF, 2060);
        this.runtime_ = uiUtils.createCombo(page, "LABEL_RUNTIMES_LIST", "TOOLTIP_SRPF_COMBO_RUNTIME", this.INFOPOP_SRPF_RUNTIME_PREF, 2060);
        this.j2eeVersion_ = uiUtils.createCombo(page, "LABEL_J2EE_VERSION", "TOOLTIP_SRPF_COMBO_J2EE", this.INFOPOP_SRPF_J2EE_PREF, 2060);
        this.initializeValues();
        this.startListening();
        return page;
    }

    private void initializeValues() {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        this.serverToRuntimeToJ2EE_ = WebServiceRuntimeExtensionUtils.getServerToRuntimeToJ2EE();
        this.setServerItems(this.serverToRuntimeToJ2EE_.getList().getList());
        String defaultServerText = context.getServerFactoryId();
        this.serverToRuntimeToJ2EE_.getList().setSelectionValue(defaultServerText);
        this.setServerSelection(defaultServerText);
        this.setRuntimeItems(this.serverToRuntimeToJ2EE_.getChoice().getList().getList());
        String defaultRuntimeText = context.getRuntimeId();
        this.serverToRuntimeToJ2EE_.getChoice().getList().setSelectionValue(defaultRuntimeText);
        this.setRuntimeSelection(defaultRuntimeText);
        this.setJ2EEItems(this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getList());
        String defaultJ2EEVersion = context.getJ2EEVersion();
        this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().setSelectionValue(defaultJ2EEVersion);
        this.setJ2EESelection(defaultJ2EEVersion);
    }

    public void handleEvent(Event event) {
        if (this.server_ == event.widget) {
            this.handleServerSelected();
        } else if (this.runtime_ == event.widget) {
            this.handleRuntimeSelected();
        } else if (this.j2eeVersion_ == event.widget) {
            this.handleJ2EESelected();
        }
    }

    private void handleServerSelected() {
        String newRuntimeText;
        this.stopListening();
        String selectedText = this.getServerSelection();
        this.serverToRuntimeToJ2EE_.getList().setSelectionValue(selectedText);
        this.setRuntimeItems(this.serverToRuntimeToJ2EE_.getChoice().getList().getList());
        if (this.serverToRuntimeToJ2EE_.getChoice().getList().getList().length > 0) {
            this.serverToRuntimeToJ2EE_.getChoice().getList().setIndex(0);
        }
        if ((newRuntimeText = this.serverToRuntimeToJ2EE_.getChoice().getList().getSelection()) != null && newRuntimeText.length() > 0) {
            this.setRuntimeSelection(newRuntimeText);
        }
        if (newRuntimeText != null && newRuntimeText.length() > 0) {
            String newJ2EEText;
            this.setJ2EEItems(this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getList());
            if (this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getList().length > 0) {
                this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().setIndex(0);
            }
            if ((newJ2EEText = this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getSelection()) != null && newJ2EEText.length() > 0) {
                this.setJ2EESelection(newJ2EEText);
            }
        } else {
            this.setJ2EEItems(new String[0]);
        }
        this.startListening();
    }

    private void handleRuntimeSelected() {
        String newJ2EEText;
        this.stopListening();
        String selectedText = this.getRuntimeSelection();
        this.serverToRuntimeToJ2EE_.getChoice().getList().setSelectionValue(selectedText);
        this.setJ2EEItems(this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getList());
        if (this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getList().length > 0) {
            this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().setIndex(0);
        }
        if ((newJ2EEText = this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getSelection()) != null && newJ2EEText.length() > 0) {
            this.setJ2EESelection(newJ2EEText);
        }
        this.startListening();
    }

    private void handleJ2EESelected() {
        this.stopListening();
        String selectedText = this.getJ2EESelection();
        this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().setSelectionValue(selectedText);
        this.startListening();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setToDefaults();
    }

    private void setToDefaults() {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String defaultServerText = context.getDefaultServerFactoryId();
        this.serverToRuntimeToJ2EE_.getList().setSelectionValue(defaultServerText);
        this.setServerSelection(defaultServerText);
        this.setRuntimeItems(this.serverToRuntimeToJ2EE_.getChoice().getList().getList());
        String defaultRuntimeText = context.getDefaultRuntimeId();
        this.serverToRuntimeToJ2EE_.getChoice().getList().setSelectionValue(defaultRuntimeText);
        this.setRuntimeSelection(defaultRuntimeText);
        this.setJ2EEItems(this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().getList());
        String defaultJ2EEVersion = context.getDefaultJ2EEVersion();
        this.serverToRuntimeToJ2EE_.getChoice().getChoice().getList().setSelectionValue(defaultJ2EEVersion);
        this.setJ2EESelection(defaultJ2EEVersion);
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    private void storeValues() {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        context.setServerFactoryId(this.getServerSelection());
        context.setRuntimeId(this.getRuntimeSelection());
        context.setJ2EEVersion(this.getJ2EESelection());
    }

    protected void performApply() {
        this.performOk();
    }

    private void startListening() {
        this.server_.addListener(13, (Listener)this);
        this.runtime_.addListener(13, (Listener)this);
        this.j2eeVersion_.addListener(13, (Listener)this);
    }

    private void stopListening() {
        this.server_.removeListener(13, (Listener)this);
        this.runtime_.removeListener(13, (Listener)this);
        this.j2eeVersion_.removeListener(13, (Listener)this);
    }

    private void setServerItems(String[] factoryIds) {
        if (factoryIds != null) {
            ArrayList<String> serverLabelsList = new ArrayList<String>();
            int i = 0;
            while (i < factoryIds.length) {
                String cfr_ignored_0 = factoryIds[i];
                String thisServerLabel = WebServiceRuntimeExtensionUtils.getServerLabelById(factoryIds[i]);
                if (thisServerLabel != null && thisServerLabel.length() > 0) {
                    serverLabelsList.add(thisServerLabel);
                }
                ++i;
            }
            String[] serverLabels = this.convertToStringArray(serverLabelsList.toArray());
            this.server_.setItems(serverLabels);
        }
    }

    private void setRuntimeItems(String[] ids) {
        if (ids != null) {
            String[] runtimeLabels = new String[ids.length];
            int i = 0;
            while (i < ids.length) {
                runtimeLabels[i] = WebServiceRuntimeExtensionUtils.getRuntimeLabelById(ids[i]);
                ++i;
            }
            this.runtime_.setItems(runtimeLabels);
        }
    }

    private void setJ2EEItems(String[] versions) {
        if (versions != null) {
            String[] j2eeLabels = new String[versions.length];
            int i = 0;
            while (i < versions.length) {
                String label = J2EEUtils.getLabelFromJ2EEVersion((String)versions[i]);
                j2eeLabels[i] = label != null && label.length() > 0 ? label : this.msgUtils_.getMessage("LABEL_NA");
                ++i;
            }
            this.j2eeVersion_.setItems(j2eeLabels);
            if (j2eeLabels.length > 0) {
                this.j2eeVersion_.setEnabled(true);
            } else {
                this.j2eeVersion_.setEnabled(false);
            }
        }
    }

    private String getServerSelection() {
        String serverLabel = this.server_.getText();
        return WebServiceRuntimeExtensionUtils.getServerFactoryId(serverLabel);
    }

    private String getRuntimeSelection() {
        String runtimeLabel = this.runtime_.getText();
        return WebServiceRuntimeExtensionUtils.getRuntimeId(runtimeLabel);
    }

    private String getJ2EESelection() {
        String j2eeLabel = this.j2eeVersion_.getText();
        return J2EEUtils.getJ2EEVersionFromLabel((String)j2eeLabel);
    }

    private void setServerSelection(String factoryId) {
        String label = WebServiceRuntimeExtensionUtils.getServerLabelById(factoryId);
        this.setSelection(this.server_, label);
    }

    private void setRuntimeSelection(String id) {
        String label = WebServiceRuntimeExtensionUtils.getRuntimeLabelById(id);
        this.setSelection(this.runtime_, label);
    }

    private void setJ2EESelection(String version) {
        String label = J2EEUtils.getLabelFromJ2EEVersion((String)version);
        this.setSelection(this.j2eeVersion_, label);
    }

    private void setSelection(Combo combo, String s) {
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(s)) {
                combo.select(i);
                return;
            }
            ++i;
        }
    }

    private String[] convertToStringArray(Object[] a) {
        if (a == null) {
            return new String[0];
        }
        int length = a.length;
        String[] sa = new String[length];
        int i = 0;
        while (i < length) {
            Object obj = a[i];
            if (obj instanceof String) {
                sa[i] = (String)obj;
            }
            ++i;
        }
        return sa;
    }
}

