/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.fragments.ServicePreAssemblyFragment;
import org.eclipse.jst.ws.internal.consumption.fragments.ServicePreDeployFragment;
import org.eclipse.jst.ws.internal.consumption.fragments.ServicePreDevelopFragment;
import org.eclipse.jst.ws.internal.consumption.fragments.ServicePreInstallFragment;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.IWebServiceRuntime;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.IWebServiceServer;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.IWebServiceType;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.TypeSelectionFilter;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceClientTypeRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceRuntime;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceServer;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceServerRuntimeType;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.WebServiceTypeImpl;
import org.eclipse.jst.ws.internal.data.LabelsAndIds;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactoryFactory;
import org.eclipse.wst.command.internal.env.core.registry.CommandRegistry;
import org.eclipse.wst.command.internal.env.eclipse.EclipseLog;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBindingList;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.common.Log;
import org.eclipse.wst.command.internal.provisional.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.provisional.env.core.selection.SelectionListChoices;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class WebServiceServerRuntimeTypeRegistry
implements CommandRegistry {
    private static WebServiceServerRuntimeTypeRegistry instance_;
    private IConfigurationElement[] indexedConfigElems_;
    private HashMap webServiceServers;
    private HashMap webServiceRuntimes;
    private HashMap webServiceTypes;
    private HashMap webServiceServerRuntimeTypes;
    private Hashtable runtimesByType_;
    private Hashtable runtimeLabelById_;
    private Hashtable runtimeIdByLabel_;
    private Hashtable serversByType_;
    private Hashtable serverLabelByFactoryId_;
    private Hashtable serverFactoryIdByLabel_;
    private Hashtable configElemsById_;
    private DataMappingRegistry dataMappingRegistry_;
    private WidgetRegistry widgetRegistry_;
    private CanFinishRegistry canFinishRegistry_;
    private HashMap factoryCache_;
    private SelectionListChoices serverToRuntimeToJ2EE_;
    private Log log_ = new EclipseLog();

    private void loadTypes() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "webServiceServerRuntimeType");
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            try {
                if (elem.getName().equals("webServiceServer")) {
                    WebServiceServer wss = new WebServiceServer(elem);
                    this.webServiceServers.put(elem.getAttribute("id"), wss);
                    String serverLabel = wss.getLabel();
                    if (serverLabel != null && serverLabel.length() > 0) {
                        if (!this.serverLabelByFactoryId_.containsKey(wss.getFactoryId())) {
                            // empty if block
                        }
                        this.serverLabelByFactoryId_.put(wss.getFactoryId(), serverLabel);
                        if (!this.serverFactoryIdByLabel_.containsKey(serverLabel)) {
                            // empty if block
                        }
                        this.serverFactoryIdByLabel_.put(serverLabel, wss.getFactoryId());
                    }
                } else if (elem.getName().equals("webServiceRuntime")) {
                    WebServiceRuntime rt = new WebServiceRuntime(elem);
                    this.webServiceRuntimes.put(elem.getAttribute("id"), rt);
                    if (!this.runtimeLabelById_.containsKey(rt.getId())) {
                        this.runtimeLabelById_.put(rt.getId(), rt.getLabel());
                    }
                    if (!this.runtimeIdByLabel_.containsKey(rt.getLabel())) {
                        this.runtimeIdByLabel_.put(rt.getLabel(), rt.getId());
                    }
                } else if (elem.getName().equals("webServiceType")) {
                    WebServiceTypeImpl wst = new WebServiceTypeImpl(elem);
                    this.webServiceTypes.put(elem.getAttribute("id"), wst);
                } else if (elem.getName().equals("webServiceServerRuntimeType")) {
                    this.configElemsById_.put(elem.getAttribute("id"), elem);
                    String typeId = elem.getAttribute("type");
                    String serverId = elem.getAttribute("server");
                    String runtimeId = elem.getAttribute("runtime");
                    WebServiceServerRuntimeType_ wssrt = new WebServiceServerRuntimeType_(serverId, runtimeId, typeId, elem);
                    this.webServiceServerRuntimeTypes.put(elem.getAttribute("id"), wssrt);
                    this.setRuntimesByType(typeId, runtimeId);
                    this.setServersByType(typeId, serverId);
                }
            }
            catch (Exception e) {
                this.log_.log(4, 5058, (Object)this, "loadTypes", (Throwable)e);
            }
            ++idx;
        }
    }

    private void setRuntimesByType(String typeId, String runtime) {
        if (this.runtimesByType_.get(typeId) != null) {
            Vector v = (Vector)this.runtimesByType_.get(typeId);
            if (!v.contains(runtime.trim())) {
                v.add(runtime.trim());
            }
        } else {
            Vector<String> vect = new Vector<String>();
            vect.add(runtime.trim());
            this.runtimesByType_.put(typeId, vect);
        }
    }

    public WebServiceRuntime getRuntimeById(String id) {
        return (WebServiceRuntime)this.webServiceRuntimes.get(id);
    }

    public String[] getRuntimesByType(String webServiceType) {
        if (this.runtimesByType_.containsKey(webServiceType)) {
            Vector vect = (Vector)this.runtimesByType_.get(webServiceType);
            String[] runtimes = new String[vect.size()];
            int i = 0;
            while (i < vect.size()) {
                String runtimeId = (String)vect.elementAt(i);
                WebServiceRuntime wsr = (WebServiceRuntime)this.webServiceRuntimes.get(runtimeId);
                if (wsr != null) {
                    runtimes[i] = wsr.getId();
                }
                ++i;
            }
            return runtimes;
        }
        this.log_.log(4, 5059, (Object)this, "getRuntimesByType", (Object)("runtimes not found for Web service type " + webServiceType));
        return null;
    }

    public boolean isRuntimeSupportedForType(String webServiceTypeId, String runtimeId) {
        String[] runtimes = this.getRuntimesByType(webServiceTypeId);
        int i = 0;
        while (i < runtimes.length) {
            if (runtimes[i].equals(runtimeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean doesRuntimeSupportJ2EELevel(String j2eeVersionId, String runtimeId) {
        IWebServiceRuntime wsr = (IWebServiceRuntime)this.webServiceRuntimes.get(runtimeId);
        String[] j2eeVersions = wsr.getJ2EEVersions();
        if (j2eeVersions == null || j2eeVersions.length == 0) {
            return true;
        }
        int i = 0;
        while (i < j2eeVersions.length) {
            if (j2eeVersions[i].equals(j2eeVersionId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean doesRuntimeSupportServerTarget(String serverTargetId, String runtimeId) {
        Iterator it = this.webServiceServerRuntimeTypes.values().iterator();
        while (it.hasNext()) {
            String thisServerTargetId;
            IWebServiceServer wsserver;
            String thisFactoryId;
            IServerType serverType;
            WebServiceServerRuntimeType_ wssrt = (WebServiceServerRuntimeType_)it.next();
            if (wssrt == null || !wssrt.runtimeId_.equals(runtimeId) || (serverType = ServerCore.findServerType((String)(thisFactoryId = (wsserver = this.getWebServiceServerById(wssrt.serverId_)).getFactoryId()))) == null || !(thisServerTargetId = serverType.getRuntimeType().getId()).equals(serverTargetId)) continue;
            return true;
        }
        return false;
    }

    public String[] getServerFactoryIDByRuntimeID(String runtimeID) {
        Vector<String> v = new Vector<String>();
        Iterator it = this.webServiceServerRuntimeTypes.values().iterator();
        while (it.hasNext()) {
            WebServiceServerRuntimeType_ wssrt = (WebServiceServerRuntimeType_)it.next();
            if (wssrt == null || !wssrt.runtimeId_.equals(runtimeID)) continue;
            v.add(this.getWebServiceServerById(wssrt.serverId_).getFactoryId());
        }
        String[] serverFactoryIDs = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            serverFactoryIDs[i] = (String)v.get(i);
            ++i;
        }
        return serverFactoryIDs;
    }

    public String[] getRuntimeIDsByServerFactoryID(String serverFactoryID) {
        Vector<String> v = new Vector<String>();
        Iterator it = this.webServiceServerRuntimeTypes.values().iterator();
        while (it.hasNext()) {
            IWebServiceServer wss;
            String wssfId;
            WebServiceServerRuntimeType_ wssrt = (WebServiceServerRuntimeType_)it.next();
            if (wssrt == null || !(wssfId = (wss = this.getWebServiceServerById(wssrt.serverId_)).getFactoryId()).equals(serverFactoryID) || v.contains(wssrt.runtimeId_)) continue;
            v.add(wssrt.runtimeId_);
        }
        String[] runtimeIDs = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            runtimeIDs[i] = (String)v.get(i);
            ++i;
        }
        return runtimeIDs;
    }

    private void setServersByType(String typeId, String server) {
        if (this.serversByType_.get(typeId) != null) {
            Vector v = (Vector)this.serversByType_.get(typeId);
            if (!v.contains(server.trim())) {
                v.add(server.trim());
            }
        } else {
            Vector<String> vect = new Vector<String>();
            vect.add(server.trim());
            this.serversByType_.put(typeId, vect);
        }
    }

    public String[] getServerFactoryIdsByType(String webServiceType) {
        if (this.serversByType_.containsKey(webServiceType)) {
            Vector vect = (Vector)this.serversByType_.get(webServiceType);
            String[] servers = new String[vect.size()];
            int i = 0;
            while (i < vect.size()) {
                String serverId = (String)vect.elementAt(i);
                WebServiceServer wss = (WebServiceServer)this.webServiceServers.get(serverId);
                if (wss != null) {
                    servers[i] = wss.getFactoryId();
                }
                ++i;
            }
            return servers;
        }
        this.log_.log(4, 5060, (Object)this, "getServerByType", (Object)("Web service server not found for Web service type " + webServiceType));
        return null;
    }

    public IWebServiceRuntime getWebServiceRuntimeByLabel(String runtimeLabel) {
        Iterator iter = this.webServiceRuntimes.values().iterator();
        while (iter.hasNext()) {
            WebServiceRuntime wsr = (WebServiceRuntime)iter.next();
            if (wsr == null || !runtimeLabel.equals(wsr.getLabel())) continue;
            return wsr;
        }
        return null;
    }

    public IWebServiceRuntime getWebServiceRuntimeById(String runtimeId) {
        return (IWebServiceRuntime)this.webServiceRuntimes.get(runtimeId);
    }

    public IWebServiceServer getWebServiceServerByFactoryId(String serverFactoryId) {
        if (serverFactoryId == null) {
            return null;
        }
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (wss == null || wss.getFactoryId() == null || !serverFactoryId.equals(wss.getFactoryId())) continue;
            return wss;
        }
        return null;
    }

    public IWebServiceServer getWebServiceServerByLabel(String serverLabel) {
        if (serverLabel == null) {
            return null;
        }
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (wss == null || !serverLabel.equals(wss.getLabel())) continue;
            return wss;
        }
        return null;
    }

    public IWebServiceServer getWebServiceServerById(String serverId) {
        return (IWebServiceServer)this.webServiceServers.get(serverId);
    }

    public IWebServiceType getWebServiceTypeByLabel(String typeLabel) {
        Iterator iter = this.webServiceTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceTypeImpl wst = (WebServiceTypeImpl)iter.next();
            if (wst == null || !typeLabel.equals(wst.getLabel())) continue;
            return wst;
        }
        return null;
    }

    public IWebServiceType getWebServiceTypeById(String typeId) {
        if (this.webServiceTypes.get(typeId) != null) {
            return (WebServiceTypeImpl)this.webServiceTypes.get(typeId);
        }
        return null;
    }

    public boolean requiresEJBProject(String typeId) {
        IWebServiceType wst = WebServiceServerRuntimeTypeRegistry.getInstance().getWebServiceTypeById(typeId);
        if (wst != null) {
            String firstIncludedNature;
            IConfigurationElement elem = wst.getConfigurationElement();
            String includedNatures = elem.getAttribute("includeNatures");
            if (includedNatures == null || includedNatures.length() == 0) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(includedNatures);
            if (st.hasMoreTokens() && (firstIncludedNature = st.nextToken()).equals("org.eclipse.jst.j2ee.ejb.EJBNature")) {
                return true;
            }
        }
        return false;
    }

    public IProject[] getProjectsByWebServiceType(String typeId) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> validProjects = new ArrayList<IProject>();
        int j = 0;
        while (j < projects.length) {
            if (ResourceUtils.isWebProject((IProject)projects[j]) || ResourceUtils.isEJBProject((IProject)projects[j])) {
                validProjects.add(projects[j]);
            }
            ++j;
        }
        return validProjects.toArray(new IProject[0]);
    }

    private boolean include(IProject project, String include) {
        StringTokenizer st = new StringTokenizer(include);
        while (st.hasMoreTokens()) {
            try {
                if (!project.hasNature(st.nextToken())) continue;
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private boolean exclude(IProject project, String exclude) {
        StringTokenizer st = new StringTokenizer(exclude);
        while (st.hasMoreTokens()) {
            try {
                if (!project.hasNature(st.nextToken())) continue;
                return false;
            }
            catch (CoreException coreException) {}
        }
        return true;
    }

    private void load() {
        this.runtimesByType_ = new Hashtable();
        this.serversByType_ = new Hashtable();
        this.configElemsById_ = new Hashtable();
        this.runtimeIdByLabel_ = new Hashtable();
        this.runtimeLabelById_ = new Hashtable();
        this.serverFactoryIdByLabel_ = new Hashtable();
        this.serverLabelByFactoryId_ = new Hashtable();
        this.webServiceServers = new HashMap();
        this.webServiceRuntimes = new HashMap();
        this.webServiceTypes = new HashMap();
        this.webServiceServerRuntimeTypes = new HashMap();
        this.loadTypes();
    }

    public static WebServiceServerRuntimeTypeRegistry getInstance() {
        if (instance_ == null) {
            instance_ = new WebServiceServerRuntimeTypeRegistry();
            instance_.load();
        }
        return instance_;
    }

    public String[] getWebServiceTypeNames() {
        String[] types = new String[this.webServiceTypes.size()];
        int i = 0;
        Iterator iter = this.webServiceTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceTypeImpl wst = (WebServiceTypeImpl)iter.next();
            if (wst == null) continue;
            types[i] = wst.getLabel();
            ++i;
        }
        return types;
    }

    public LabelsAndIds getServiceTypeLabels() {
        LabelsAndIds labelIds = new LabelsAndIds();
        Iterator iterator = this.webServiceTypes.values().iterator();
        int size = this.webServiceTypes.size();
        String[] labels = new String[size];
        String[] ids = new String[size];
        int index = 0;
        labelIds.setLabels_(labels);
        labelIds.setIds_(ids);
        while (iterator.hasNext()) {
            WebServiceTypeImpl type = (WebServiceTypeImpl)iterator.next();
            ids[index] = type.getId();
            labels[index] = type.getLabel();
            ++index;
        }
        return labelIds;
    }

    public IConfigurationElement getConfigurationElementFor(String serverId, String runtimeId, String typeId) {
        if (serverId == null || runtimeId == null || typeId == null) {
            return null;
        }
        Iterator iter = this.webServiceServerRuntimeTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceServerRuntimeType_ wssrt = (WebServiceServerRuntimeType_)iter.next();
            if (wssrt == null || wssrt.getConfigurationElementFor(serverId, runtimeId, typeId) == null) continue;
            return wssrt.getConfigurationElementFor(serverId, runtimeId, typeId);
        }
        return null;
    }

    public IConfigurationElement getConfigElementFor(String factoryId, String runtimeId, String typeId) {
        Iterator iter = this.webServiceServerRuntimeTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceServerRuntimeType_ wssrt = (WebServiceServerRuntimeType_)iter.next();
            if (!wssrt.hasConfigElementFor(factoryId, runtimeId, typeId)) continue;
            return wssrt.element_;
        }
        return null;
    }

    public boolean requiresWebModuleFor(String server, String runtime, String type) {
        IConfigurationElement elem = this.getConfigurationElementFor(server, runtime, type);
        if (elem == null) {
            return false;
        }
        return Boolean.valueOf(elem.getAttribute("requireWebModule"));
    }

    public boolean requiresEJBModuleFor(String server, String runtime, String type) {
        IConfigurationElement elem = this.getConfigurationElementFor(server, runtime, type);
        if (elem == null) {
            return false;
        }
        return Boolean.valueOf(elem.getAttribute("requireEJBModule"));
    }

    public boolean webServiceServerRuntimeTypeExists(String serverID, String runtimeID, String typeID) {
        return this.getConfigurationElementFor(serverID, runtimeID, typeID) != null;
    }

    public String getWebServiceServerRuntimeTypeName(String server, String runtime, String type) {
        IConfigurationElement elem = this.getConfigurationElementFor(server, runtime, type);
        return elem == null ? null : elem.getAttribute("id");
    }

    public WebServiceServerRuntimeType getWebServiceServerRuntimeType(String server, String runtime, String type) {
        WebServiceServerRuntimeType wssrt = null;
        this.getWebServiceServerByFactoryId(server).getId();
        IConfigurationElement elem = this.getConfigurationElementFor(server, runtime, type);
        if (elem == null) {
            server = this.getDefaultServerValueFor(type);
            runtime = this.getDefaultRuntimeValueFor(type);
            elem = this.getConfigurationElementFor(server, runtime, type);
        }
        return wssrt;
    }

    public WebServiceServerRuntimeType getWebServiceServerRuntimeTypeById(String id) {
        WebServiceServerRuntimeType wssrt = null;
        if (this.configElemsById_.containsKey(id)) {
            try {
                IConfigurationElement elem = (IConfigurationElement)this.configElemsById_.get(id);
                Object webServiceType = elem.createExecutableExtension("class");
                if (webServiceType instanceof WebServiceServerRuntimeType) {
                    wssrt = (WebServiceServerRuntimeType)webServiceType;
                    wssrt.setServerLabel(elem.getAttribute("server"));
                    wssrt.setRuntimeLabel(elem.getAttribute("runtime"));
                    wssrt.setWebModuleRequired(Boolean.valueOf(elem.getAttribute("requireWebModule")));
                    wssrt.setEJBModuleRequired(Boolean.valueOf(elem.getAttribute("requireEJBModule")));
                } else {
                    String implementedInterface = "org.eclipse.jst.ws.ui.wizard.WebServiceServerRuntimeType ";
                    String errMsg = "Extensions of the WebServiceServerRuntimeTypes extension point must implement the ";
                    errMsg = String.valueOf(errMsg) + implementedInterface + "interface.";
                    this.log_.log(4, 5061, (Object)this, "getWebServiceServerRuntimeTypeById", (Object)errMsg);
                }
            }
            catch (CoreException ce) {
                this.log_.log(4, 5062, (Object)this, "getWebServiceServerRuntimeTypeById", (Throwable)ce);
            }
        }
        return wssrt;
    }

    public String[] getWebServiceTypeBySelection(IStructuredSelection selection) {
        TypeSelectionFilter tsf = new TypeSelectionFilter();
        String[] wst = tsf.getWebServiceTypeByInitialSelection(selection, this.webServiceTypes);
        return wst == null ? null : wst;
    }

    public IWebServiceType getWebServiceTypeByTypeLabel(String webServiceTypeLabel) {
        Iterator iter = this.webServiceTypes.values().iterator();
        while (iter.hasNext()) {
            WebServiceTypeImpl wst = (WebServiceTypeImpl)iter.next();
            if (wst == null || !wst.getLabel().equals(webServiceTypeLabel)) continue;
            return wst;
        }
        return null;
    }

    public boolean isInitialSelectionValidForChosenType(IStructuredSelection selection, String typeName) {
        String[] supportedTypes = this.getWebServiceTypeBySelection(selection);
        if (supportedTypes != null) {
            int i = 0;
            while (i < supportedTypes.length) {
                if (supportedTypes[i].equals(typeName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isServerSupportedForChosenType(String typeId, String serverID) {
        if (this.serversByType_.containsKey(typeId)) {
            Vector vect = (Vector)this.serversByType_.get(typeId);
            int i = 0;
            while (i < vect.size()) {
                WebServiceServer wss = (WebServiceServer)this.webServiceServers.get((String)vect.elementAt(i));
                if (serverID != null && serverID.equalsIgnoreCase(wss.getFactoryId())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isServerRuntimeTypeSupported(String server, String runtime, String type) {
        IConfigurationElement elem = this.getConfigurationElementFor(server, runtime, type);
        return elem != null;
    }

    public String getDefaultServerValueFor(String typeId) {
        if (this.serversByType_.containsKey(typeId)) {
            Vector vect = (Vector)this.serversByType_.get(typeId);
            String[] servers = new String[vect.size()];
            int i = 0;
            while (i < vect.size()) {
                String serverId = (String)vect.elementAt(i);
                WebServiceServer wss = (WebServiceServer)this.webServiceServers.get(serverId);
                servers[i] = wss.getId();
                ++i;
            }
            return servers[0];
        }
        this.log_.log(4, 5063, (Object)this, "getServerByType", (Object)("Unable to find default server for " + typeId));
        return null;
    }

    public String getDefaultRuntimeValueFor(String typeId) {
        String[] runtimeName = this.getRuntimesByType(typeId);
        int i = 0;
        while (i < runtimeName.length) {
            WebServiceRuntime wsr = (WebServiceRuntime)this.webServiceRuntimes.get(runtimeName[i]);
            if (wsr.getIsDefault()) {
                return runtimeName[i];
            }
            ++i;
        }
        return runtimeName[0];
    }

    public String getServerIdForFactoryId(String factoryId) {
        Iterator iter = this.webServiceServers.values().iterator();
        while (iter.hasNext()) {
            WebServiceServer wss = (WebServiceServer)iter.next();
            if (!wss.getFactoryId().equals(factoryId)) continue;
            return wss.getId();
        }
        return null;
    }

    public CommandFragmentFactoryFactory getFactoryFactory(String[] ids) {
        String hashKey = String.valueOf(ids[2]) + "#" + ids[1] + "#" + ids[0];
        CommandWidgetBinding binding = (CommandWidgetBinding)this.factoryCache_.get(hashKey);
        if (binding == null) {
            IConfigurationElement element = this.getConfigElementFor(ids[2], ids[1], ids[0]);
            if (element == null) {
                return null;
            }
            binding = this.createBinding(element);
            this.factoryCache_.put(hashKey, binding);
            binding.registerDataMappings(this.dataMappingRegistry_);
            if (this.widgetRegistry_ != null) {
                binding.registerWidgetMappings(this.widgetRegistry_);
                binding.registerCanFinish(this.canFinishRegistry_);
            }
        }
        return binding;
    }

    private CommandWidgetBinding createBinding(IConfigurationElement element) {
        Vector bindings = new Vector(4);
        Vector<Object> fragments = new Vector<Object>(4);
        this.addBinding(element, "developBinding", bindings);
        this.addBinding(element, "assemblyBinding", bindings);
        this.addBinding(element, "deployBinding", bindings);
        this.addBinding(element, "installBinding", bindings);
        fragments.add(new ServicePreDevelopFragment());
        fragments.add(new ServicePreAssemblyFragment());
        fragments.add(new ServicePreDeployFragment());
        fragments.add(new ServicePreInstallFragment());
        return new CommandWidgetBindingList(bindings, fragments);
    }

    private void addBinding(IConfigurationElement element, String bindingName, Vector list) {
        Object binding = null;
        if (element.getAttribute(bindingName) != null) {
            try {
                binding = element.createExecutableExtension(bindingName);
            }
            catch (CoreException coreException) {}
        }
        list.add(binding);
    }

    public void setDataMappingRegistry(DataMappingRegistry registry) {
        this.dataMappingRegistry_ = registry;
        this.factoryCache_ = new HashMap();
    }

    public void setWidgetRegistry(WidgetRegistry registry) {
        this.widgetRegistry_ = registry;
    }

    public void setCanFinishRegistry(CanFinishRegistry registry) {
        this.canFinishRegistry_ = registry;
    }

    public String[] getAllServerFactoryIds() {
        Object[] servers = this.webServiceServers.values().toArray();
        String[] factoryIds = new String[servers.length];
        int i = 0;
        while (i < servers.length) {
            WebServiceServer wss = (WebServiceServer)servers[i];
            factoryIds[i] = wss.getFactoryId();
            ++i;
        }
        return factoryIds;
    }

    public String getServerFactoryIdFromServerId(String serverId) {
        Object[] servers = this.webServiceServers.values().toArray();
        int i = 0;
        while (i < servers.length) {
            WebServiceServer wss = (WebServiceServer)servers[i];
            if (serverId == wss.getId()) {
                return wss.getFactoryId();
            }
            ++i;
        }
        return null;
    }

    public SelectionListChoices getServerToRuntimeToJ2EE() {
        if (this.serverToRuntimeToJ2EE_ != null) {
            return this.serverToRuntimeToJ2EE_;
        }
        String[] servers = this.getStringArrayIntersection(this.getAllServerFactoryIds(), WebServiceClientTypeRegistry.getInstance().getAllClientServerFactoryIds());
        SelectionList serversList = new SelectionList(servers, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < servers.length) {
            choices.add(this.getRuntimeChoices(servers[i]));
            ++i;
        }
        this.serverToRuntimeToJ2EE_ = new SelectionListChoices(serversList, choices);
        return this.serverToRuntimeToJ2EE_;
    }

    private SelectionListChoices getRuntimeChoices(String serverFactoryId) {
        String[] serviceRuntimes = this.getRuntimeIDsByServerFactoryID(serverFactoryId);
        String[] clientRuntimes = WebServiceClientTypeRegistry.getInstance().getRuntimeIdsByServerFactoryId(serverFactoryId);
        String[] runtimes = this.getStringArrayIntersection(serviceRuntimes, clientRuntimes);
        SelectionList runtimesList = new SelectionList(runtimes, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < runtimes.length) {
            choices.add(this.getJ2EEChoices(runtimes[i]));
            ++i;
        }
        return new SelectionListChoices(runtimesList, choices);
    }

    private SelectionListChoices getJ2EEChoices(String runtimeId) {
        String[] serviceJ2EEVersions = this.getWebServiceRuntimeById(runtimeId).getJ2EEVersions();
        String[] clientJ2EEVersions = WebServiceClientTypeRegistry.getInstance().getWebServiceRuntimeById(runtimeId).getJ2EEVersions();
        String[] j2eeVersions = this.getStringArrayIntersection(serviceJ2EEVersions, clientJ2EEVersions);
        SelectionList j2eeVersionsList = new SelectionList(j2eeVersions, 0);
        return new SelectionListChoices(j2eeVersionsList, null);
    }

    public String getServerLabel(String factoryId) {
        if (factoryId == null || factoryId.length() == 0) {
            return null;
        }
        if (this.serverLabelByFactoryId_.containsKey(factoryId)) {
            return (String)this.serverLabelByFactoryId_.get(factoryId);
        }
        return null;
    }

    public String getServerFactoryId(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        if (this.serverFactoryIdByLabel_.containsKey(label)) {
            return (String)this.serverFactoryIdByLabel_.get(label);
        }
        return null;
    }

    public String getRuntimeLabel(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        return (String)this.runtimeLabelById_.get(id);
    }

    public String getRuntimeId(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        return (String)this.runtimeIdByLabel_.get(label);
    }

    private String[] getStringArrayIntersection(String[] a1, String[] a2) {
        Vector<String> vf = new Vector<String>();
        if (a1 == null || a2 == null) {
            return this.convertToStringArray(vf.toArray());
        }
        int i = 0;
        while (i < a1.length) {
            int j = 0;
            while (j < a2.length) {
                if (a1[i].equals(a2[j])) {
                    vf.add(a1[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return this.convertToStringArray(vf.toArray());
    }

    private String[] convertToStringArray(Object[] a) {
        if (a == null) {
            return new String[0];
        }
        int length = a.length;
        String[] sa = new String[length];
        int i = 0;
        while (i < length) {
            Object obj = a[i];
            if (obj instanceof String) {
                sa[i] = (String)obj;
            }
            ++i;
        }
        return sa;
    }

    public final class WebServiceServerRuntimeType_ {
        public String typeId_;
        public String serverId_;
        public String runtimeId_;
        public IConfigurationElement element_;

        public WebServiceServerRuntimeType_(String serverId, String runtimeId, String typeId, IConfigurationElement elem) {
            this.typeId_ = typeId;
            this.serverId_ = serverId;
            this.runtimeId_ = runtimeId;
            this.element_ = elem;
        }

        public IConfigurationElement getConfigurationElementFor(String serverID, String runtimeID, String typeID) {
            if (this.typeId_.equals(typeID) && this.serverId_.equals(serverID) && this.runtimeId_.equals(runtimeID)) {
                return this.element_;
            }
            return null;
        }

        public boolean hasConfigElementFor(String factoryID, String runtimeID, String typeID) {
            String serverID = WebServiceServerRuntimeTypeRegistry.this.getServerIdForFactoryId(factoryID);
            return this.typeId_.equalsIgnoreCase(typeID) && this.serverId_.equalsIgnoreCase(serverID) && this.runtimeId_.equalsIgnoreCase(runtimeID);
        }
    }
}

