/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.ui.ant;

import java.io.File;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.eclipse.wst.wsdl.validation.internal.ui.ant.WSDLValidateTask;
import org.eclipse.wst.wsdl.validation.tests.internal.BaseTestCase;

public class WSDLValidateTest
extends BaseTestCase {
    private String BASE_DIR;
    private Project project;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.ui.ant.WSDLValidateTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() {
        super.setUp();
        try {
            this.BASE_DIR = this.PLUGIN_ABSOLUTE_PATH;
            this.BASE_DIR = this.BASE_DIR.replace('/', File.separatorChar);
            if (this.BASE_DIR.startsWith("\\")) {
                this.BASE_DIR = this.BASE_DIR.substring(1);
            }
        }
        catch (Exception exception) {}
        this.project = new Project();
        this.project.setBaseDir(new File(this.BASE_DIR));
    }

    public void testRelativeSingleFileLocation() {
        String fileLoc = "file.wsdl";
        String resolvedLocation = ("file:///" + this.BASE_DIR + fileLoc).replace('\\', '/');
        WSDLValidateTask wsdlValidateTask = new WSDLValidateTask();
        wsdlValidateTask.setProject(this.project);
        wsdlValidateTask.setFile(fileLoc);
        List fileList = wsdlValidateTask.getFileList();
        WSDLValidateTest.assertEquals((String)"The file list does not contain only one file.", (int)1, (int)fileList.size());
        WSDLValidateTest.assertEquals((String)("The file location '" + fileList.get(0) + "' is not correctly resolved to the base location."), (String)resolvedLocation.toLowerCase(), (String)((String)fileList.get(0)).toLowerCase());
    }

    public void testAbsoluteSingleFileLocation() {
        String fileLoc = String.valueOf(this.BASE_DIR) + "file.wsdl";
        String resolvedLocation = (String.valueOf(this.FILE_PROTOCOL) + fileLoc).replace('\\', '/');
        WSDLValidateTask wsdlValidateTask = new WSDLValidateTask();
        wsdlValidateTask.setProject(this.project);
        wsdlValidateTask.setFile(fileLoc);
        List fileList = wsdlValidateTask.getFileList();
        WSDLValidateTest.assertEquals((String)"The file list does not contain only one file.", (int)1, (int)fileList.size());
        WSDLValidateTest.assertEquals((String)("The file location '" + fileLoc + "' is modified."), (String)resolvedLocation.toLowerCase(), (String)((String)fileList.get(0)).toLowerCase());
    }

    public void testAbsoluteSingleFileRemoteLocation() {
        String resolvedLocation = "http://www.ws-i.org/SampleApplications/SupplyChainManagement/2003-07/Catalog.wsdl";
        String fileLoc = "http://www.ws-i.org/SampleApplications/SupplyChainManagement/2003-07/Catalog.wsdl";
        WSDLValidateTask wsdlValidateTask = new WSDLValidateTask();
        wsdlValidateTask.setProject(this.project);
        wsdlValidateTask.setFile(fileLoc);
        List fileList = wsdlValidateTask.getFileList();
        WSDLValidateTest.assertEquals((String)"The file list does not contain only one file.", (int)1, (int)fileList.size());
        WSDLValidateTest.assertEquals((String)("The file location '" + fileLoc + "' is modified."), (String)resolvedLocation.toLowerCase(), (String)((String)fileList.get(0)).toLowerCase());
    }

    public void testRelativeSingleFileInFilesetNoDirSpecified() {
        String fileLoc = "Empty.wsdl";
        String base_dir = String.valueOf(this.BASE_DIR) + this.SAMPLES_DIR + "WSDL" + File.separator + "SelfContained";
        String resolvedLocation = ("file:///" + base_dir + "/" + fileLoc).replace('\\', '/');
        base_dir = base_dir.replace('/', File.separatorChar);
        WSDLValidateTask wsdlValidateTask = new WSDLValidateTask();
        wsdlValidateTask.setProject(this.project);
        FileSet fileset = wsdlValidateTask.createFileset();
        fileset.setProject(this.project);
        fileset.setDir(new File(base_dir));
        FilenameSelector filenameSelector = new FilenameSelector();
        filenameSelector.setName(fileLoc);
        fileset.addFilename(filenameSelector);
        List fileList = wsdlValidateTask.getFileList();
        WSDLValidateTest.assertEquals((String)"The file list does not contain only one file.", (int)1, (int)fileList.size());
        WSDLValidateTest.assertEquals((String)("The file location '" + fileList.get(0) + "' is not correctly resolved to the base location."), (String)resolvedLocation.toLowerCase(), (String)((String)fileList.get(0)).toLowerCase());
    }
}

