/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.wst.javascript.ui.internal.common.HTMLTextPresenter;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.JavaScriptContentAssistProcessor;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptInformationPresenter;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptTagInfoHoverProcessor;

public class JSSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private ITextHover fTextHover = null;
    private IContentAssistant fContentAssistant = null;
    private InformationPresenter fInformationPresenter = null;

    public JSSourceViewerConfiguration() {
    }

    public JSSourceViewerConfiguration(IPreferenceStore store) {
        super(store);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant == null) {
            ContentAssistant contentAssistant = new ContentAssistant();
            contentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            JavaScriptContentAssistProcessor contentAssistantProcessor = new JavaScriptContentAssistProcessor();
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)contentAssistantProcessor, "__dftl_partition_content_type");
            contentAssistant.enableAutoActivation(true);
            contentAssistant.setAutoActivationDelay(500);
            contentAssistant.setProposalPopupOrientation(10);
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            this.fContentAssistant = contentAssistant;
        }
        return this.fContentAssistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 0;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (this.fTextHover == null) {
            this.fTextHover = new JavaScriptTagInfoHoverProcessor();
        }
        return this.fTextHover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.fInformationPresenter == null) {
            this.fInformationPresenter = new JavaScriptInformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
            this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
            this.fInformationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return this.fInformationPresenter;
    }
}

