/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.ServerTypeDefinitionManager;
import org.eclipse.jst.server.generic.internal.core.util.ExtensionPointUtil;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;

public class ServerDefinitionTypeTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ServerDefinitionTypeTest(String name) {
        super(name);
    }

    public void testGetTypes() {
        IExtension[] extensions = ExtensionPointUtil.getGenericServerDefinitionExtensions();
        int noOfExtensions = 0;
        int i = 0;
        while (i < extensions.length) {
            noOfExtensions += ExtensionPointUtil.getConfigurationElements((IExtension)extensions[i]).length;
            ++i;
        }
        ServerTypeDefinitionManager serverTypeDefinitionManager = CorePlugin.getDefault().getServerTypeDefinitionManager();
        ServerDefinitionTypeTest.assertNotNull((Object)serverTypeDefinitionManager);
        ServerRuntime[] types = serverTypeDefinitionManager.getServerTypeDefinitions();
        ServerDefinitionTypeTest.assertNotNull((Object)types);
        ServerDefinitionTypeTest.assertEquals((int)noOfExtensions, (int)types.length);
    }

    public void testResolve() {
        ServerTypeDefinitionManager serverTypeDefinitionManager = CorePlugin.getDefault().getServerTypeDefinitionManager();
        ServerDefinitionTypeTest.assertNotNull((Object)serverTypeDefinitionManager);
        ServerRuntime[] types = serverTypeDefinitionManager.getServerTypeDefinitions();
        ServerDefinitionTypeTest.assertNotNull((Object)types);
        ServerDefinitionTypeTest.assertTrue((types.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < types.length) {
            ServerRuntime definition = types[i];
            String wd = definition.getStart().getWorkingDirectory();
            String resolved = definition.getResolver().resolveProperties(wd);
            ServerDefinitionTypeTest.assertFalse((resolved.indexOf("${") >= 0 ? 1 : 0) != 0);
            ++i;
        }
    }
}

