/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class TestProject {
    public IProject project;
    public IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;

    public TestProject() throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject("Project-1");
        this.project.create(null);
        this.project.open(null);
        this.javaProject = JavaCore.create((IProject)this.project);
        IFolder binFolder = this.createBinFolder();
        this.setJavaNature();
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createOutputFolder(binFolder);
        this.addSystemLibraries();
    }

    public IProject getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void addJar(String plugin, String jar) throws MalformedURLException, IOException, JavaModelException {
        Path result = this.findFileInPlugin(plugin, jar);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newLibraryEntry((IPath)result, null, null);
        this.javaProject.setRawClasspath(newEntries, null);
    }

    public IPackageFragment createPackage(String name) throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder.createPackageFragment(name, false, null);
    }

    public IType createType(IPackageFragment pack, String cuName, String source) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append("package " + pack.getElementName() + ";\n");
        buf.append("\n");
        buf.append(source);
        ICompilationUnit cu = pack.createCompilationUnit(cuName, buf.toString(), false, null);
        return cu.getTypes()[0];
    }

    public void dispose() throws CoreException {
        this.waitForIndexer();
        this.project.delete(true, true, null);
    }

    private IFolder createBinFolder() throws CoreException {
        IFolder binFolder = this.project.getFolder("bin");
        binFolder.create(false, true, null);
        return binFolder;
    }

    public IFolder createWebModule(String moduleName, String contents) throws CoreException {
        IFolder moduleFolder = this.project.getFolder(moduleName);
        moduleFolder.create(false, true, null);
        IFolder folder = this.project.getFolder(String.valueOf(moduleName) + "/WEB-INF");
        folder.create(false, true, null);
        folder = this.project.getFolder(String.valueOf(moduleName) + "/WEB-INF/classes");
        folder.create(false, true, null);
        folder = this.project.getFolder(String.valueOf(moduleName) + "/WEB-INF/lib");
        folder.create(false, true, null);
        ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
        IFile file = this.project.getFile(String.valueOf(moduleName) + "/WEB-INF/web.xml");
        file.create((InputStream)stream, true, null);
        return moduleFolder;
    }

    private void setJavaNature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.project.setDescription(description, null);
    }

    private void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this.javaProject.setOutputLocation(outputLocation, null);
    }

    public IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder folder = this.project.getFolder("src");
        folder.create(false, true, null);
        IPackageFragmentRoot root = this.javaProject.getPackageFragmentRoot((IResource)folder);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
        this.javaProject.setRawClasspath(newEntries, null);
        return root;
    }

    private void addSystemLibraries() throws JavaModelException {
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaRuntime.getDefaultJREContainerEntry();
        this.javaProject.setRawClasspath(newEntries, null);
    }

    private Path findFileInPlugin(String plugin, String file) throws MalformedURLException, IOException {
        Bundle bundle = Platform.getBundle((String)plugin);
        URL pluginURL = bundle.getEntry("/");
        URL jarURL = new URL(pluginURL, file);
        URL localJarURL = Platform.asLocalURL((URL)jarURL);
        return new Path(localJarURL.getPath());
    }

    private void waitForIndexer() throws JavaModelException {
        new SearchEngine().searchAllTypeNames(null, null, 8, 5, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[0]), new TypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            }
        }, 3, null);
    }

    public IPackageFragmentRoot getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(IPackageFragmentRoot sourceFolder) {
        this.sourceFolder = sourceFolder;
    }
}

