/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.EMFExpression;
import org.eclipse.wst.common.navigator.internal.views.extensions.SkeletonActionProvider;

public class CommonActionProviderDescriptor {
    private final IConfigurationElement configurationElement;
    private ActionExpression enablement;
    private static final String ENABLEMENT = "enablement";
    private boolean hasLoadingFailed;
    private static final String ATT_CLASS = "class";
    private static final String EMF_ENABLEMENT = "emfEnablement";
    private EMFExpression emfEnablement;

    public CommonActionProviderDescriptor(IConfigurationElement aConfigElement) {
        this.configurationElement = aConfigElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children = this.configurationElement.getChildren(ENABLEMENT);
        if (children.length == 1) {
            this.enablement = new ActionExpression(children[0]);
        } else if (children.length > 1) {
            System.err.println("More than one element: enablement in navigator extension: " + this.configurationElement.getDeclaringExtension().getUniqueIdentifier());
        }
        children = this.configurationElement.getChildren(EMF_ENABLEMENT);
        if (children.length == 1) {
            this.emfEnablement = new EMFExpression(children[0]);
        } else if (children.length > 1) {
            System.err.println("More than one element: emfEnablement in navigator extension: " + this.configurationElement.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public ICommonActionProvider createActionProvider() {
        if (this.hasLoadingFailed) {
            return SkeletonActionProvider.INSTANCE;
        }
        ICommonActionProvider provider = null;
        try {
            provider = (ICommonActionProvider)this.configurationElement.createExecutableExtension(ATT_CLASS);
        }
        catch (CoreException exception) {
            WorkbenchPlugin.log((String)("Unable to create navigator extension: " + this.getClassName()), (IStatus)exception.getStatus());
            this.hasLoadingFailed = true;
        }
        catch (Exception e) {
            WorkbenchPlugin.log((String)("Unable to create navigator extension: " + this.getClassName()), (Throwable)e);
            e.printStackTrace();
            this.hasLoadingFailed = true;
        }
        return provider;
    }

    private String getClassName() {
        return this.configurationElement.getAttribute(ATT_CLASS);
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        return this.enablement != null && this.enablement.isEnabledFor(aStructuredSelection) || this.emfEnablement != null && this.emfEnablement.isEnabledFor(aStructuredSelection);
    }

    public boolean isEnabledFor(Object anElement) {
        return this.enablement != null && this.enablement.isEnabledFor(anElement) || this.emfEnablement != null && this.emfEnablement.isEnabledFor(anElement);
    }
}

