/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.ws.internal.common.EnvironmentUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AbstractStartServer;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateAppClientProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateEJBProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateJavaProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateWebProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.StartProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.WebServiceStartServerRegistry;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class CreateClientProjectCommand
extends SimpleCommand {
    private String ID_WEB = "org.eclipse.jst.ws.consumption.ui.clientProjectType.Web";
    private String ID_EJB = "org.eclipse.jst.ws.consumption.ui.clientProjectType.EJB";
    private String ID_APP_CLIENT = "org.eclipse.jst.ws.consumption.ui.clientProjectType.AppClient";
    private String ID_JAVA = "org.eclipse.jst.ws.consumption.ui.clientProjectType.Containerless";
    private boolean proxyCodegenEnabled = true;
    private String clientProjectTypeId;
    private IProject proxyProject;
    private IProject proxyProjectEAR;
    private String existingServerId_;
    private String serverFactoryId_;
    private String j2eeVersion_;
    private boolean needEAR_;
    private boolean addedProjectToServer_ = false;
    private IServer fExistingServer = null;
    private MessageUtils msgUtils_;
    private String moduleName_;

    public CreateClientProjectCommand(String moduleName) {
        super("org.eclipse.jst.ws.internal.consumption.command.common.CreateClientProjectCommand", "org.eclipse.jst.ws.internal.consumption.command.common.CreateClientProjectCommand");
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.moduleName_ = moduleName;
    }

    public boolean isUndoable() {
        return true;
    }

    public Status undo(Environment env) {
        SimpleStatus stat = new SimpleStatus("");
        try {
            if (this.fExistingServer != null) {
                AbstractStartServer startServerCommand = null;
                WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
                startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(this.fExistingServer.getServerType().getId());
                if (this.proxyProjectEAR != null) {
                    startServerCommand.runPostServerConfig(this.fExistingServer, this.proxyProjectEAR);
                }
            }
        }
        catch (CoreException ce) {
            IStatus embeddedStatus = ce.getStatus();
            stat = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            env.getStatusHandler().reportError((Status)stat);
            return stat;
        }
        return stat;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        IServer[] servers = ServerCore.getServers();
        IServer existingServer = null;
        this.fExistingServer = null;
        int i = 0;
        while (i < servers.length) {
            IServer thisServer = servers[i];
            IServerWorkingCopy wc = null;
            String thisServerId = null;
            if (thisServer != null) {
                wc = thisServer.createWorkingCopy();
                String string = thisServerId = wc != null ? wc.getId() : null;
            }
            if (thisServerId.equals(this.existingServerId_)) {
                this.fExistingServer = existingServer = thisServer;
            }
            ++i;
        }
        if (this.proxyCodegenEnabled) {
            if (this.clientProjectTypeId == null || this.clientProjectTypeId.length() <= 0) {
                this.clientProjectTypeId = WebServicePlugin.getInstance().getProjectTopologyContext().getClientTypes()[0];
            }
            if (this.ID_WEB.equals(this.clientProjectTypeId)) {
                CreateWebProjectCommand c = new CreateWebProjectCommand();
                c.setProjectName(this.proxyProject.getName());
                if (this.proxyProjectEAR != null) {
                    c.setEarProjectName(this.proxyProjectEAR.getName());
                } else {
                    c.setEarProjectName("");
                }
                c.setServerFactoryId(this.serverFactoryId_);
                c.setJ2EEVersion(this.j2eeVersion_);
                c.setExistingServer(existingServer);
                c.setNeedEAR(this.needEAR_);
                c.setAddedProjectToServer(this.addedProjectToServer_);
                status = c.execute(env);
                if (status.getSeverity() == 4) {
                    return status;
                }
                Status startServerStatus = this.startServer(env, this.proxyProject);
                if (startServerStatus.getSeverity() == 4) {
                    return startServerStatus;
                }
            } else if (this.ID_EJB.equals(this.clientProjectTypeId)) {
                CreateEJBProjectCommand c = new CreateEJBProjectCommand();
                c.setEjbProjectName(this.proxyProject.getName());
                c.setEarProjectName(this.proxyProjectEAR.getName());
                c.setServerFactoryId(this.serverFactoryId_);
                c.setJ2EEVersion(this.j2eeVersion_);
                status = c.execute(env);
            } else if (this.ID_APP_CLIENT.equals(this.clientProjectTypeId)) {
                CreateAppClientProjectCommand c = new CreateAppClientProjectCommand();
                c.setAppClientProjectName(this.proxyProject.getName());
                c.setEarProjectName(this.proxyProjectEAR.getName());
                c.setServerFactoryId(this.serverFactoryId_);
                c.setJ2EEVersion(this.j2eeVersion_);
                status = c.execute(env);
            } else if (this.ID_JAVA.equals(this.clientProjectTypeId)) {
                CreateJavaProjectCommand c = new CreateJavaProjectCommand();
                c.setProjectName(this.proxyProject.getName());
                status = c.execute(env);
            }
        }
        try {
            AbstractStartServer startServerCommand = null;
            WebServiceStartServerRegistry reg = WebServiceStartServerRegistry.getInstance();
            startServerCommand = (AbstractStartServer)reg.getServerStartByTypeId(existingServer.getServerType().getId());
            if (this.proxyProjectEAR != null && existingServer != null) {
                startServerCommand.runPreServerConfig(existingServer, this.proxyProjectEAR);
                this.fExistingServer = existingServer;
            }
        }
        catch (CoreException ce) {
            IStatus embeddedStatus = ce.getStatus();
            status = EnvironmentUtils.convertIStatusToStatus((IStatus)embeddedStatus);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return status;
    }

    private Status startServer(Environment env, IProject webProject) {
        try {
            if (this.needEAR_ && this.fExistingServer != null) {
                StartProjectCommand spc = new StartProjectCommand(this.moduleName_);
                spc.setSampleProject(webProject);
                spc.setSampleExistingServer(this.fExistingServer);
                spc.setCreationScenario(new Boolean("false"));
                return spc.execute(env);
            }
        }
        catch (Exception ce) {
            env.getLog().log(4, 5046, (Object)this, "execute", (Throwable)ce);
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", this.msgUtils_.getMessage("MSG_ERROR_WEB_PROJECT_CREATE"), 4, (Throwable)ce);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
        return new SimpleStatus("");
    }

    public void setProxyCodegenEnabled(boolean proxyCodegenEnabled) {
        this.proxyCodegenEnabled = proxyCodegenEnabled;
    }

    public void setProxyProjectEAR(IProject proxyProjectEAR) {
        this.proxyProjectEAR = proxyProjectEAR;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject = proxyProject;
    }

    public void setClientProjectTypeId(String clientProjectTypeId) {
        this.clientProjectTypeId = clientProjectTypeId;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId_ = serverFactoryId;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }

    public void setNeedEAR(boolean needEAR) {
        this.needEAR_ = needEAR;
    }

    public void setExistingServerId(String existingServerId) {
        this.existingServerId_ = existingServerId;
    }

    public void setAddedProjectToServer(boolean addedProjectToServer) {
        this.addedProjectToServer_ = addedProjectToServer;
    }
}

