/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class EarEMFTest
extends GeneralEMFPopulationTest {
    protected EARFile earFile;
    int createdModules = 0;
    private int NUM_MODULES = 5;

    public EarEMFTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.EarEMFTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EarEMFTest("testEARPopulation"));
        suite.addTest((Test)new EarEMFTest("test14EARPopulation"));
        return suite;
    }

    public void testEARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        ApplicationResource DD = (ApplicationResource)this.earFile.getDeploymentDescriptorResource();
        DD.setVersionID(13);
        this.setVersion(1);
        this.setModuleType(0);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "EMFTestNoID/application.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestEAR/META-INF/application.xml";
        EarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void test14EARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        ApplicationResource DD = (ApplicationResource)this.earFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(0);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEAR14";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.getEAR();
        EarEMFTest.assertEquals((String)"1.4", (String)this.earFile.getDeploymentDescriptor().getVersion());
        out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEAR14_2";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(out) + "/META-INF/application.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestEAR14/META-INF/application.xml";
        EarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        EarEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void getEAR() throws OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestEAR14";
        this.earFile = this.getArchiveFactory().openEARFile(in);
        EarEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }

    public EObject createInstance(EReference ref, EObject eObject) {
        EClass eClassifier = (EClass)ref.getEType();
        if (eClassifier.getName().equals("Module")) {
            ++this.createdModules;
            switch (this.createdModules) {
                case 1: {
                    return this.createJavaModuleInstance(eClassifier);
                }
                case 2: {
                    return this.createEJBModuleInstance(eClassifier);
                }
                case 3: {
                    return this.createWebModuleInstance(eClassifier);
                }
                case 4: {
                    return this.createConnetorModuleInstance(eClassifier);
                }
            }
            return this.createJavaModuleInstance(eClassifier);
        }
        return super.createInstance(ref, eObject);
    }

    private EObject createConnetorModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createConnectorModule();
    }

    private EObject createWebModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createWebModule();
    }

    private EObject createEJBModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createEjbModule();
    }

    private EObject createJavaModuleInstance(EClass eClassifier) {
        return ((ApplicationFactory)eClassifier.getEPackage().getEFactoryInstance()).createJavaClientModule();
    }

    public Object getSharedObjectByType(EObject owner, EReference ref) {
        if (ref.getName().equals("module")) {
            return this.createJavaModuleInstance((EClass)ref.getEType());
        }
        return super.getSharedObjectByType(owner, ref);
    }

    public int getDepthForAttribute(EStructuralFeature ref) {
        if (ref.getName().equals("modules")) {
            return this.NUM_MODULES;
        }
        return super.getDepthForAttribute(ref);
    }
}

