/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFEditingTest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.internal.webapplication.impl.FilterMappingImpl;
import org.eclipse.jst.j2ee.webapplication.ErrorPage;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class WarEMFEditTest
extends GeneralEMFEditingTest {
    protected EARFile earFile;
    protected WARFile warFile;
    protected int createdWebTypes = 0;
    protected int createdErrorPages = 0;
    protected boolean fmFlag = false;

    public WarEMFEditTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.WarEMFTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new WarEMFEditTest("testWAREdit"));
        return suite;
    }

    public void testWAREdit() throws Exception {
        this.getWARClient();
        WebAppResource DD = (WebAppResource)this.warFile.getDeploymentDescriptorResource();
        this.setVersion(1);
        this.setModuleType(4);
        this.editRoot(DD.getRootObject());
        String curDir = AutomatedBVT.baseDirectory;
        String out = String.valueOf(curDir) + "testOutput/EMFModelCreationTests/EditWarEAR";
        this.warFile.extractTo(out, 126);
        this.warFile.close();
        String cfr_ignored_0 = String.valueOf(curDir) + "EMFTests/web.xml";
        String cfr_ignored_1 = String.valueOf(curDir) + out + "/fooWAR/WEB-INF/web.xml";
    }

    public void getWARClient() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "loose_module_workspace/LooseEARWeb/webApplication/";
        this.warFile = this.getArchiveFactory().openWARFile(in);
        WarEMFEditTest.assertTrue((this.warFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public EObject createInstance(EClass eClassifier) {
        if (WebapplicationPackage.eINSTANCE.getWebType().equals(eClassifier)) {
            return this.createWebType();
        }
        if (WebapplicationPackage.eINSTANCE.getErrorPage().equals(eClassifier)) {
            return this.createErrorPage();
        }
        return super.createInstance(eClassifier);
    }

    public WebType createWebType() {
        ++this.createdWebTypes;
        if ((this.createdWebTypes & 1) == 0) {
            return WebapplicationFactory.eINSTANCE.createServletType();
        }
        return WebapplicationFactory.eINSTANCE.createJSPType();
    }

    public ErrorPage createErrorPage() {
        ++this.createdErrorPages;
        if ((this.createdErrorPages & 1) == 0) {
            return WebapplicationFactory.eINSTANCE.createErrorCodeErrorPage();
        }
        return WebapplicationFactory.eINSTANCE.createExceptionTypeErrorPage();
    }

    protected void populateAttributes(EObject eObject) {
        if (eObject instanceof FilterMappingImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                if (!att.getName().equals("urlPattern") || !this.fmFlag) {
                    Object value = this.createAttributeValue(att, eObject);
                    if (att.isChangeable()) {
                        eObject.eSet((EStructuralFeature)att, value);
                    }
                }
                ++i;
            }
            this.fmFlag = !this.fmFlag;
        } else {
            super.editAttributes(eObject);
        }
    }

    protected void populateSharedReference(EObject eObject, EReference ref) {
        if (eObject instanceof FilterMappingImpl && ref.getName().equals("servlet")) {
            boolean bl = this.fmFlag = !this.fmFlag;
            if (!this.fmFlag) {
                return;
            }
        }
        super.populateSharedReference(eObject, ref);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }
}

