/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.common.ResAuthTypeBase;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.internal.webapplication.impl.FilterMappingImpl;
import org.eclipse.jst.j2ee.webapplication.ErrorPage;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class WarEMFTest
extends GeneralEMFPopulationTest {
    protected EARFile earFile;
    protected WARFile warFile;
    protected int createdWebTypes = 0;
    protected int createdErrorPages = 0;
    protected boolean fmFlag = false;
    static /* synthetic */ Class class$0;

    public WarEMFTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.emftests.WarEMFTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new WarEMFTest("testWARPopulation"));
        suite.addTest((Test)new WarEMFTest("test14WARPopulation"));
        return suite;
    }

    public void testWARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createWARClient();
        WebAppResource DD = (WebAppResource)this.warFile.getDeploymentDescriptorResource();
        DD.setVersionID(13);
        this.setVersion(1);
        this.setModuleType(4);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestWarEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "EMFTestNoID/web.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestWarEAR/fooWAR/WEB-INF/web.xml";
        WarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.setEquivalentLines(this.getEquivalentLinesMap());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void test14WARPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createWARClient();
        WebAppResource DD = (WebAppResource)this.warFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(4);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestWarEAR14";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.getWARClient();
        WarEMFTest.assertEquals((String)"2.4", (String)this.warFile.getDeploymentDescriptor().getVersion());
        out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestWarEAR14_2";
        this.warFile.extractTo(out, 126);
        this.warFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(out) + "/WEB-INF/web.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestWarEAR14/fooWAR/WEB-INF/web.xml";
        WarEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    private Map getEquivalentLinesMap() {
        HashMap<String, String> lines = new HashMap<String, String>();
        lines.put("<distributable></distributable>", "<distributable/>");
        return lines;
    }

    public void createWARClient() throws DuplicateObjectException {
        this.warFile = this.getArchiveFactory().createWARFileInitialized("fooWAR");
        this.warFile = (WARFile)this.earFile.addCopy((ModuleFile)this.warFile);
        this.warFile.getDeploymentDescriptor().setDisplayName("fooWAR");
        WarEMFTest.assertTrue((this.warFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        WarEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void getWARClient() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestWarEAR14/fooWAR";
        this.warFile = this.getArchiveFactory().openWARFile(in);
        WarEMFTest.assertTrue((this.warFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public EObject createInstance(EReference ref, EObject eObject) {
        if (WebapplicationPackage.eINSTANCE.getWebType().equals(ref.getEType())) {
            return this.createWebType();
        }
        if (WebapplicationPackage.eINSTANCE.getErrorPage().equals(ref.getEType())) {
            return this.createErrorPage();
        }
        return super.createInstance(ref, eObject);
    }

    public WebType createWebType() {
        ++this.createdWebTypes;
        if ((this.createdWebTypes & 1) == 0) {
            return WebapplicationFactory.eINSTANCE.createServletType();
        }
        return WebapplicationFactory.eINSTANCE.createJSPType();
    }

    public ErrorPage createErrorPage() {
        ++this.createdErrorPages;
        if ((this.createdErrorPages & 1) == 0) {
            return WebapplicationFactory.eINSTANCE.createErrorCodeErrorPage();
        }
        return WebapplicationFactory.eINSTANCE.createExceptionTypeErrorPage();
    }

    protected void populateAttributes(EObject eObject) {
        if (eObject instanceof FilterMappingImpl) {
            EList attributes = eObject.eClass().getEAllAttributes();
            int i = 0;
            while (i < attributes.size()) {
                EAttribute att = (EAttribute)attributes.get(i);
                if (!att.getName().equals("urlPattern") || !this.fmFlag) {
                    Object value = this.createAttributeValue(att, eObject);
                    if (att.isChangeable()) {
                        eObject.eSet((EStructuralFeature)att, value);
                    }
                }
                ++i;
            }
            this.fmFlag = !this.fmFlag;
        } else {
            super.populateAttributes(eObject);
        }
    }

    protected void populateSharedReference(EObject eObject, EReference ref) {
        if (eObject instanceof FilterMappingImpl && ref.getName().equals("servlet")) {
            boolean bl = this.fmFlag = !this.fmFlag;
            if (!this.fmFlag) {
                return;
            }
        }
        super.populateSharedReference(eObject, ref);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }

    protected boolean isValidAuth(ResAuthTypeBase auth) {
        if (this.version == 0) {
            return auth == ResAuthTypeBase.SERVLET_LITERAL || auth == ResAuthTypeBase.CONTAINER_LITERAL;
        }
        return super.isValidAuth(auth);
    }
}

