/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.io.FileNotFoundException;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class ClientContainerResourceLoadTest
extends TestCase {
    public static EARFile earFile = null;
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    static /* synthetic */ Class class$0;

    public ClientContainerResourceLoadTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ArchiveInit.init();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.ClientContainerResourceLoadTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.ClientContainerResourceLoadTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public void testClientContainerLoad() throws Exception {
        try {
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            String in = String.valueOf(AutomatedBVT.baseDirectory) + "mtapp2.ear";
            String out = String.valueOf(AutomatedBVT.baseDirectory) + "mtapp2Finished.ear";
            earFile = factory.openEARFile(in);
            System.out.println("uri: " + earFile.getURI());
            List appClients = earFile.getApplicationClientFiles();
            boolean exFound1 = false;
            boolean exFound2 = false;
            int i = 0;
            while (i < appClients.size()) {
                block8: {
                    ApplicationClientFile file;
                    block7: {
                        file = (ApplicationClientFile)appClients.get(0);
                        try {
                            file.getMofResource("META-INF/FOOclient-resource.xmi");
                        }
                        catch (Exception e) {
                            exFound1 = true;
                            if (e instanceof FileNotFoundException) break block7;
                            ClientContainerResourceLoadTest.assertTrue((String)"Expected FileNotFoundException", (boolean)false);
                        }
                    }
                    try {
                        file.getMofResource("META-INF/client-resource.xmi");
                    }
                    catch (Exception e) {
                        exFound2 = true;
                        if (e instanceof ResourceLoadException) break block8;
                        ClientContainerResourceLoadTest.assertTrue((String)"Expected ResourceLoadException", (boolean)false);
                    }
                }
                ++i;
            }
            ClientContainerResourceLoadTest.assertTrue((String)"No exception logged for non-existing file", (boolean)exFound1);
            ClientContainerResourceLoadTest.assertTrue((String)"No exception logged for existing", (boolean)exFound2);
            earFile.saveAs(out);
            earFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

