/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.test.EjbEMFTestBase;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;

public class AssemblyDescriptorTest
extends EjbEMFTestBase {
    public AssemblyDescriptorTest(String name) {
        super(name);
    }

    public void test_getMethodPermissionMethodElements() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        AssemblyDescriptor assemblyDescriptor = DD.getEJBJar().getAssemblyDescriptor();
        AssemblyDescriptorTest.assertNotNull((Object)assemblyDescriptor);
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        EnterpriseBean eb1 = (EnterpriseBean)enterpriseBeans.get(0);
        List methodPermissionList = assemblyDescriptor.getMethodPermissionMethodElements(eb1);
        ArrayList allMethodElements = new ArrayList();
        EList permissions = assemblyDescriptor.getMethodPermissions();
        int i = 0;
        while (i < permissions.size()) {
            MethodPermission permission = (MethodPermission)permissions.get(i);
            allMethodElements.addAll(permission.getMethodElements(eb1));
            ++i;
        }
        AssemblyDescriptorTest.assertEquals(methodPermissionList, allMethodElements);
    }

    public static void assertEquals(List expected, List actual) {
        AssemblyDescriptorTest.assertEquals((int)actual.size(), (int)expected.size());
        int x = 0;
        while (x < expected.size()) {
            Object o = expected.get(x);
            AssemblyDescriptorTest.assertEquals((boolean)actual.contains(o), (boolean)true);
            ++x;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new AssemblyDescriptorTest("test_getMethodPermissionMethodElements"));
        suite.addTest((Test)new AssemblyDescriptorTest("test_getMethodTransactionMethodElements"));
        suite.addTest((Test)new AssemblyDescriptorTest("test_getSecurityRoleNamed"));
        suite.addTest((Test)new AssemblyDescriptorTest("test_renameSecurityRole"));
        suite.addTest((Test)new AssemblyDescriptorTest("test_removeData"));
        return suite;
    }

    public void test_getMethodTransactionMethodElements() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        AssemblyDescriptor assemblyDescriptor = DD.getEJBJar().getAssemblyDescriptor();
        AssemblyDescriptorTest.assertNotNull((Object)assemblyDescriptor);
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        EnterpriseBean eb1 = (EnterpriseBean)enterpriseBeans.get(0);
        List methodTransactionList = assemblyDescriptor.getMethodTransactionMethodElements(eb1);
        ArrayList allMethodElements = new ArrayList();
        EList transactions = assemblyDescriptor.getMethodTransactions();
        int i = 0;
        while (i < transactions.size()) {
            MethodTransaction transaction = (MethodTransaction)transactions.get(i);
            allMethodElements.addAll(transaction.getMethodElements(eb1));
            ++i;
        }
        AssemblyDescriptorTest.assertEquals(methodTransactionList, allMethodElements);
    }

    public void test_getSecurityRoleNamed() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        AssemblyDescriptor assemblyDescriptor = DD.getEJBJar().getAssemblyDescriptor();
        AssemblyDescriptorTest.assertNotNull((Object)assemblyDescriptor);
        SecurityRole securityRole = CommonPackage.eINSTANCE.getCommonFactory().createSecurityRole();
        String securityRoleName = "testRole";
        securityRole.setRoleName(securityRoleName);
        assemblyDescriptor.getSecurityRoles().add((Object)securityRole);
        SecurityRole retValue = assemblyDescriptor.getSecurityRoleNamed(securityRoleName);
        AssemblyDescriptorTest.assertEquals((Object)retValue, (Object)securityRole);
    }

    public void test_renameSecurityRole() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        AssemblyDescriptor assemblyDescriptor = DD.getEJBJar().getAssemblyDescriptor();
        AssemblyDescriptorTest.assertNotNull((Object)assemblyDescriptor);
        String securityRoleName = "testRole";
        SecurityRole securityRole = CommonPackage.eINSTANCE.getCommonFactory().createSecurityRole();
        securityRole.setRoleName(securityRoleName);
        assemblyDescriptor.getSecurityRoles().add((Object)securityRole);
        String newSecurityRoleName = "newTestRole";
        SecurityRole retValue = assemblyDescriptor.getSecurityRoleNamed(newSecurityRoleName);
        AssemblyDescriptorTest.assertNull((Object)retValue);
        assemblyDescriptor.renameSecurityRole(securityRoleName, newSecurityRoleName);
        retValue = assemblyDescriptor.getSecurityRoleNamed(newSecurityRoleName);
        AssemblyDescriptorTest.assertNotNull((Object)retValue);
    }

    public void test_removeData() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        AssemblyDescriptor assemblyDescriptor = DD.getEJBJar().getAssemblyDescriptor();
        AssemblyDescriptorTest.assertNotNull((Object)assemblyDescriptor);
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        EnterpriseBean eb1 = (EnterpriseBean)enterpriseBeans.get(0);
        List methodTransactionList = assemblyDescriptor.getMethodTransactionMethodElements(eb1);
        List methodPermissionList = assemblyDescriptor.getMethodPermissionMethodElements(eb1);
        AssemblyDescriptorTest.assertEquals((methodTransactionList.size() > 0 ? 1 : 0) != 0, (boolean)true);
        AssemblyDescriptorTest.assertEquals((methodPermissionList.size() > 0 ? 1 : 0) != 0, (boolean)true);
        assemblyDescriptor.removeData(eb1);
        methodTransactionList = assemblyDescriptor.getMethodTransactionMethodElements(eb1);
        methodPermissionList = assemblyDescriptor.getMethodPermissionMethodElements(eb1);
        AssemblyDescriptorTest.assertEquals((methodTransactionList.size() == 0 ? 1 : 0) != 0, (boolean)true);
        AssemblyDescriptorTest.assertEquals((methodPermissionList.size() == 0 ? 1 : 0) != 0, (boolean)true);
    }
}

