/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaRefFactoryImpl;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.test.EjbEMFTestBase;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;

public class MethodElementTest
extends EjbEMFTestBase {
    private final int SESSION = 0;
    private final int ENTITY = 1;
    private final int CONTAINER_MANAGED_ENTITY = 2;
    static /* synthetic */ Class class$0;

    public MethodElementTest(String name) {
        super(name);
    }

    private MethodElement getInstance() {
        return EjbPackage.eINSTANCE.getEjbFactory().createMethodElement();
    }

    public void test_MethodElement() {
        MethodElement tmpMethodElement = this.getInstance();
        MethodElementTest.assertNotNull((Object)tmpMethodElement);
    }

    public void test_addMethodParams() {
        MethodElement objMethodElement = this.getInstance();
        String param1 = "param1";
        String param2 = "param2";
        boolean retValue = false;
        objMethodElement.addMethodParams(param1);
        objMethodElement.addMethodParams(param2);
        List list = objMethodElement.getMethodParams();
        retValue = list.contains(param1);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_applyZeroParams() {
        MethodElement objMethodElement = this.getInstance();
        String param1 = "param1";
        String param2 = "param2";
        objMethodElement.addMethodParams(param1);
        objMethodElement.addMethodParams(param2);
        List list = objMethodElement.getMethodParams();
        MethodElementTest.assertEquals((list.size() == 2 ? 1 : 0) != 0, (boolean)true);
        objMethodElement.applyZeroParams();
        list = objMethodElement.getMethodParams();
        MethodElementTest.assertEquals((list.size() == 0 ? 1 : 0) != 0, (boolean)true);
    }

    public void test_equalSignature() {
        MethodElement objMethodElement1 = this.getInstance();
        MethodElement objMethodElement2 = this.getInstance();
        MethodElement objMethodElement3 = this.getInstance();
        objMethodElement1.setName("name");
        objMethodElement2.setName("name");
        objMethodElement3.setName("name");
        String param1 = "param1";
        String param2 = "param2";
        String param3 = "param3";
        objMethodElement1.addMethodParams(param1);
        objMethodElement1.addMethodParams(param2);
        objMethodElement2.addMethodParams(param1);
        objMethodElement2.addMethodParams(param2);
        objMethodElement3.addMethodParams(param1);
        objMethodElement3.addMethodParams(param2);
        objMethodElement1.setType(MethodElementKind.LOCAL_LITERAL);
        objMethodElement2.setType(MethodElementKind.LOCAL_LITERAL);
        objMethodElement3.setType(MethodElementKind.LOCAL_LITERAL);
        boolean retValue = false;
        retValue = objMethodElement1.equalSignature(objMethodElement2);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        retValue = objMethodElement2.equalSignature(objMethodElement3);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement3.setName("nameDiff");
        retValue = objMethodElement2.equalSignature(objMethodElement3);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
        objMethodElement2.addMethodParams(param3);
        retValue = objMethodElement1.equalSignature(objMethodElement2);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
        objMethodElement3.setName("name");
        retValue = objMethodElement1.equalSignature(objMethodElement3);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement3.setType(MethodElementKind.HOME_LITERAL);
        retValue = objMethodElement1.equalSignature(objMethodElement3);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_getMethodParams() {
        MethodElement objMethodElement = this.getInstance();
        String param1 = "param1";
        String param2 = "param2";
        objMethodElement.addMethodParams(param1);
        objMethodElement.addMethodParams(param2);
        List list = objMethodElement.getMethodParams();
        MethodElementTest.assertEquals((list.size() == 2 ? 1 : 0) != 0, (boolean)true);
        MethodElementTest.assertEquals((boolean)list.contains(param1), (boolean)true);
        MethodElementTest.assertEquals((boolean)list.contains(param2), (boolean)true);
    }

    public void test_getSignature() {
        MethodElement objMethodElement = this.getInstance();
        String name = "test";
        objMethodElement.setName(name);
        String param1 = "param1";
        String param2 = "param2";
        objMethodElement.addMethodParams(param1);
        objMethodElement.addMethodParams(param2);
        String signature = String.valueOf(name) + "(" + param1 + "," + param2 + ")";
        String retValue = objMethodElement.getSignature();
        MethodElementTest.assertEquals((String)signature, (String)retValue);
    }

    public void test_getTypeJavaClass() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        EList enterpriseBeans = DD.getEJBJar().getEnterpriseBeans();
        EnterpriseBean eb = (EnterpriseBean)enterpriseBeans.get(0);
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setEnterpriseBean(eb);
        JavaClass retValue = null;
        if (eb.hasRemoteClient()) {
            objMethodElement.setType(MethodElementKind.HOME_LITERAL);
            retValue = objMethodElement.getTypeJavaClass();
            MethodElementTest.assertEquals((Object)retValue, (Object)eb.getHomeInterface());
            objMethodElement.setType(MethodElementKind.REMOTE_LITERAL);
            retValue = objMethodElement.getTypeJavaClass();
            MethodElementTest.assertEquals((Object)retValue, (Object)eb.getRemoteInterface());
        }
        if (eb.hasLocalClient()) {
            objMethodElement.setType(MethodElementKind.LOCAL_HOME_LITERAL);
            retValue = objMethodElement.getTypeJavaClass();
            MethodElementTest.assertEquals((Object)retValue, (Object)eb.getLocalHomeInterface());
            objMethodElement.setType(MethodElementKind.LOCAL_LITERAL);
            retValue = objMethodElement.getTypeJavaClass();
            MethodElementTest.assertEquals((Object)retValue, (Object)eb.getLocalInterface());
        }
        if (eb.isMessageDriven()) {
            objMethodElement.setType(MethodElementKind.UNSPECIFIED_LITERAL);
            retValue = objMethodElement.getTypeJavaClass();
            MethodElementTest.assertEquals((Object)retValue, (Object)eb.getEjbClass());
        }
    }

    public void test_hasMethodParams() {
        MethodElement objMethodElement = this.getInstance();
        boolean retValue = false;
        retValue = objMethodElement.hasMethodParams();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
        String param1 = "param1";
        objMethodElement.addMethodParams(param1);
        retValue = objMethodElement.hasMethodParams();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        String param2 = "param2";
        objMethodElement.addMethodParams(param2);
        retValue = objMethodElement.hasMethodParams();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_initializeFromSignature() {
        MethodElement objMethodElement = this.getInstance();
        String signature = "setTwoParamMethod(java.lang.String,java.util.List)";
        objMethodElement.initializeFromSignature(signature);
        List list = objMethodElement.getMethodParams();
        MethodElementTest.assertEquals((list.size() == 2 ? 1 : 0) != 0, (boolean)true);
        MethodElementTest.assertEquals((boolean)list.contains("java.lang.String"), (boolean)true);
        MethodElementTest.assertEquals((boolean)list.contains("java.util.List"), (boolean)true);
        MethodElementTest.assertEquals((String)objMethodElement.getName(), (String)"setTwoParamMethod");
    }

    public void test_isDefault() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setName("test");
        boolean retValue = false;
        retValue = objMethodElement.isDefault();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
        objMethodElement.setName("*");
        retValue = objMethodElement.isDefault();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_isEquivalent() {
        MethodElement objMethodElement1 = this.getInstance();
        MethodElement objMethodElement2 = this.getInstance();
        Session session1 = this.getEjbFactory().createSession();
        Session session2 = this.getEjbFactory().createSession();
        objMethodElement1.setEnterpriseBean((EnterpriseBean)session1);
        objMethodElement2.setEnterpriseBean((EnterpriseBean)session1);
        String signature1 = "setTwoParamMethod(java.lang.String,java.util.List)";
        String signature2 = "setTwoParamMethod2(java.lang.String,java.util.List)";
        objMethodElement1.initializeFromSignature(signature1);
        objMethodElement2.initializeFromSignature(signature1);
        boolean retValue = false;
        retValue = objMethodElement1.isEquivalent(objMethodElement2);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement2.initializeFromSignature(signature2);
        retValue = objMethodElement1.isEquivalent(objMethodElement2);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
        objMethodElement2.initializeFromSignature(signature1);
        objMethodElement2.setEnterpriseBean((EnterpriseBean)session2);
        retValue = objMethodElement1.isEquivalent(objMethodElement2);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isHome() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setType(MethodElementKind.HOME_LITERAL);
        boolean retValue = false;
        retValue = objMethodElement.isHome();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement.setType(MethodElementKind.LOCAL_HOME_LITERAL);
        retValue = objMethodElement.isHome();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isRemote() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setType(MethodElementKind.REMOTE_LITERAL);
        boolean retValue = false;
        retValue = objMethodElement.isRemote();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement.setType(MethodElementKind.LOCAL_HOME_LITERAL);
        retValue = objMethodElement.isRemote();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isUnspecified() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setType(MethodElementKind.UNSPECIFIED_LITERAL);
        boolean retValue = false;
        retValue = objMethodElement.isUnspecified();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement.setType(MethodElementKind.LOCAL_HOME_LITERAL);
        retValue = objMethodElement.isUnspecified();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isLocalHome() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setType(MethodElementKind.LOCAL_HOME_LITERAL);
        boolean retValue = false;
        retValue = objMethodElement.isLocalHome();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement.setType(MethodElementKind.UNSPECIFIED_LITERAL);
        retValue = objMethodElement.isLocalHome();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isLocal() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.setType(MethodElementKind.LOCAL_LITERAL);
        boolean retValue = false;
        retValue = objMethodElement.isLocal();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement.setType(MethodElementKind.UNSPECIFIED_LITERAL);
        retValue = objMethodElement.isLocal();
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isValid() {
        MethodElement objMethodElement = this.getInstance();
        objMethodElement.isValid();
    }

    public void test_nameAndParamsEquals() {
        MethodElement objMethodElement = this.getInstance();
        Method aMethod = JavaRefFactoryImpl.getActiveFactory().createMethod();
        String name = "setTwoParamMethod";
        String param1 = "java.lang.String";
        String param2 = "java.util.List";
        JavaParameter javaParameter1 = JavaRefFactory.eINSTANCE.createJavaParameter();
        JavaClass type1 = JavaRefFactory.eINSTANCE.createClassRef("java.lang.String");
        javaParameter1.setEType((EClassifier)type1);
        JavaParameter javaParameter2 = JavaRefFactory.eINSTANCE.createJavaParameter();
        JavaClass type2 = JavaRefFactory.eINSTANCE.createClassRef("java.util.List");
        javaParameter2.setEType((EClassifier)type2);
        aMethod.setName(name);
        aMethod.getParameters().add((Object)javaParameter1);
        aMethod.getParameters().add((Object)javaParameter2);
        objMethodElement.setName(name);
        objMethodElement.addMethodParams(param1);
        objMethodElement.addMethodParams(param2);
        boolean retValue = false;
        retValue = objMethodElement.nameAndParamsEquals(aMethod);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        String name2 = "setTwoParamMethod2";
        objMethodElement.setName(name2);
        retValue = objMethodElement.nameAndParamsEquals(aMethod);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
        objMethodElement.setName(name);
        String param3 = "java.util.List";
        objMethodElement.addMethodParams(param3);
        retValue = objMethodElement.nameAndParamsEquals(aMethod);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_removeMethodParams() {
        MethodElement objMethodElement = this.getInstance();
        String param1 = "param1";
        String param2 = "param2";
        boolean retValue = false;
        objMethodElement.addMethodParams(param1);
        objMethodElement.addMethodParams(param2);
        List list = objMethodElement.getMethodParams();
        retValue = list.contains(param1);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodElement.removeMethodParams(param1);
        list = objMethodElement.getMethodParams();
        retValue = list.contains(param1);
        MethodElementTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ejb.test.MethodElementTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

