/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;

public class MethodPermissionTest
extends TestCase {
    private static final EjbFactory EJBFACTORY = EjbPackage.eINSTANCE.getEjbFactory();
    private static final CommonFactory COMMONFACTORY = CommonPackage.eINSTANCE.getCommonFactory();
    static /* synthetic */ Class class$0;

    private MethodPermission getInstance() {
        return EJBFACTORY.createMethodPermission();
    }

    public void test_MethodPermission() {
        MethodPermission tmpMethodPermission = this.getInstance();
        MethodPermissionTest.assertNotNull((Object)tmpMethodPermission);
    }

    public void test_getSecurityRole() {
        MethodPermission objMethodPermission = this.getInstance();
        SecurityRole securityRole = COMMONFACTORY.createSecurityRole();
        String securityRoleName = "testRole";
        securityRole.setRoleName(securityRoleName);
        objMethodPermission.getRoles().add((Object)securityRole);
        SecurityRole retValue = null;
        retValue = objMethodPermission.getSecurityRole(securityRoleName);
        MethodPermissionTest.assertEquals((Object)securityRole, (Object)retValue);
    }

    public void test_hasSecurityRole() {
        MethodPermission objMethodPermission = this.getInstance();
        SecurityRole securityRole = COMMONFACTORY.createSecurityRole();
        String securityRoleName = "testRole";
        securityRole.setRoleName(securityRoleName);
        objMethodPermission.getRoles().add((Object)securityRole);
        boolean retValue = objMethodPermission.hasSecurityRole(securityRole);
        MethodPermissionTest.assertEquals((boolean)retValue, (boolean)true);
        SecurityRole securityRole2 = COMMONFACTORY.createSecurityRole();
        retValue = objMethodPermission.hasSecurityRole(securityRole2);
        MethodPermissionTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_hasSecurityRole_2() {
        MethodPermission objMethodPermission = this.getInstance();
        SecurityRole securityRole = COMMONFACTORY.createSecurityRole();
        String securityRoleName = "testRole";
        securityRole.setRoleName(securityRoleName);
        objMethodPermission.getRoles().add((Object)securityRole);
        boolean retValue = objMethodPermission.hasSecurityRole(securityRoleName);
        MethodPermissionTest.assertEquals((boolean)retValue, (boolean)true);
        String securityRoleNameDoesNotExist = "testRoleDoesNotExist";
        retValue = objMethodPermission.hasSecurityRole(securityRoleNameDoesNotExist);
        MethodPermissionTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isEquivalent() {
        MethodPermission objMethodPermission1 = this.getInstance();
        MethodPermission objMethodPermission2 = this.getInstance();
        SecurityRole securityRole1 = COMMONFACTORY.createSecurityRole();
        securityRole1.setRoleName("testRole1");
        SecurityRole securityRole2 = COMMONFACTORY.createSecurityRole();
        securityRole2.setRoleName("testRole2");
        SecurityRole securityRole3 = COMMONFACTORY.createSecurityRole();
        securityRole3.setRoleName("testRole3");
        objMethodPermission1.getRoles().add((Object)securityRole1);
        objMethodPermission1.getRoles().add((Object)securityRole2);
        objMethodPermission2.getRoles().add((Object)securityRole1);
        objMethodPermission2.getRoles().add((Object)securityRole2);
        boolean retValue = objMethodPermission1.isEquivalent(objMethodPermission2);
        MethodPermissionTest.assertEquals((boolean)retValue, (boolean)true);
        objMethodPermission1.getRoles().add((Object)securityRole3);
        retValue = objMethodPermission1.isEquivalent(objMethodPermission2);
        MethodPermissionTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ejb.test.MethodPermissionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

